BEM.DOM.decl({ block: 'b-mobile-content-os', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._osVersions = this.params.osVersions;
            this._select = this.findBlockInside('select');
            this._mMobileContent = this.model.get('mobile_content');

            this._mMobileContent.on('change', function() {
                // afterCurrentEvent для полного обновления полей модели через update
                this.afterCurrentEvent(function() {
                    this._updateSelect({
                        osType: this._mMobileContent.get('os_type') || 'iOS',
                        minVersion: this._mMobileContent.get('min_os_version')
                    });
                });
            }, this);

            // когда мы заполняем данные из выбранного приложения, версии может не быть,
            // в селект подставится значение по-умолчанию, и нужно тригернуть change, чтобы оно попало в модель
            this._select.trigger('change');
        }
    },

    /**
     * Обновляет опции селекта
     * @param {Object} params
     * @param {String} params.osType
     * @param {String} params.minVersion
     */
    _updateSelect: function(params) {
        var minVersion = params.minVersion || 0,
            osType = params.osType,
            selectOptions = this._osVersions[osType].reduce(function(options, version) {
                if (+version >= +minVersion) {
                    options.push({
                        item: 'option',
                        value: version,
                        content: osType + ' ' + version
                    });
                }

                return options;
            }.bind(this), []);

        this._select.setOptions(selectOptions);
    }
});
