/**
 * Блок редактирования ссылки отслеживания
 * @param modelName
 * @param modelId
 * @param trackingHref
 */
block('b-mobile-content-tracking-href')(

    def()(function() {
        var ctx = this.ctx,
            banner = ctx.banner,
            isEditableTrackerHref = u.isEditableTrackerHref(banner.href, banner.mobileAppTrackerHref),
            maxLength = u.consts('MAX_URL_LENGTH'),
            modelData = {
                modelId: banner.modelId,
                protocol: banner.url_protocol,
                hrefLengthLeft: maxLength - banner.href.length,
                lengthExceeded: banner.href.length > maxLength,
                mobileAppTrackerHref: banner.mobileAppTrackerHref,
                href: banner.href,
                queryParams: isEditableTrackerHref ?
                    '' :
                    u.queryParamsToString(u.getDiffQueryParams(banner.href, banner.mobileAppTrackerHref))
            };

        return applyNext({
            'ctx.modelData': modelData,
            'mods.edit': isEditableTrackerHref ? 'yes' : 'no',
            'mods.mobile-app-href': banner.mobileAppTrackerHref ? 'yes' : 'no'
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-mobile-content-tracking-href',
                id: this.ctx.banner.modelId,
                data: this.ctx.modelData
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'wrap-input',
                content: [
                    apply('href'),
                    apply('numerator')
                ]
            }
        ];
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'wrap-preview',
                content: [
                    {
                        elem: 'preview-app',
                        tag: 'span',
                        mix: {
                            block: this.block,
                            elem: 'model-field',
                            js: {
                                name: 'mobileAppTrackerHref',
                                type: 'inline'
                            }
                        },
                        content: ctx.modelData.mobileAppTrackerHref
                    },
                    {
                        elem: 'preview-s',
                        elemMods: { empty: ctx.modelData.queryParams.length === 0 ? 'yes' : '' },
                        mix: {
                            block: this.block,
                            elem: 'model-field',
                            js: {
                                block: this.block,
                                elem: 'preview-s',
                                name: 'queryParamsIsEmpty',
                                type: 'mod',
                                modName: 'empty'
                            }
                        },
                        content: '&amp;'
                    },
                    {
                        elem: 'preview-query-params',
                        tag: 'span',
                        mix: {
                            block: this.block,
                            elem: 'model-field',
                            js: {
                                name: 'queryParams',
                                type: 'inline'
                            }
                        },
                        content: u.escapeHTML(ctx.modelData.queryParams)
                    },
                    (ctx.modelData.mobileAppTrackerHref ? {
                        block: 'button2',
                        mods: { theme: 'clear', size: 'xs', view: 'default', tone: 'default' },
                        attrs: { title: iget2('b-mobile-content-tracking-href', 'redaktirovat', 'Редактировать') },
                        mix: [{
                            block: 'b-mobile-content-tracking-href',
                            elem: 'edit-button'
                        }],
                        content: {
                            block: 'icon',
                            mods: { 'size-16': 'edit' },
                            mix: [
                                { block: 'button2', elem: 'icon' },
                                { block: 'b-mobile-content-tracking-href', elem: 'edit-icon' }
                            ]
                        }
                    } : undefined)
                ]
            },
            {
                elem: 'wrap-input',
                content: [
                    apply('href'),
                    {
                        block: 'input',
                        mods: {
                            type: 'input',
                            disabled: ctx.disabled ? 'yes' : ''
                        },
                        mix: [
                            {
                                block: this.block,
                                elem: 'query-params'
                            },
                            {
                                block: this.block,
                                elem: 'model-field',
                                js: {
                                    name: 'queryParams',
                                    type: 'input'
                                }
                            }
                        ],
                        value: ctx.modelData.queryParams,
                        content: { elem: 'control' }
                    },
                    apply('numerator'),
                    (ctx.modelData.mobileAppTrackerHref ? {
                        block: 'button2',
                        mods: { theme: 'clear', size: 'xs', view: 'default', tone: 'default' },
                        attrs: { title: iget2('b-mobile-content-tracking-href', 'vernutsa-k-ishodnomu', 'Вернуться к исходному') },
                        mix: [{
                            block: 'b-mobile-content-tracking-href',
                            elem: 'clear-button'
                        }],
                        content: {
                            block: 'icon',
                            mods: { 'size-16': 'rewind' },
                            mix: [
                                { block: 'button2', elem: 'icon' },
                                { block: 'b-mobile-content-tracking-href', elem: 'clear-icon' }
                            ]
                        }
                    } : undefined)
                ]
            }
        ];
    }),

    mode('numerator')(function() {
        var modelData = this.ctx.modelData;

        return {
            elem: 'numerator',
            tag: 'span',
            elemMods: { exceeded: modelData.lengthExceeded ? 'yes' : '' },
            mix: {
                block: this.block,
                elem: 'model-field',
                js: [
                    {
                        block: this.block,
                        elem: 'numerator',
                        name: 'lengthExceeded',
                        type: 'mod',
                        modName: 'exceeded'
                    },
                    {
                        name: 'hrefLengthLeft',
                        type: 'inline'
                    }
                ]
            },
            content: modelData.hrefLengthLeft || u.consts('MAX_URL_LENGTH')
        };
    }),
    mode('href')(function() {
        return {
            block: 'input',
            mods: {
                type: 'textarea',
                disabled: this.ctx.disabled ? 'yes' : ''
            },
            mix: [
                {
                    block: this.block,
                    elem: 'href'
                },
                {
                    block: this.block,
                    elem: 'model-field',
                    js: {
                        name: 'href',
                        type: 'input'
                    }
                }
            ],
            value: this.ctx.modelData.href,
            content: {
                elem: 'control',
                attrs: { rows: 5 }
            }
        };
    })
);
