BEM.DOM.decl({ block: 'b-mobile-content-tracking-href', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.model.init();

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this.model.getDM()['banner']
                .on('href', 'change', this._onDmHrefChange, this);

            this.model.getDM()['banner'].on('clear', this._onDmClear, this);

            var editButton = this.findBlockInside('edit-button', 'button2');
            if (editButton) {
                this._subscriptionManager
                    .wrap(editButton)
                    .on('click', this._onEditButtonClick, this);
            }

            var clearButton = this.findBlockInside('clear-button', 'button2');
            if (clearButton) {
                this._subscriptionManager
                    .wrap(clearButton)
                    .on('click', this._onClearButtonClick, this);
            }
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base.apply(this, arguments);
    },

    _onDmClear: function() {
        /**
         * При Очистке объявления, когда текущее значение href совпадает
         * с исходным, обработчик _onDmHrefChange не вызывается. Нужно сбросить
         * модификатор edit отдельно.
         */
        var mobileAppTrackerHref = this.model.get('mobileAppTrackerHref')

        // Пользователь без фичи или без ссылки мобильного приложения
        // никогда не выходит из режима редактирования
        if (!mobileAppTrackerHref) {
            return;
        }

        this.setMod('edit', 'no');
    },

    _onDmHrefChange: function(e, data) {
        if (data.fromVM) {
            return;
        }

        var mobileAppTrackerHref = this.model.get('mobileAppTrackerHref'),
            isHrefNotEqualMobileAppHref = u.isEditableTrackerHref(data.value, mobileAppTrackerHref);

        this.model.update({ href: data.value });

        if (!isHrefNotEqualMobileAppHref) {
            this.model.update(
                { queryParams: u.queryParamsToString(u.getDiffQueryParams(data.value, mobileAppTrackerHref)) }
            );
        }

        this.toggleMod('edit', 'yes', 'no', isHrefNotEqualMobileAppHref);
    },

    _onEditButtonClick: function() {
        this.setMod('edit', 'yes');
    },

    _onClearButtonClick: function() {
        var mobileAppTrackerHref = this.model.get('mobileAppTrackerHref'),
            href = this.model.get('href'),
            queryParamsDiff = u.getDiffQueryParams(href, mobileAppTrackerHref),
            newHrefValue = this._addParamsToUrl(mobileAppTrackerHref, queryParamsDiff),
            queryParamsString = u.queryParamsToString(queryParamsDiff);

        this.model.update(
            {
                href: newHrefValue,
                queryParams: queryParamsString
            }
        );

        this.setMod('edit', 'no');
    },

    /**
     * Добавляет к урлу параметры запроса.
     * @param {String} url Исходный урл
     * @param {Object} queryParams Хеш с парамтреми
     * @returns {String}
     */
    _addParamsToUrl: function(url, queryParams) {
        var parsed = u.parseUrl(url),
            extendedParams = u._.assign({}, parsed.query, queryParams),
            queryParamsString = u.queryParamsToString(extendedParams);

        /**
         * formatUrl формирует строку параметров не так, как queryParamsToString:
         * последний добавляет знак = для пустых параметров.
         */
        delete parsed.query;
        var urlWithoutParams = u.formatUrl(parsed);

        if (queryParamsString) {
            return urlWithoutParams + '?' + queryParamsString;
        }

        return urlWithoutParams;
    }
});
