block('b-mobile-strategy-presetting')(

    js()(true),

    def()(function() {
        var current = u['b-mobile-strategy-presetting'].getSimpleStrategyName(this.ctx.strategy.name) || 'avg-click';

        this.mods['strategy'] = current;

        return applyNext({
            current: current
        });
    }),

    content()(function() {
        var currency = this.ctx.currency,
            strategy = this.ctx.strategy,
            campaignData = this.ctx.campaignData;

        return [
            {
                elem: 'warnings',
                elemMods: {
                    hidden: 'yes'
                },
                content: [
                    iget2(
                        'b-mobile-strategy-presetting',
                        'mobile-app-has-not-tracker1',
                        'Для приложения не выбран трекер, поэтому мы сможем считать только клики. Добавьте трекер и оптимизируйте стоимость установки! '
                    ),
                    {
                        elem: 'button-wrap',
                        content: {
                            block: 'button2',
                            mods: {
                                theme: 'normal',
                                size: 's',
                                type: 'link'
                            },
                            mix: {
                                block: this.block,
                                elem: 'warning-button'
                            },
                            target: '_blank',
                            url: u.formatUrl({
                                path: '/registered/main.pl/mobile-apps/list',
                                query: {
                                    cmd: 'appList',
                                    ulogin: u.consts('ulogin')
                                }
                            }),
                            text: iget2('b-strategy2-settings', 'edit-url', 'Перейти к списку приложений')
                        }
                    }
                ]
            },
            {
                elem: 'settings',
                content: [
                    {
                        block: 'radiobox',
                        mix: [
                            {
                                block: this.block,
                                elem: 'radiobox'
                            }
                        ],
                        mods: { theme: 'normal', size: 's' },
                        name: 'strategy',
                        value: this.current,
                        content: [
                            {
                                block: this.block,
                                elem: 'avg-cpi-label',
                                content: {
                                    block: 'radiobox',
                                    elem: 'radio',
                                    elemMods: {
                                        value: 'avg-cpi'
                                    },
                                    content: iget2('b-mobile-strategy-presetting', 'avg-cpi-label-2', 'Удерживать стоимость установки'),
                                    controlAttrs: {
                                        value: 'avg-cpi'
                                    }
                                }
                            },
                            {
                                block: this.block,
                                elem: 'avg-cpi-controls',
                                content: [
                                    {
                                        block: 'b-strategy-setting',
                                        mods: {
                                            name: 'cpi'
                                        },
                                        js: true,
                                        value: strategy.name === 'autobudget_avg_cpi' ? strategy.options.avg_cpi : null,
                                        currency: currency,
                                        rmpCounters: campaignData.rmpCounters
                                    }
                                ]
                            },
                            {
                                block: this.block,
                                elem: 'avg-click-label',
                                content: {
                                    block: 'radiobox',
                                    elem: 'radio',
                                    elemMods: {
                                        value: 'avg-click'
                                    },
                                    content: iget2('b-mobile-strategy-presetting', 'avg-click-label-2', 'Удерживать цену клика'),
                                    controlAttrs: {
                                        value: 'avg-click'
                                    }
                                }
                            },
                            {
                                block: this.block,
                                elem: 'avg-click-controls',
                                content: [
                                    {
                                        block: 'b-strategy-setting',
                                        mods: {
                                            name: 'avg-click'
                                        },
                                        js: true,
                                        value: strategy.name === 'autobudget_avg_click' ? strategy.options.avg_bid : null,
                                        currency: currency
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    })

);
