BEM.DOM.decl({ block: 'b-mobile-strategy-presetting' }, {

    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            this._controlsMapping = {
                'avg-click': this.blockInside({ block: 'b-strategy-setting', modName: 'name', modVal: 'avg-click' }),
                'avg-cpi': this.blockInside({ block: 'b-strategy-setting', modName: 'name', modVal: 'cpi' })
            };
        }
    },

    /**
     * Проверяет текущее состояние блока на "валидность"
     * @return {*}
     */
    isValid: function() {
        var currentVal = this.blockInside('radiobox').val();

        return this._getControlByStrategyName(currentVal).validate();
    },

    /**
     * Выставляет выбранную стратегию в блоке
     * @param {String} name
     */
    setSelected: function(name) {
        this.blockInside('radiobox').val(name);
        this.trigger('update', this._getControlByStrategyName(name).getValue());
    },

    /**
     * Выключает стратегии
     * @param {Array<'avg-click'|'avg-cpi'>} names - Список стартегий, которые нужно отключить (остальные включаться)
     */
    setDisabledStrategies: function(names) {

        this.blockInside('radiobox').elem('radio').each(function(i, elem) {
            var elemValue = this.blockInside('radiobox').getMod($(elem), 'value');

            if (names.indexOf(elemValue) !== -1) {
                this.blockInside('radiobox').setMod($(elem), 'disabled', 'yes');
            } else {
                this.blockInside('radiobox').delMod($(elem), 'disabled');
            }

        }.bind(this));

        if (names.indexOf('avg-cpi') !== -1) {
            this.delMod(this.elem('warnings'), 'hidden');
        } else {
            this.setMod(this.elem('warnings'), 'hidden', 'yes');
        }
    },

    /**
     * Возвращает контрол управления стартегией по ее названию
     * @param {String} name - название стратегии
     * @return {*}
     * @private
     */
    _getControlByStrategyName: function(name) {
        return this._controlsMapping[name];
    },

    /**
     * Обработчик изменения радигокнопок
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onRadioChange: function(e, data) {
        this.setMod('strategy', data.currentVal);

        this.trigger('update', this._getControlByStrategyName(data.currentVal).getValue());
    },

    /**
     * Обработчик изменения настроек стратегии
     * @param {Event} e
     * @param {Object} data - данные модели
     * @private
     */
    _onStrategyUpdate: function(e, data) {
        this.trigger('update', data);
    }

}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'radiobox', function(e, data) {
                this._onRadioChange(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'b-strategy-setting', function(e, data) {
                this._onStrategyUpdate(e, data);
            })
    }
});
