BEM.DOM.decl('b-modal-popup-decorator', {}, {
    /**
     * Создаёт блок-декоратор модального попапа
     * Копипаста метода create, но добавлен третий параметр - $
     * Он нужен для случая, когда попап открывается изнутри iframe; мы зовем $(blockBEMJSON).bem(blockName)
     * Если $ будет из window.top, то блок создастся в контексте родительского окна и не будет шарить, например, модели
     * @todo портировать в bricks https://st.yandex-team.ru/DIRECT-77231
     *
     * @param {Object} [mods] Модификаторы блока декоратора
     * @param {Object} [options] Дополнительные параметры
     * @param {Boolean} [options.hasClose] - Показывать крестик (по умолчанию true)
     * @param {Boolean} [options.bodyScroll] - Возможность прокрутки страницы, когда открыт попап (по умолчанию true)
     * @param {Boolean} [options.childState] - Включает добавление модификатора child-shown, если внутри открыт дочерний popup
     * @param {jQuery} [$] - jQuery, .bem которой будет использоваться для инициализации блока
     * @returns {BEM.DOM<b-modal-popup-decorator>}
     */
    create2: function(mods, options, $) {
        var blockName = this.getName(),
            defaults = { hasClose: true, bodyScroll: true, childState: false, offset: 20 },
            opts = u._.extend(defaults, options);

        return $(BEMHTML.apply({
            block: blockName,
            mods: mods,
            bodyScroll: opts.bodyScroll,
            hasClose: opts.hasClose,
            childState: opts.childState,
            offset: opts.offset
        })).bem(blockName);
    }
});
