/**
 * Блок для открытия модального попапа
 * @param {String} ctx.text текст ссылки
 * @param {String} ctx.url адрес, который нужно загрузить для отображения
 * @param {Boolean} [ctx.stretched=false] флаг для растягивания контента внутри попапа (без отступов, для тех случаев, когда хэлп страница имеет свои отступы)
 * @param {Boolean} [ctx.padding=false] флаг выставляющий отступы для окна
 * @param {Boolean} [ctx.inactive=false] флаг неактивной ссылки
 * @param {String} [ctx.title] подсказка псевдоссылки при наведении
 * @param {Number|String} [ctx.width='70%'] ширина модального попапа или нативного окна
 * @param {Number|String} [ctx.height='80%'] высота модального попапа или нативного окна
 * @param {Object} [ctx.windowParams] хэш со значениями ширины и высоты нативного окна, если нужно сделать его размеры отличными от модального попапа
 * @param {Number} [ctx.windowParams.width] ширина нативного окна
 * @param {Number} [ctx.windowParams.height] высота нативного окна
 * @param {Boolean} [ctx.noNewWindow=false] флаг запрета показа ссылки "Открыть в новом окне"
 * @param {Boolean} [ctx.useNativeWindow=false] флаг для открытия через нативный попап
 * @param {String} [ctx.scrolling] значение атрибута scrolling для iframe
 */
block('b-modal-popup-opener')(

    def()(function() {
        var ctx = this.ctx;

        return applyCtx({
            block: 'link',
            mods: {
                pseudo: 'yes',
                inner: 'yes',
                theme: this.mods.theme || '',
                disabled: ctx.disabled
            },
            mix: [].concat(ctx.mix || [], apply('opener-mix')),
            attrs: { title: ctx.title },
            content: ctx.text
        });
    }),

    mode('opener-mix')(function() {
        return {
            block: 'b-modal-popup-opener',
            mods: this.mods,
            js: this.ctx.inactive ?
                false :
                u._.pick(
                    this.ctx,
                    [
                        'url', 'width', 'height', 'useNativeWindow', 'stretched',
                        'padding', 'noNewWindow', 'scrolling', 'windowParams'
                    ])
        }
    }),

    elem('inner').tag()('span'),

    elem('popup').def()(function() {
        return applyCtx({
            block: 'popup',
            mods: {
                type: 'modal',
                'has-close': 'yes',
                'body-scroll': 'no',
                position: 'fixed'
            },
            mix: [{
                block: 'b-modal-popup-opener',
                elem: 'popup'
            }],
            underMods: { type: 'paranja' },
            content: [{
                elem: 'content',
                mix: [{
                    block: 'b-modal-popup-opener',
                    elem: 'popup-content',
                    elemMods: {
                        stretched: this.ctx.params.stretched ? 'yes' : '',
                        padding: this.ctx.params.padding ? 'yes' : ''
                    }
                }],
                content: this.ctx.content || ''
            }]
        });
    }),

    elem('target-blank').replace()(function() {
        return {
            block: 'link',
            mods: {
                pseudo: 'yes',
                inner: 'yes'
            },
            mix: [
                {
                    block: 'b-modal-popup-opener',
                    elem: 'target-blank'
                },
                {
                    block: 'popup',
                    elem: 'target-blank'
                }
            ],
            content: [
                {
                    block: 'icon',
                    mods: { 'size-16': 'target-blank' },
                    mix: [{ block: 'link', elem: 'icon' }]
                },
                {
                    elem: 'inner',
                    content: iget2('b-modal-popup-opener', 'otkryt-v-novom-okne', 'Открыть в новом окне')
                }
            ]
        };
    })
);
