block('b-model-form-error')(
    elem('text').tag()('span'),

    js()(function() {
        var ctx = this.ctx,
            modelId = ctx.modelParams ? ctx.modelParams.id : ctx.modelId,
            modelName = ctx.modelParams ? ctx.modelParams.name : ctx.modelName,
            field = ctx.field;

        return ctx.modelParams ?
            {
                id: 'error-' + modelName + '-' + modelId + '-' + field,
                modelParams: ctx.modelParams,
                field: field,
                validateOnChange: ctx.validateOnChange
            } :
            {
                id: 'error-' + modelName + '-' + modelId + '-' + field,
                modelId: modelId,
                modelName: modelName,
                field: field,
                validateOnChange: ctx.validateOnChange
            };
    }),

    match(function() {
        return this.ctx.errors && this.ctx.errors.length;
    }).def()(function() {
        return applyNext({
            'mods.with-error': 'yes',
            'mods.cut': this.ctx.errors.length > 1 && this.ctx.cutText ? 'yes' : 'no'
        });
    }),

    content()(function() {
        var ctx = this.ctx,
            errors = ctx.errors || [],
            needCut = errors.length > 1 && ctx.cutText;

        return this.ctx.content || [
            needCut && {
                elem: 'cut-text',
                content: ctx.cutText
            },
            needCut && {
                block: 'link',
                mods: { pseudo: 'yes' },
                mix: [{
                    block: 'b-model-form-error',
                    elem: 'show-cut'
                }],
                content: iget2('b-model-form-error', 'podrobnee', 'подробнее')
            },
            {
                elem: 'errors',
                content: errors.map(function(error) {
                    return u.escapeHTML(error);
                }).join('<br/>')
            },
            needCut && {
                block: 'link',
                mods: { pseudo: 'yes' },
                mix: [{
                    block: 'b-model-form-error',
                    elem: 'hide-cut'
                }],
                content: iget2('b-model-form-error', 'skryt', 'скрыть')
            }
        ];
    })
);
