BEM.DOM.decl('b-model-form-error', {
    onSetMod: {
        js: function() {
            var params = this.params,
                field = params.field,
                modelParams = params.modelParams || { name: params.modelName, id: params.modelId },
                showCutEl = this.findBlockOn('show-cut', 'link'),
                hideCutEl = this.findBlockOn('hide-cut', 'link');

            // модель может быть еще не создана при инициализации блока
            BEM.MODEL
                .on(modelParams, field, 'change', function(e, data) {
                    //в тестах могут быть фейковые триггеры, когда this.domElem еще нет
                    if (this.domElem && !data.ignore) {
                        if (params.validateOnChange) {
                            data.source.model.validate('general_limit_price').valid && this.delMod('with-error');
                        } else {
                            this.delMod('with-error')
                        }
                    }
                }, this)
                .on(modelParams, field, 'error', function(e, error) {
                    var errorText = error.text || error.rule;

                    this.elem('errors').html(typeof errorText === 'object' ? BEMHTML.apply(errorText) : errorText);

                    this.setMod('with-error', 'yes');

                    showCutEl && this.setMod('cut', 'yes');
                }, this);

            showCutEl && showCutEl.on('click', function() {
                this.setMod('cut', 'no');
            }, this);

            hideCutEl && hideCutEl.on('click', function() {
                this.setMod('cut', 'yes');
            }, this);
        }
    }
});
