block('b-moderation-doc-informer').elem('thematics').content()(function() {
    var thematicsList = this.ctx.thematicsList,
        count = thematicsList.length,
        chunkSize = Math.ceil(count / (this.ctx.columnsCount || 3)),
        splitList = chunkSize > 1,
        thematicsChunks;

    thematicsChunks = u._.chunk(thematicsList, splitList ? chunkSize : count);

    return thematicsChunks.map(function(thematicsChunk) {
        return {
            block: 'b-list',
            mods: { style: 'marker' },
            mix: {
                block: 'b-moderation-doc-informer',
                elem: 'floating-list'
            },
            content: [
                {
                    elem: 'list',
                    mix: {
                        block: 'b-moderation-doc-informer',
                        elem: 'list'
                    },
                    content: thematicsChunk.map(function(thematics) {
                        return {
                            elem: 'item',
                            mix: {
                                block: 'b-moderation-doc-informer',
                                elem: 'list-item'
                            },
                            content: [
                                u['b-moderation-doc-informer'].getThematicsText(thematics),
                                {
                                    block: 'b-help-link',
                                    mods: {
                                        align: 'top',
                                        type: 'modal'
                                    },
                                    stretched: true,
                                    icon: 'question',
                                    url: u.getHelpUrl(u['b-moderation-doc-informer'].getThematicsHelp(thematics))
                                }
                            ]
                        };
                    })
                }
            ]
        };
    });
});
