block('b-moderation-doc-informer')(

    def()(function() {
        var noDocs = this.ctx.moderationDocs === undefined || this.ctx.moderationDocs.length === 0;

        return applyNext({
            'mods.hidden': !noDocs ? this.mods.hidden : 'yes'
        });
    }),

    js()(function() {
        return {
            columnsCount: this.ctx.columnsCount,
            cid: this.ctx.campaign && this.ctx.campaign.cid,
            mediaType: this.ctx.campaign && this.ctx.campaign.mediaType
        };
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'requirement-notice',
                content: {
                    block: 'icon-text',
                    mix: {
                        block: 'b-moderation-doc-informer',
                        elem: 'notice-icon-text'
                    },
                    mods: { size: 's', theme: 'alert' },
                    mixes: {
                        icon: {
                            block: 'b-moderation-doc-informer',
                            elem: 'notice-icon'
                        }
                    },
                    text: iget2(
                        'b-moderation-doc-informer',
                        'nekotorye-kategorii-tovarov-i-uslug',
                        'Некоторые категории товаров и услуг можно рекламировать только при соблюдении требований законодательства и политики Яндекса.')

                }
            },
            {
                elem: 'details',
                moderationDocs: ctx.moderationDocs,
                columnsCount: ctx.columnsCount,
                mediaType: ctx.mediaType
            }
        ];
    }),

    elem('details').match(function() {
        return this.ctx.moderationDocs;
    }).content()(function() {
        return {
            elem: 'details-info',
            moderationDocs: this.ctx.moderationDocs,
            columnsCount: this.ctx.columnsCount,
            mediaType: this.ctx.mediaType,
        };
    })
);
