BEM.DOM.decl('b-moderation-reject', {

    /**
     * Показывает попап с причинами отклонения
     */
    showPopup: function() {
        var params = this.params,
            _this = this;

        this._getPopup()
            .setContent(BEMHTML.apply(
                {
                    block: 'b-quality-verdicts-list',
                    elem: 'spinner',
                    content: {
                        block: 'spin2',
                        js: true,
                        mods: {
                            size: 's',
                            progress: 'yes',
                        }
                    }
                }
            )).show(this.domElem);

        this
            ._receiveReasonsData(params.bid, params.additionsItemsIds)
            .then(function(data) {
                // если есть новые причины отклонения (наши или от операторов) - получаем из API хелпа контент для отображения
                if (Object.keys(data.operatorsReasons.reasons).length || data.reasonsWithNoTokens.length ) {
                    var result = {
                            commonLinks: data.commonLinks,
                            verdicts: data.verdicts,
                        },
                        reasonsForHelpAPI = data.reasonsWithNoTokens.concat(Object.keys(data.operatorsReasons.reasons));

                    return BEM.blocks['i-web-api-request'].moderationReason.getModerationDeclineReasonsContent(reasonsForHelpAPI)
                        .then(function(response) {

                            if (data.reasonsWithNoTokens && data.reasonsWithNoTokens.length) {
                                result.moderationRejectReasons = _this._parseModerationReasons(
                                    data.reasonsWithNoTokens,
                                    response.reasons,
                                    response.errors
                                );
                            }

                            result.operatorsRejectReasons =
                                _this._parseOperatorReasons(
                                    data.operatorsReasons.operators,
                                    response.reasons,
                                    data.operatorsReasons.comments
                                );

                            return result;
                        })
                }
                return data;
            })
            .then(function(data) {
                this._getPopup()
                    .setContent(BEMHTML.apply({
                        block: 'b-quality-verdicts-list',
                        mods: { type: 'moderation' },
                        mix: { block: 'b-moderation-reject', elem: 'verdicts-list' },
                        verdicts: data.verdicts,
                        commonLinks: data.commonLinks,
                        operatorsRejectReasons: data.operatorsRejectReasons,
                        moderationRejectReasons: data.moderationRejectReasons,
                    }))
                    .show(this.domElem);
            }.bind(this));
    },

    /**
     * Получает данные о причинах отклонения
     * @param {String|Number} bid
     * @param {String|Number} [additionsItemsIds]
     * @private
     */
    _receiveReasonsData: function(bid, additionsItemsIds) {
        var objectType = this.params.objectType,
            _this = this,
            /**
             * Флаг в причинах отклонений означает, что текст для этой причины нужно брать в API хелпа с помощью
             * BEM.blocks['i-web-api-request'].moderationReason.getModerationDeclineReasonsContent
             * @type {string}
             */
            GRAB_FROM_HELP_API_FLAG = 'grab_tooltip';

        return new Promise(function(resolve, reject) {
            _this._getRequest().get(
                {
                    cmd: 'showDiag',
                    additions_item_id: (additionsItemsIds || []).join(','),
                    bid: bid
                },
                function(data) {

                    var bannerDiags = u._.pick(
                            data.banner_diags,
                        [
                            'banner', 'contactinfo', 'image', 'phrases', 'sitelinks_set',
                            'display_href', 'video_addition', 'turbolanding'
                        ]
                        ),
                        calloutDiags = data.callout_diags,
                        verdictsInfo = u['b-moderation-reject'].getVerdictsWithCommonLinks(
                            bid,
                            {
                                manager: data.manager_info,
                                agency: data.agency_info,
                                agencyManager: data.agency_manager
                            },
                            objectType
                        ),
                        verdicts = verdictsInfo.verdicts,
                        reasons = [],
                        otherReasons = [],
                        /**
                         * Объект для новых причин отклонения модерации
                         * @param {Object} newModerationDeclineReasons объект, где в ключах id, в значениях - заголовки
                         */
                        newModerationDeclineReasons = {},
                        operatorsDeclineReasons = {
                            operators: {},
                            reasons: {},
                            comments: {}
                        };

                    // анализируем типы причин отклонения (https://st.yandex-team.ru/DIRECT-92138)
                    if (data.bad_banner_pages) {
                        u._.forOwn(data.bad_banner_pages, function(operator, id) { // дубли причин у разных операторов не убираем
                            var key = id + ': ' + operator.page_name;

                            !operatorsDeclineReasons.operators[key] && (operatorsDeclineReasons.operators[key] = []);
                            !operatorsDeclineReasons.comments[key] && (operatorsDeclineReasons.comments[key] = []);

                            operatorsDeclineReasons.comments[key] = operator.operator_comment;

                            operator.reasons.forEach(function(reason) {
                                operatorsDeclineReasons.operators[key].push(reason.diag_id);
                                operatorsDeclineReasons.reasons[reason.diag_id] = reason.diag_id;
                            })
                        })
                    }

                    [bannerDiags, calloutDiags].forEach(function(diags) {
                        u._.forOwn(diags, function(list) {
                            list.forEach(function(diag) {
                                // не исключаем, что причины отклонеия модератором будут приходить новые, и нужно будет получать тексты для них из API хелпа
                                // исключаем те причины, которые вошли в число operatorsDeclineReasons
                                if (diag[GRAB_FROM_HELP_API_FLAG] && !operatorsDeclineReasons.reasons[diag.diag_id]) {
                                    newModerationDeclineReasons[diag.diag_id] = diag.diag_text;
                                }

                                var token = (diag.token || 'other').replace(/\s/g, '-').toLowerCase(),
                                    useOld = token === 'other',
                                    reason = useOld ? diag.diag_text : verdicts[token],
                                    reasonsList = useOld ? otherReasons : reasons;

                                if (reason &&
                                    reasonsList.indexOf(reason) == -1 &&
                                    !diag[GRAB_FROM_HELP_API_FLAG]) {
                                    reasonsList.push(reason);
                                }
                            });
                        });
                    });

                    // в этой причине текст приходит из модерации
                    if (otherReasons.length) {
                        reasons.push(u._.extend({ type: 'old' }, verdicts.other, {
                            recommendation: {
                                block: 'b-quality-verdicts-list',
                                elem: 'verdict-old-recommendation-list',
                                content: otherReasons.map(function(reason) {
                                    return {
                                        block: 'b-quality-verdicts-list',
                                        elem: 'verdict-recommendation',
                                        mods: { type: 'old' },
                                        content: u.urlify(reason, function(url) {
                                            return BEMHTML.apply({
                                                block: 'link',
                                                url: url,
                                                attrs: { target: '_blank' },
                                                content: url
                                            });
                                        })
                                    };
                                })
                            }
                        }));
                    }

                    if (
                        u._.isEmpty(bannerDiags) &&
                        u._.isEmpty(calloutDiags) &&
                        u._.isEmpty(operatorsDeclineReasons.operators)
                    ) {
                        reasons.push(verdicts['general-for-empty-reason']);
                    }

                    resolve({
                        operatorsReasons: operatorsDeclineReasons,
                        reasonsWithNoTokens: Object.keys(newModerationDeclineReasons),
                        verdicts: reasons,
                        commonLinks: verdictsInfo.commonLinks,
                    });

                },
                function(err) {
                    reject(err);
                }
            );
        });
    },

    /**
     * Возвращает уже созданный попап, если его нету, то создает новый
     * @returns {BEM.DOM<popup>}
     * @private
     */
    _getPopup: function() {
        if (!this._popup) {
            BEM.DOM.append(this.domElem, BEMHTML.apply({
                block: 'popup',
                mods: { 'has-close': 'yes', adaptive: 'yes' },
                js: { directions: ['right', 'left'] },
                content: [
                    { elem: 'tail' },
                    { elem: 'content' }
                ]
            }));

            this._popup = this.findBlockInside('popup');
        }

        return this._popup;
    },

    /**
     * Создаёт кэшируемый объект запроса
     * @returns {BEM<i-request_type_ajax>}
     * @private
     */
    _getRequest: function() {
        return this.__self._request || (this.__self._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json'
        }));
    },

    _parseReason: function(parsedReason) {
        var div = document.createElement('div');

        div.innerHTML = parsedReason.selector['.title'];

        return {
            content: parsedReason.content,
            title: div.textContent
        };
    },

    /**
     * Парсит объект с ответом от java - ручки с контентом для новых причин отклонения модерации в массив объектов с
     * заголовками содержимым для отображения
     * @param {String[]} reasonsWithNoTokens список причин отклонения операторов
     * @param {Object} reasons ответ ручки
     * @private
     */

    _parseModerationReasons: function(reasonsWithNoTokens, reasons, errros) {
        var hasErrors = !!(errros || []).length,
            content = { hasErrors: hasErrors },
            filteredReasons;

        // отбираем только причины из числа причин отклонения модерацией
        filteredReasons = Object.keys(reasons).filter(function(reason) {
            return reasonsWithNoTokens.indexOf(reason) !== -1;
        });

        content.reasons = filteredReasons
            .map(function(reason) {
                var parsedReason = this._parseReason(JSON.parse(reasons[reason])),
                    content = parsedReason.content,
                    title = parsedReason.title;

                return {
                    id: reason,
                    content: content,
                    title: title
                }
            }, this);
        return content;
    },

    /**
     * Парсит объект с ответом от java - ручки, восстанавливает разбиентие по операторам
     * @param {Object} operators объект с операторами и кодами причин
     * @param {Object} reasons объект с причинами операторов или ошибками
     * @param {Object} comments объект с комментариями операторов
     * @private
     */
    _parseOperatorReasons: function(operators, reasons, comments) {
        var contentByOperators = {},
            dict = {};

        // парсим словарь причин
        Object.keys(reasons).forEach(function(reason) {
            var parsedReason = this._parseReason(JSON.parse(reasons[reason]));
            dict[reason] = {
                content: parsedReason.content,
                title: parsedReason.title
            }
        }, this);

        Object.keys(operators).forEach(function(operator) {
            contentByOperators[operator] = {
                reasons: [],
                comment: undefined,
                hasErrors: false
            };
            operators[operator].forEach(function(id) {
                if (comments[operator]) {
                    contentByOperators[operator].comment = comments[operator];
                }
                if (dict[id]) {
                    contentByOperators[operator].reasons.push(dict[id])
                } else {
                    contentByOperators[operator].hasErrors = true;
                }
            });
        }, this);
        return contentByOperators;
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function() {
            this.showPopup();
        });
    }

});
