block('b-modify-user').elem('api-settings').content()(function() {
    var data = this.data,
        userRoleIs = function( /*roles...*/ ) {
            return Array.prototype.slice.call(arguments).some(function(role) {
                return data.user_role === role;
            });
        },
        commonHiddenInputs = this.ctx.commonHiddenInputs,
        identity = function(obj) {
            return obj;
        },
        checked = function(value) {
            return value ? 'yes' : '';
        }, //конвертирует булево значение в yes/пустую строку
        inputControl = function(value) {
            return {
                elem: 'control',
                attrs: {
                    value: (typeof value == 'string' || typeof value == 'number') ? value : ''
                }
            };
        },
        apiEnabledOptions = [
            {
                value: 'Default',
                title: iget2('b-modify-user', 'po-umolchaniyu', 'По умолчанию')
            },
            {
                value: 'Yes',
                title: iget2('b-modify-user', 'vklyuchen', 'Включен')
            },
            {
                value: 'No',
                title: iget2('b-modify-user', 'vyklyuchen', 'Выключен')
            }
        ],
        contentElems = [
            {
                label: {
                    content: iget2('b-modify-user', 'dostup-k-api', 'Доступ к API:'),
                    for: 'api_enabled_id'
                },
                control: [
                    ((hasLoginRights('is_any_teamleader') && userRoleIs('manager')) ||
                        (hasLoginRights('manager_control') && (userRoleIs('agency') || data.user_is_any_client))) &&
                        {
                            block: 'b-modify-user',
                            elem: 'api-enabled',
                            content: data.can_use_api ? iget2('b-modify-user', 'vklyuchen', 'Включен') : iget2('b-modify-user', 'vyklyuchen', 'Выключен')
                        },
                    hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') && {
                        block: 'select',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                name: 'api_enabled',
                                type: 'select'
                            }
                        }],
                        name: 'api_enabled',
                        content: [
                            {
                                block: 'button',
                                mix: {
                                    block: 'select',
                                    elem: 'button'
                                },
                                content: (data.api_enabled ? apiEnabledOptions.filter(function(option) {
                                    return option.value === data.api_enabled;
                                }, this).pop() : apiEnabledOptions[0]).title
                            },
                            {
                                elem: 'control',
                                content: apiEnabledOptions.map(function(option) {
                                    var result = {
                                        elem: 'option',
                                        attrs: {
                                            value: option.value
                                        },
                                        content: option.title
                                    };

                                    option.value === data.api_enabled && (result.attrs.selected = 'selected');

                                    return result;
                                }, this),
                                attrs: {
                                    id: 'api_enabled_id'
                                }
                            }
                        ]
                    }
                ]
            },
            {
                label: iget2('b-modify-user', 'limit-zaprosov-k-advq', 'Лимит запросов к AdvQ из API'),
                control: {
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'advq_queries_lim'
                            }
                        }
                    ],
                    name: 'advq_queries_lim',
                    content: inputControl(data.advq_queries_lim || '')
                }
            }
        ],
        methods = Array.isArray(data.methods) ? data.methods : [data.methods],
        originalEscape = u.escapeHTML,
        result;

    //убрать, когда появится исправленная версия
    u.escapeHTML = function(str) {
        if (typeof str != 'string' && typeof str != 'number') return '';
        str = '' + str;
        return str.replace(/[&<>\"\']/g,
            function(c) {
                return '&#' + c.charCodeAt(0) + ';';
            });
    };

    if (hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control')) {
        contentElems.push({
            label: iget2('b-modify-user', 'kol-vo-dostupnyh-otchetov', 'Кол-во доступных отчетов в CreateNewReport'),
            control: {
                block: 'input',
                mix: [
                    {
                        block: 'b-modify-user',
                        elem: 'inline-input',
                        elemMods: {
                            type: 'small'
                        }
                    },
                    {
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'input',
                            name: 'api_reports_limit'
                        }
                    }
                ],
                name: 'api_reports_limit',
                content: inputControl(data.api_reports_limit || '')
            }
        });
        contentElems.push({
            label: iget2('b-modify-user', 'prioritet-dlya-obrabotki-v', 'Приоритет для обработки в очереди запросов в ADVQ'),
            control: {
                block: 'input',
                mix: [
                    {
                        block: 'b-modify-user',
                        elem: 'inline-input',
                        elemMods: {
                            type: 'small'
                        }
                    },
                    {
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'input',
                            name: 'advq_report_queue_priority'
                        }
                    }
                ],
                name: 'advq_report_queue_priority',
                content: inputControl(data.advq_report_queue_priority || '')
            }
        });

        var innerElems = hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') ? [
            {
                block: 'b-modify-user',
                elem: 'method-limits-container',
                content: [{
                    block: 'select',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'methods-select'
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'inline-control'
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'select',
                                name: 'current-method-limit-name'
                            }
                        }
                    ],
                    name: 'methods',
                    content: [
                        {
                            block: 'button',
                            content: methods[0]
                        },
                        {
                            elem: 'control',
                            content: methods.map(function(method, index) {
                                var result = {
                                    elem: 'option',
                                    attrs: {
                                        value: method
                                    },
                                    content: method
                                };
                                if (index === 0) {
                                    result.attrs.selected = 'selected';
                                }
                                return result;
                            })
                        }
                    ]
                },
                    {
                        block: 'input',
                        mix: [
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'input',
                                    name: 'current-method-limit-value'
                                }
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'method-limit-input'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'inline-control'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'inline-input',
                                elemMods: {
                                    type: 'small'
                                }
                            }
                        ],
                        name: 'method_limit',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'id_method_limit',
                                value: data.method_limits ? data.method_limits[methods[0]] : ''
                            }
                        }
                    },
                    {
                        block: 'button',
                        mix: [
                            {
                                block: 'b-modify-user',
                                elem: 'method-limit-set'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'inline-control'
                            }
                        ],
                        mods: {
                            disabled: 'yes'
                        },
                        content: iget2('b-modify-user', 'ustanovit', 'Установить')
                    },
                    {
                        block: 'button',
                        mix: [
                            {
                                block: 'b-modify-user',
                                elem: 'method-limit-reset'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'inline-control'
                            }
                        ],
                        mods: {
                            disabled: (data.method_limits && data.method_limits[methods[0]]) ? '' : 'yes'
                        },
                        content: iget2('b-modify-user', 'sbrosit', 'Сбросить')
                    }]
            }
        ] : [];

        innerElems.push({
            block: 'b-modify-user',
            elem: 'dropdown-holder',
            content: {
                block: 'dropdown',
                content: [
                    {
                        block: 'button',
                        mods: {
                            pseudo: 'yes'
                        },
                        mix: [
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'show-limits'
                            }
                        ],
                        content: iget2('b-modify-user', 'posmotret-tekushchie-ogranicheniya', 'Посмотреть текущие ограничения')
                    },
                    {
                        elem: 'popup',
                        mix: [{
                            block: 'b-modify-user',
                            elem: 'limits-popup'
                        }],
                        content: [
                            {
                                block: 'b-modify-user',
                                elem: 'empty-limits-label',
                                elemMods: {
                                    show: Object.keys(data.method_limits || {}).length === 0 ? 'yes' : 'no'
                                },
                                content: iget2('b-modify-user', 'ogranicheniya-vyzovov-ne-zadany', 'Ограничения вызовов не заданы')
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'limits-list',
                                content: Object.keys(data.method_limits || {}).map(function(key) {
                                    return {
                                        block: 'b-modify-user',
                                        elem: 'limits-list-item',
                                        content: key + ': ' + data.method_limits[key]
                                    };
                                }, this)
                            }
                        ]
                    }
                ]
            }
        });

        contentElems.push({
            label: {
                content: iget2('b-modify-user', 'izmenit-ogranicheniya-vyzovov', 'Изменить ограничения вызовов:'),
                attrs: {
                    for: 'id_method_limit'
                }
            },
            control: innerElems,
            mix: [{
                block: 'b-modify-user',
                elem: 'methods-limits'
            }]
        });

        contentElems.push.apply(contentElems, [
            {
                label: {
                    tag: 'label',
                    content: iget2('b-modify-user', 'kolichestvo-odnovremennyh-vyzovov', 'Количество одновременных вызовов'),
                    attrs: {
                        for: 'id_concurrent_calls'
                    }
                },
                control: {
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'concurrent-calls'
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'concurrent-calls'
                            }
                        }
                    ],
                    name: 'concurrent_calls',
                    content: {
                        elem: 'control',
                        attrs: {
                            id: 'id_concurrent_calls',
                            value: data.concurrent_calls || ''
                        }
                    }
                }
            },
            {
                label: iget2('b-modify-user', 'minimalnoe-ogranichenie-na-pul', 'Минимальное ограничение на пул картинок'),
                control: {
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'image-pool-limit'
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'image_pool_limit'
                            }
                        }
                    ],
                    name: 'image_pool_limit',
                    content: inputControl(data.image_pool_limit || 0)
                }
            },
            {
                label: iget2('b-modify-user', 'ruchnoe-upravlenie-ballami', 'Ручное управление баллами'),
                control: {
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'api-units-daily'
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'api_units_daily'
                            }
                        }
                    ],
                    name: 'api_units_daily',
                    content: inputControl(data.api_units_daily || 0)
                }
            },
            {
                label: iget2('b-modify-user', 'limit-ballov-api5-na', 'Лимит баллов API5 на сегодня'),
                control: [{
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'API5_units_limit'
                            }
                        }
                    ],
                    name: 'API5_units_limit',
                    content: inputControl(data.API5_units_limit)
                }, {
                    block: 'b-modify-user',
                    elem: 'api-units-hint',
                    content: [iget2('b-modify-user', 'izrashodovano', 'израсходовано'), ' ', u.escapeHTML(data.API5_today_spent)]
                }]
            },
            {
                label: iget2('b-modify-user', 'ostatok-ballov-api-na', 'Остаток баллов API (на сегодня)'),
                control: [{
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'API_units'
                            }
                        }
                    ],
                    name: 'API_units',
                    content: inputControl(data.API_units)
                }, {
                    block: 'b-modify-user',
                    elem: 'api-units-hint',
                    content: [iget2('b-modify-user', 'iz', 'из'), ' ', u.escapeHTML(data.API_daily_units)]
                }]
            },
            data.user_is_any_client && {
                label: iget2('b-modify-user', 'bally-xls', 'Баллы XLS'),
                control: [{
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'XLS_units'
                            }
                        }
                    ],
                    name: 'XLS_units',
                    content: inputControl(data.XLS_units)
                }, {
                    block: 'b-modify-user',
                    elem: 'api-units-hint',
                    content: [iget2('b-modify-user', 'iz', 'из'), ' ', u.escapeHTML(data.XLS_daily_units)]
                }]
            },
            userRoleIs('agency', 'manager') && {
                label: iget2('b-modify-user', 'razreshit-sozdavat-subklientov-cherez', 'Разрешить создавать субклиентов через API'),
                control: {
                    block: 'checkbox',
                    mix: [{
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'allow_create_subclients'
                        }
                    }],
                    mods: {
                        checked: checked(data.allow_create_subclients)
                    },
                    checkboxAttrs: {
                        value: 'Yes',
                        name: 'allow_create_subclients'
                    }
                }
            },
            {
                label: iget2('b-modify-user', 'upravlenie-geo-kampaniyami-v', 'Управление гео-кампаниями в API'),
                control: hasLoginRights('support_control') ?
                    {
                        block: 'b-modify-user',
                        elem: 'api-geo-allowed',
                        content: (data.api_geo_allowed ? iget2('b-modify-user', 'vklyucheno', 'Включено') : iget2('b-modify-user', 'vyklyucheno', 'Выключено'))
                    } :
                    {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'api_geo_allowed'
                            }
                        }],
                        mods: {
                            checked: checked(data.api_geo_allowed)
                        },
                        checkboxAttrs: {
                            value: 'Yes',
                            name: 'api_geo_allowed'
                        }
                    }
            },
            {
                label: iget2('b-modify-user', 'dostup-k-zablokirovannoy-versii', 'Доступ к заблокированной версии API'),
                control: {
                    block: 'checkbox',
                    mix: [{
                        block: 'i-glue',
                        elem: 'model-field',
                        js: {
                            type: 'checkbox',
                            name: 'api_allow_old_versions'
                        }
                    }],
                    mods: {
                        checked: checked(data.api_allow_old_versions)
                    },
                    checkboxAttrs: {
                        value: 'Yes',
                        name: 'api_allow_old_versions'
                    }
                }
            }
        ]);
    }

    contentElems.push([
        {
            label: iget2('b-modify-user', 'ogranichenie-na-kolichestvo-strok', 'Ограничение на количество строк в excel-файле'),
            control: [
                {
                    block: 'input',
                    mix: [
                        {
                            block: 'b-modify-user',
                            elem: 'inline-input',
                            elemMods: {
                                type: 'small'
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'excel-rows-limit'
                        },
                        {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'excel_rows_limit'
                            }
                        }
                    ],
                    name: 'excel_rows_limit',
                    content: inputControl(data.excel_rows_limit > 0 ? data.excel_rows_limit : '')
                },
                {
                    block: 'b-modify-user',
                    elem: 'excel-rows-limit-hint',
                    content: [
                        iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'), ' ',
                        u.escapeHTML(data.default_excel_rows_limit)
                    ]
                }
            ]
        }
    ]);

    result = {
        block: 'b-layout-form',

        mix: [
            {
                block: 'i-form',
                mods: {
                    submit: 'bem-event'
                }
            },
            {
                block: 'i-glue',
                js: {
                    modelName: 'm-modify-user-api-settings',
                    modelId: 'm-modify-user-api-settings',
                    modelData: this.extend(data, {
                        'current-method-limit-name': methods[0],
                        'current-method-limit-value': data.method_limits ? data.method_limits[methods[0]] : '',
                        'method-limits-list': Object.keys(data.method_limits || {}).map(function(key) {
                            return {
                                name: key,
                                value: data.method_limits[key]
                            };
                        }, this),
                        methods: methods
                    })
                }
            }
        ],

        mods: {
            'auto-append-colons': 'yes'
        },

        mixes: {
            row: [{
                block: 'b-modify-user',
                elem: 'row'
            }],
            label: [{
                block: 'b-modify-user',
                elem: 'label'
            }],
            control: [{
                block: 'b-modify-user',
                elem: 'control'
            }]
        },

        action: data.script,
        method: 'POST',

        submit: {
            block: 'button',
            mix: [{
                block: 'b-modify-user',
                elem: 'save'
            }],
            mods: {
                disabled: hasLoginRights('superreader_control', 'limited_support_control') ? 'yes' : ''
            },
            type: 'submit',
            content: iget2('b-modify-user', 'sohranit', 'Сохранить')
        },

        attrs: {
            name: 'api-settings'
        },

        rows: u.flatten(contentElems).filter(identity),

        hiddenInputs: u.flatten([
            commonHiddenInputs,
            {
                name: 'api',
                value: 1
            },
            {
                name: 'json_method_limits',
                value: '',
                mix: [{
                    block: 'b-modify-user',
                    elem: 'json-limits-input'
                }]
            }
        ]).filter(identity)
    };

    u.escapeHTML = originalEscape;

    return result;
});
