block('b-modify-user')(

    elem('audit-system').js()(function() {
        return {
            permittedProviders: this.ctx.permittedProviders || {}
        };
    }),

    elem('allowed-pixels').match(function() {
        return !Object.keys(this.ctx.permittedProviders).length;
    }).def()(function() {
        return applyNext({
            elemMods: { empty: 'yes' }
        });
    }),

    elem('allowed-pixels').mix()([{
        block: this.block, elem: 'flex-group'
    }]),

    elem('allowed-pixels').content()(function() {
        return [
            {
                elem: 'pixel-title',
                content: iget2('b-modify-user', 'title-allowed-pixels', 'Разрешенные пиксели')
            },
            {
                elem: 'pixel-content',
                content: [
                    {
                        elem: 'flex-row-head',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'nazvanie-174', 'Название')
                            },
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'campaign-type', 'Тип кампании')
                            },
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'criterion-type', 'Тип инвентаря')
                            }
                        ]
                    },
                    {
                        elem: 'permitted-providers',
                        permittedProviders: this.ctx.permittedProviders
                    }
                ]
            }
        ];
    }),

    elem('permitted-providers').content()(function() {
        var permittedProviders = this.ctx.permittedProviders,
            res = [];

        Object.keys(permittedProviders).forEach(function(provider) {
            Object.keys(permittedProviders[provider]).forEach(function(campaignType) {
                permittedProviders[provider][campaignType].forEach(function(criterionType) {
                    res.push({
                        elem: 'flex-row',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: provider
                            },
                            {
                                elem: 'flex-cell',
                                content: u['b-modify-user'].getNameCampaign(campaignType)
                            },
                            {
                                elem: 'flex-cell',
                                content: u['b-modify-user'].getNameCriterion(criterionType)
                            },
                            {
                                elem: 'flex-cell',
                                content: {
                                    block: 'button2',
                                    mods: {
                                        theme: 'clear',
                                        size: 'm',
                                        // modName: action для использования в js
                                        action: 'delete'
                                    },
                                    mix: {
                                        block: 'b-modify-user',
                                        elem: 'provider-action',
                                        js: {
                                            provider: provider,
                                            type: campaignType,
                                            criterion_type: criterionType
                                        }
                                    },
                                    icon: {
                                        block: 'icon',
                                        mods: { 'size-16': 'trash' }
                                    }
                                }
                            }
                        ]
                    });
                });
            });
        });

        return res;
    })

);
