block('b-modify-user')(

    elem('audit-system').content()(function() {
        return [
            {
                elem: 'add-pixel',
                mix: { block: 'b-modify-user', elem: 'flex-group' }
            },
            {
                elem: 'allowed-pixels',
                permittedProviders: (this.data.pixels || {}).permitted_providers
            }
        ];
    }),

    elem('add-pixel').content()(function() {
        var data = this.data,
            pixels = data.pixels;

        return [
            {
                elem: 'pixel-title',
                content: iget2('b-modify-user', 'title-add-pixel', 'Добавить пиксель')
            },
            {
                elem: 'pixel-content',
                content: [
                    {
                        elem: 'flex-row',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'nazvanie-174', 'Название') + ':'
                            },
                            {
                                elem: 'flex-cell',
                                content: {
                                    block: 'select',
                                    mods: { size: 's', theme: 'normal' },
                                    mix: {
                                        block: 'b-modify-user',
                                        elem: 'provider'
                                    },
                                    name: 'provider',
                                    content: [
                                        {
                                            block: 'button',
                                            mix: {
                                                block: 'select',
                                                elem: 'button'
                                            },
                                            content: pixels.providers[0]
                                        },
                                        {
                                            elem: 'control',
                                            content: pixels.providers.map(function(provider) {
                                                return {
                                                    elem: 'option',
                                                    attrs: { value: provider },
                                                    content: provider
                                                };
                                            })
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        elem: 'flex-row',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'campaign-type', 'Тип кампании') + ':'
                            },
                            {
                                elem: 'flex-cell',
                                content: {
                                    block: 'select',
                                    mods: { size: 's', theme: 'normal' },
                                    mix: {
                                        block: 'b-modify-user',
                                        elem: 'campaign-type'
                                    },
                                    name: 'campaign_type',
                                    content: [
                                        {
                                            block: 'button',
                                            mix: {
                                                block: 'select',
                                                elem: 'button'
                                            },
                                            content: u['b-modify-user'].getNameCampaign(pixels.campaign_types[0])
                                        },
                                        {
                                            elem: 'control',
                                            content: pixels.campaign_types.map(function(camp) {
                                                return {
                                                    elem: 'option',
                                                    attrs: { value: camp },
                                                    content: u['b-modify-user'].getNameCampaign(camp)
                                                };
                                            })
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        elem: 'flex-row',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: iget2('b-modify-user', 'criterion-type', 'Тип инвентаря') + ':'
                            },
                            {
                                elem: 'flex-cell',
                                content: {
                                    block: 'select',
                                    mods: { size: 's', theme: 'normal' },
                                    mix: {
                                        block: 'b-modify-user',
                                        elem: 'criterion-type'
                                    },
                                    name: 'criterion-type',
                                    content: [
                                        {
                                            block: 'button',
                                            mix: {
                                                block: 'select',
                                                elem: 'button'
                                            },
                                            content: u['b-modify-user'].getNameCriterion(pixels.criterion_types[0])
                                        },
                                        {
                                            elem: 'control',
                                            content: pixels.criterion_types.map(function(criterion) {
                                                return {
                                                    elem: 'option',
                                                    attrs: { value: criterion },
                                                    content: u['b-modify-user'].getNameCriterion(criterion)
                                                };
                                            })
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        elem: 'flex-row',
                        content: [
                            {
                                elem: 'flex-cell',
                                content: {
                                    block: 'button2',
                                    mods: {
                                        theme: 'action',
                                        size: 's',
                                        // modName: action для использования в js
                                        action: 'add'
                                    },
                                    mix: {
                                        block: 'b-modify-user',
                                        elem: 'provider-action'
                                    },
                                    text: iget2('b-modify-user', 'add', 'Добавить')
                                }
                            }
                        ]
                    }
                ]
            }
        ];
    })

);
