BEM.DOM.decl({ block: 'b-modify-user', elem: 'audit-system' }, {
    /**
     * @private
     * @return {Object}
     */
    _pixelSelects: null,

    /**
     * @private
     * @return {BEM.DOM}
     */
    _pixelAddButton: null,

    /**
     * @private
     * @return {BEM}
     */
    _pixelRequest: null,

    /**
     * @private
     * @return {Object}
     */
    _permittedProviders: null,

    /**
     * Запоминает и возвращает объект с селектами
     * @param {String} name — имя элемента provider|campaign-type
     * @returns {Object}
     * @private
     */
    _getPixelsSelect: function(name) {
        this._pixelSelects || (this._pixelSelects = {});

        this._pixelSelects[name] || (this._pixelSelects[name] = this.findBlockInside(name, 'select'));

        return this._pixelSelects[name];
    },

    /**
     * Запоминает и возвращает кнопку «Добавить» провайдера
     * @returns {BEM.DOM}
     * @private
     */
    _getPixelAddButton: function() {
        return this._pixelAddButton ||
            (this._pixelAddButton = this.findBlockInside('provider-action', { block: 'button2', modName: 'action', modVal: 'add' }));
    },

    /**
     * Обработчик события click на элементах добавления/удаления провайдера
     * @param {Event} e
     * @private
     */
    _clickActionProvider: function(e) {
        var button2 = e.block,
            action = button2.getMod('action'),
            elemParams = this.getParent().elemParams(this.elemify(button2.domElem, 'provider-action')),
            options = this._getPixelOptions(action, elemParams);

        this._getPixelAddButton().setMod('progress', 'yes');

        this.findBlocksInside('provider-action', {
            block: 'button2', modName: 'action', modVal: 'delete'
        }).forEach(function(button) {
            button.setMod('progress', 'yes');
        });

        this._getPixelRequest().get(
            {
                cmd: 'ajaxModifyClientPixels',
                action: action,
                provider: options.provider,
                campaign_type: options.type,
                criterion_type: options.criterion_type,
                ulogin: u.consts('ulogin')
            },
            this._onPixelServerSuccess.bind(this, options, action),
            this._onPixelServerError.bind(this)
        );
    },

    /**
     * Возвращает данные, в зависимости от action
     * @param {String} action — действие delete|add
     * @param {Object} [params] — только при delete
     * @param {String} [params.provider] — провайдер
     * @param {String} [params.type] — тип кампании
     * @returns {Object}
     * @private
     */
    _getPixelOptions: function(action, params) {
        switch (action) {
            case 'add':
                return {
                    provider: this._getPixelsSelect('provider').val(),
                    type: this._getPixelsSelect('campaign-type').val(),
                    criterion_type: this._getPixelsSelect('criterion-type').val()
                };
            case 'delete':
                return {
                    provider: params.provider,
                    type: params.type,
                    criterion_type: params.criterion_type
                };
        }
    },

    /**
     * Обработчик ответа от сервера
     * @param {Object} options
     * @param {String} options.provider — провайдер
     * @param {String} options.type — тип кампании
     * @param {String} action — действие delete|add
     * @private
     */
    _onPixelServerSuccess: function(options, action, response) {
        if (response.status && response.status === 'ok') {
            BEM.DOM.replace(this.findElem('allowed-pixels'), BEMHTML.apply({
                block: this.getParent().__self.getName(),
                elem: 'allowed-pixels',
                permittedProviders: this._getPixelPermittedProviders(options, action)
            }));
        } else {
            BEM.blocks['b-confirm']
                .alert(iget2('b-modify-user', 'pixel-server-response-status-failed', 'Невалидная комбинация'));

            this.findBlocksInside('provider-action', {
                block: 'button2', modName: 'action', modVal: 'delete'
            }).forEach(function(button) {
                button.delMod('progress');
            });
        }

        this._getPixelAddButton().delMod('progress');
    },

    /**
     * Возвращает обновленный объект «Разрешенных пикселей»
     * в зависимости от action добавляет или удаляет провайдера
     * @param {Object} options
     * @param {String} options.provider — провайдер
     * @param {String} options.type — тип кампании
     * @param {String} options.criterion_type — тип критерия
     * @param {String} action — действие delete|add
     * @returns {Object} { provider1: { type1: [criterion_type1, criterion_type2], type2: [criterion_type1] } }
     * @private
     */
    _getPixelPermittedProviders: function(options, action) {
        this._permittedProviders || (this._permittedProviders = this.params.permittedProviders);

        switch (action) {
            case 'add':
                this._permittedProviders[options.provider] || (this._permittedProviders[options.provider] = {});

                this._permittedProviders[options.provider][options.type] ||
                    (this._permittedProviders[options.provider][options.type] = []);

                u._.includes(this._permittedProviders[options.provider][options.type], options.criterion_type) ||
                    this._permittedProviders[options.provider][options.type].push(options.criterion_type);

                break;

            case 'delete':
                u._.remove(this._permittedProviders[options.provider][options.type], function(criterionType) {
                    return criterionType === options.criterion_type;
                });

                this._permittedProviders[options.provider][options.type].length ||
                    (this._permittedProviders[options.provider] =
                        u._.omit(this._permittedProviders[options.provider], options.type));

                u._.keys(this._permittedProviders[options.provider]).length ||
                    (this._permittedProviders = u._.omit(this._permittedProviders, options.provider));

                break;
        }

        return this._permittedProviders;
    },

    /**
     * Обработчик ошибки с сервера
     * @private
     */
    _onPixelServerError: function() {
        BEM.blocks['b-confirm']
            .alert(iget2('b-modify-user', 'pixel-server-error', 'Серверная ошибка, повторите немного позже'));

        this._getPixelAddButton().delMod('progress');
    },

    /**
     * Создает запрос
     * @returns {BEM}
     * @private
     */
    _getPixelRequest: function() {
        return this._pixelRequest || (this._pixelRequest = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST'
        }));
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', function(e) {
            this._clickActionProvider(e);
        });
    }
});
