block('b-modify-user').elem('general-settings').content()(function() {
    var data = this.data,
        userRoleIs = function( /*roles...*/ ) {
            return Array.prototype.slice.call(arguments).some(function(role) {
                return data.user_role === role;
            });
        },
        commonHiddenInputs = this.ctx.commonHiddenInputs,
        identity = function(obj) {
            return obj;
        },
        checked = function(val) {
            //конвертирует булево значение в yes/пустую строку
            return (typeof val === 'string' &&
                (val.toLowerCase() === 'true' || val.toLowerCase() === 'yes')) || !!+val ? 'yes' : '';
        },
        inputControl = function(value) {
            return {
                elem: 'control',
                attrs: {
                    value: (typeof value === 'string' || typeof value === 'number') ? value : ''
                }
            };
        },
        allowClientsWithoutWallet = +(data.agency_options || {}).allow_clients_without_wallet === 1 || false,
        defaultClientsWithWallet = +(data.agency_options || {}).default_clients_with_wallet === 1 || false,
        newLimRepSchema = u._.contains(data.features_enabled_for_client_all, 'NEW_LIM_REP_SCHEMA'),
        originalEscape = u.escapeHTML,
        result;

    //убрать, когда появится исправленная версия
    u.escapeHTML = function(str) {
        if (typeof str !== 'string' && typeof str !== 'number') return '';
        str = '' + str;
        return str.replace(/[&<>\"\']/g,
            function(c) {
                return '&#' + c.charCodeAt(0) + ';';
            });
    };

    result = {
        block: 'b-layout-form',
        mix: [
            {
                block: 'i-form',
                mods: {
                    submit: 'bem-event'
                }
            },
            {
                block: 'i-glue',
                js: {
                    modelName: 'm-modify-user-general-settings',
                    modelId: 'm-modify-user-general-settings',
                    modelData: this.extend(data, {
                        region_id: (data.country || data.countries && data.countries[0][data.country_field_name] || {})
                            .region_id,
                        regionEditPermission: this.ctx.js.permission.regionEdit, //прокидывается из b-modify-user
                        agency_allow_pay: data.agency_no_pay === '0',
                        agency_disallow_money_transfer: data.agency_disallow_money_transfer === '0',
                        // если нельзя создавать клиентов без ОС, то по дефолту всегда false
                        defaultClientsWithWallet: allowClientsWithoutWallet ? defaultClientsWithWallet : true,
                        allowClientsWithoutWallet: allowClientsWithoutWallet
                    })
                }
            }
        ],

        mixes: {
            row: [{
                block: 'b-modify-user',
                elem: 'row'
            }],
            label: [{
                block: 'b-modify-user',
                elem: 'label'
            }],
            control: [{
                block: 'b-modify-user',
                elem: 'control'
            }]
        },

        action: data.script,
        method: 'POST',

        submit: {
            block: 'button',
            mix: [{
                block: 'b-modify-user',
                elem: 'save'
            }],
            mods: {
                disabled: hasLoginRights('is_developer', 'superreader_control', 'limited_support_control') ? 'yes' : ''
            },
            type: 'submit',
            content: iget2('b-modify-user', 'sohranit', 'Сохранить')
        },

        attrs: {
            name: 'general-settings'
        },

        rows: (function() {
            var agencyRepTypeNames = {
                    chief: iget2('b-modify-user', 'glavnyy-predstavitel', 'Главный представитель'),
                    main: iget2('b-modify-user', 'predstavitel', 'Представитель'),
                    limited: iget2('b-modify-user', 'predstavitel-po-rabote-s', 'Представитель по работе с клиентами')
                },
                agencyStatuses = {
                    '': iget2('b-modify-user', 'bez-statusa-b-s', 'Без статуса (Б/С)'),
                    SA: iget2('b-modify-user', 'sertificirovannoe-agentstvo-sa', 'Сертифицированное агентство (СА)'),
                    AA: iget2('b-modify-user', 'avtorizovannoe-agentstvo-aa', 'Авторизованное агентство (AA)'),
                    HY: iget2('b-modify-user', '189-goda', '&#189; года'),
                    WC: iget2('b-modify-user', 'bez-dogovora', 'Без договора'),
                    NR: iget2('b-modify-user', 'nerezident', 'Нерезидент'),
                    ABU: iget2('b-modify-user', 'abu', 'АБУ')
                },
                domain = data.yandex_domain,
                langsArray = ['en', 'ru', 'ua'],
                isMainRepType = data.agency_rep_type === 'main',
                hasRoleControls = newLimRepSchema &&
                    userRoleIs('agency') &&
                    u._.contains(['main', 'limited', 'limited_main', 'limited_chief'], data.agency_rep_type) &&
                    hasLoginRights('super_control', 'is_developer', 'manager_control', 'support_control', 'is_agency_chief', 'is_agency_main');

            if (domain === 'yandex.com.tr') langsArray = ['en', 'tr'];
            if (domain === 'yandex.by' || domain === 'yandex.kz') langsArray = ['en', 'ru'];
            if (domain === 'yandex.ru' || domain === 'yandex.ua') langsArray = ['en', 'ru', 'ua'];
            if (data.login_rights.role === 'super') langsArray = data.available_languages;

            return u.flatten([
                {
                    label: iget2('b-modify-user', 'login-172', 'Логин:'),
                    control: {
                        block: 'b-modify-user',
                        elem: 'login',
                        content: u.escapeHTML(data.login)
                    }
                },
                hasLoginRights('super_control', 'is_developer') && data.CONFIGURATION !== 'production' && {
                    label: '&nbsp;',
                    control: {
                        block: 'link',
                        url: u.getUrl('fakeadmUser', {
                            ulogin: u.escapeHTML(data.login)
                        }),
                        content: iget2('b-modify-user', 'modifikaciya-testovoy-bd', 'Модификация тестовой БД')
                    }
                },
                hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') && {
                    label: 'Passport UID:',
                    control: {
                        block: 'b-modify-user',
                        elem: 'passport-uid',
                        content: data.uid
                    }
                },
                (hasLoginRights('super_control', 'is_developer', 'superreader_control', 'limited_support_control') ||
                    data.user_is_any_client ||
                    (userRoleIs('agency') && hasLoginRights('is_internal_user'))) &&
                    {
                        label: 'Client ID:',
                        control: [
                            {
                                block: 'b-modify-user',
                                elem: 'client-id',
                                content: data.ClientID
                            },
                            (hasLoginRights('super_control', 'is_developer','superreader_control', 'limited_support_control') &&
                            data.rbac_client_id) &&
                                ' (RBAC ClientID: ' + data.rbac_client_id + ') ',
                            (data.ClientID === 0 && !hasLoginRights('is_developer')) && {
                                block: 'link',
                                url: u.getUrl('searchClientID', {
                                    client_login: u.escapeHTML(data.login),
                                    from: 'modifyUser',
                                    rcmd: u.escapeHTML(data.FORM.rcmd || '')
                                }),
                                content: iget2('b-modify-user', 'zapolnit-sozdat-clientid', 'заполнить/создать ClientID')
                            }
                        ]
                    },
                {
                    label: iget2('b-modify-user', 'sozdan-173', 'Создан:'),
                    control: {
                        block: 'b-modify-user',
                        elem: 'created-at',
                        content: data.createtime_text
                    }
                },
                (hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') &&
                    (data.user_is_any_client || userRoleIs('agency'))) && {
                        label: iget2('b-modify-user', 'informaciya-billinga', 'Информация биллинга:'),
                        control: data.balance_info ?
                            [
                                iget2('b-modify-user', 'imya', 'Имя:'),
                                ' ',
                                {
                                    block: 'b-modify-user',
                                    elem: 'billing-name',
                                    content: u.escapeHTML(data.balance_info.Name)
                                },
                                ', ClientID: ',
                                {
                                    block: 'b-modify-user',
                                    elem: 'billing-client-id',
                                    content: data.balance_info.ClientId
                                },
                                ', ', iget2('b-modify-user', 'nazvanie-klienta', 'Название клиента:'), ' ',
                                {
                                    block: 'b-modify-user',
                                    elem: 'billing-client-name',
                                    content: u.escapeHTML(data.balance_info.ClientName)
                                },
                                data.balance_info.IsMain !== '0' && [', ', {
                                    block: 'b-modify-user',
                                    elem: 'billing-main-rep',
                                    content: iget2('b-modify-user', 'glavnyy-predstavitel', 'Главный представитель')
                                }]
                            ] :
                            iget2('b-modify-user', 'oshibka-polucheniya-dannyh', '<ошибка получения данных>')
                    },
                !newLimRepSchema && userRoleIs('agency') && {
                    label: iget2('b-modify-user', 'rol', 'Роль:'),
                    control: {
                        block: 'b-modify-user',
                        elem: 'agency-role',
                        content: agencyRepTypeNames[data.agency_rep_type]
                    }
                },
                hasRoleControls && {
                    label: iget2('b-modify-user', 'rol', 'Роль:'),
                    control: {
                        block: 'b-modify-user',
                        elem: 'role-wrapper',
                        content: [
                            {
                                block: 'radiobox',
                                mods: {
                                    disabled: checked(hasLoginRights('support_control'))
                                },
                                mix: [{
                                    block: 'b-modify-user',
                                    elem: 'role-radiobox'
                                }],
                                name: 'ag_role',
                                value: data.agency_rep_type || 'limited_main',
                                content: [
                                    {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'p-new-agency-representative',
                                            elem: 'radio'
                                        }],
                                        controlAttrs: {
                                            value: 'limited_main'
                                        },
                                        content: [
                                            iget2('b-modify-user', 'predstavitel-po-rabote-s-manager', 'Представитель по работе с клиентами (менеджер)')
                                        ]
                                    },
                                    {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'p-new-agency-representative',
                                            elem: 'radio'
                                        }],
                                        controlAttrs: {
                                            value: 'limited_chief'
                                        },
                                        content: iget2('b-modify-user', 'predstavitel-po-rabote-s-teamlead', 'Представитель по работе с клиентами (тимлид)')
                                    },
                                    {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'p-new-agency-representative',
                                            elem: 'radio'
                                        }],
                                        controlAttrs: {
                                            value: 'main'
                                        },
                                        content: iget2('b-modify-user', 'predstavitel-administrator', 'Представитель (администратор)')
                                    },
                                    data.agency_rep_type == 'limited' && {
                                        elem: 'radio',
                                        elemMods: { disabled: 'yes' },
                                        mix: [{
                                            block: 'p-new-agency-representative',
                                            elem: 'radio'
                                        }],
                                        controlAttrs: {
                                            value: 'limited'
                                        },
                                        content: agencyRepTypeNames.limited
                                    },
                                    data.agency_rep_type == 'chief' && {
                                        elem: 'radio',
                                        elemMods: { disabled: 'yes' },
                                        mix: [{
                                            block: 'p-new-agency-representative',
                                            elem: 'radio'
                                        }],
                                        controlAttrs: {
                                            value: 'chief'
                                        },
                                        content: agencyRepTypeNames.chief
                                    }
                                ]
                            },
                            {
                                block: 'select',
                                mods: {
                                    size: 's',
                                    theme: 'normal'
                                },
                                mix: [{ block: 'b-modify-user', elem: 'manager-select' }],
                                name: 'chief_lim_rep_uid',
                                content: [
                                    {
                                        block: 'button',
                                        mix: {
                                            block: 'select',
                                            elem: 'button'
                                        },
                                        content: ''
                                    },
                                    {
                                        elem: 'control',
                                        content: (data.lim_rep_chiefs || []).map(function(item, idx) {
                                            var result = {
                                                elem: 'option',
                                                attrs: {
                                                    value: item.uid
                                                },
                                                content: item.login + (item.FIO ? ' (' + item.FIO + ')' : '')
                                            };

                                            if (item.uid === data.lim_rep_chief_uid) {
                                                result.attrs.selected = 'yes';
                                            }

                                            return result;
                                        }, this)
                                    }
                                ]
                            }
                        ]
                    }
                },
                {
                    label: (userRoleIs('agency') ? iget2('b-modify-user', 'nazvanie-predstavitelya', 'Название представителя') : iget2('b-modify-user', 'nazvanie-174', 'Название')) + ':',
                    control: data.dont_edit_fio_email_by_agency ?
                        u.escapeHTML(data.FIO) : {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'FIO'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'FIO'
                                    }
                                }
                            ],
                            name: 'FIO',
                            content: inputControl(data.FIO)
                        }

                },
                userRoleIs('agency') && hasLoginRights('manager_control', 'super_control', 'is_developer',
                    'support_control', 'superreader_control', 'limited_support_control') && [
                        {
                            label: iget2('b-modify-user', 'nazvanie-agentstva', 'Название агентства:'),
                            control: {
                                block: 'input',
                                mix: [{
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                }],
                                name: 'agency_name',
                                content: inputControl(data.agency_name)
                            }
                        },
                        {
                            label: iget2('b-modify-user', 'url-agentstva', 'URL агентства:'),
                            control: {
                                block: 'input',
                                mix: [{
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                }],
                                name: 'agency_url',
                                content: inputControl(data.agency_url)
                            }
                        }
                    ],
                (hasLoginRights('super_control', 'is_developer', 'superreader_control') && data.is_internal_user) && {
                    label: iget2('b-modify-user', 'domennyy-login-na-yandekse', 'Доменный логин на Яндексе:'),
                    control: {
                        block: 'link',
                        url: u.formatUrl({
                            host: 'http://staff.yandex.ru',
                            path: u.escapeHTML(data.domain_login)
                        }),
                        content: u.escapeHTML(data.domain_login)
                    }
                },
                {
                    label: data.login_rights.role == 'manager' ?
                        iget2('b-modify-user', 'telefon-176', 'Добавочный телефон менеджера:') :
                        iget2('b-modify-user', 'telefon-175', 'Телефон:'),
                    control: data.dont_edit_fio_email_by_agency ?
                        {
                            block: 'b-modify-user',
                            elem: 'phone',
                            content: u.escapeHTML(data.phone)
                        } :
                        {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'phone'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'phone'
                                    }
                                }
                            ],
                            name: 'phone',
                            content: inputControl(data.phone)
                        }
                },
                {
                    label: {
                        content: {
                            block: 'b-modify-user',
                            elem: 'crm-alias',
                            content: [
                                userRoleIs('manager') ?
                                (data.manager_use_crm ?
                                    iget2('b-modify-user', 'crm-alias', 'CRM-алиас') :
                                    iget2('b-modify-user', 'e-mail-outlook', 'E-mail (Outlook)')) :
                                     iget2('b-modify-user', 'e-mail-176', 'E-mail'), ':'
                            ]
                        }
                    },
                    control: data.dont_edit_fio_email_by_agency ?
                        {
                            block: 'b-modify-user',
                            elem: 'crm-alias-value',
                            content: u.escapeHTML(data.email)
                        } :
                        {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'email'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'email'
                                    }
                                }
                            ],
                            name: 'email',
                            content: inputControl(data.email)
                        }
                },
                userRoleIs('agency') && {
                    label: iget2('b-modify-user', 'otobrazhat-kontakty-v-klientskom', 'Отображать контакты в клиентском интерфейсе') + ':',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'show_agency_contacts'
                            }
                        }],
                        mods: {
                            checked: checked(data.show_agency_contacts),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'show_agency_contacts'
                        }
                    }
                },
                userRoleIs('agency') && {
                    label: iget2('b-modify-user', 'mozhno-sozdavat-subclientov-bez-os', 'Можно создавать субклиентов без общего счёта'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'allowClientsWithoutWallet'
                            }
                        }],
                        mods: {
                            checked: checked(allowClientsWithoutWallet),
                            disabled: checked(!hasLoginRights('super_control', 'manager_control',
                                'support_control', 'is_developer'))
                        }
                    }
                },
                //агентство согласилось на общий счет
                //главный представитель может редактировать возможность подключения общего счета только сам себе
                //также показываем галочку, если она не проставлена, но ОС есть (чтобы можно было включить)
                userRoleIs('agency') && data.agency_rep_type === 'chief' &&
                (hasLoginRights('super_control', 'manager_control', 'support_control', 'limited_support_control', 'is_developer') ||
                    (hasLoginRights('is_agency_chief') && data.UID === data.uid)) && {
                        label: iget2('b-modify-user', 'po-umoclhaniu-sozdavat-s-os', 'По умолчанию создавать клиентов с общим счётом '),
                        control: {
                            block: 'checkbox',
                            mix: [
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'checkbox',
                                        name: 'defaultClientsWithWallet'
                                    }
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'defaultWalletCheckbox'
                                }
                            ],
                            mods: {
                                checked: checked(allowClientsWithoutWallet ? defaultClientsWithWallet : true),
                                disabled: checked(!allowClientsWithoutWallet || hasLoginRights('limited_support_control'))
                            }
                        }
                    },
                (userRoleIs('agency')) && {
                    label: iget2('b-modify-user', 'poluchat-uvedomleniya-o-dobavlenii', 'Получать уведомления о добавлении новых доменов') + ':',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'notify_about_new_domains'
                            }
                        }],
                        mods: {
                            checked: checked(data.notify_about_new_domains),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'notify_about_new_domains'
                        }
                    }
                },
                {
                    label: iget2('b-modify-user', 'yazyk-uvedomleniy', 'Язык уведомлений:'),
                    control: {
                        block: 'select',
                        name: 'user_lang',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                name: 'user_lang',
                                type: 'select'
                            }
                        }],
                        content: [
                            {
                                block: 'button',
                                content: data.user_lang
                            },
                            {
                                elem: 'control',
                                content: langsArray.map(function(lang) {
                                    var option = {
                                        elem: 'option',
                                        attrs: {
                                            value: lang
                                        },
                                        content: lang
                                    };

                                    if (lang === data.user_lang) {
                                        option.attrs.selected = 'selected';
                                    }

                                    return option;
                                }, this)
                            }
                        ]
                    }
                },
                userRoleIs('agency') && (u.consts('rights').enableCpmDealsCampaigns || !hasLoginRights('agency_control')) && {
                    label: iget2('b-modify-user', 'email-uvedomleniy-po-sdelkam', 'E-mail для уведомлений по сделкам:'),
                    control: u._.get(data, 'agency_options.deal_notification_email') || iget2('b-modify-user', 'email-uvedomleniy-po-sdelkam-ne-zadan', 'Не задан')
                },
                userRoleIs('agency') && data.agency_rep_type !== 'chief' && {
                    label: iget2('b-modify-user', 'otpravlyat-kopii-pisem-o', 'Отправлять копии писем о зачислении денег главному представителю:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'agency_email_to_chief'
                            }
                        }],
                        mods: {
                            checked: checked(data.agency_email_to_chief),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'agency_email_to_chief'
                        }
                    }
                },
                userRoleIs('agency') && (!hasLoginRights('agency_control') || checked(data.can_copy_ctr) == 'yes') && { //для агенств показываем только если копирование CTR разрешено (null либо "1")
                    label: iget2('b-modify-user', 'razreshit-kopirovat-ctr-pri', 'Разрешить копировать CTR при копировании кампаний'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'can_copy_ctr'
                            }
                        }],
                        mods: {
                            checked: checked(data.can_copy_ctr),
                            disabled: (hasLoginRights('super_control') || hasLoginRights('manager_control')) ?
                                '' :
                                'yes'
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'can_copy_ctr'
                        }
                    }
                },
                (hasRoleControls || (
                    userRoleIs('agency') && (data.agency_rep_type == 'limited' || isMainRepType) &&
                        hasLoginRights('super_control', 'is_developer', 'manager_control', 'is_agency_chief', 'support_control', 'limited_support_control'))
                ) && [
                    {
                        mixes: {
                            row: {
                                block: 'b-modify-user',
                                elem: 'permission-control'
                            }
                        },
                        label: iget2('b-modify-user', 'razreshit-vystavlenie-schetov', 'Разрешить выставление счетов:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'agency_allow_pay'
                                }
                            }],
                            mods: {
                                checked: checked(Number(data.agency_no_pay) === 0),
                                disabled: checked(hasLoginRights('support_control', 'limited_support_control') || isMainRepType)
                            },
                            checkboxAttrs: {
                                value: '1',
                                name: 'agency_allow_pay'
                            }
                        }
                    },
                    {
                        mixes: {
                            row: {
                                block: 'b-modify-user',
                                elem: 'permission-control'
                            }
                        },
                        label: iget2('b-modify-user', 'razreshit-perenos-sredstv', 'Разрешить перенос средств:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'agency_disallow_money_transfer'
                                }
                            }],
                            mods: {
                                checked: checked(Number(data.agency_disallow_money_transfer) === 0),
                                disabled: checked(hasLoginRights('support_control', 'limited_support_control') || isMainRepType)
                            },
                            checkboxAttrs: {
                                value: '1',
                                name: 'agency_disallow_money_transfer'
                            }
                        }
                    }
                ],
                hasLoginRights('super_control', 'is_developer', 'manager_control',
                'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'gorod', 'Город:'),
                    control: {
                        block: 'input',
                        mods: {
                            suggest: 'yes'
                        },
                        js: {
                            dataprovider: {
                                name: 'i-region-suggest-dataprovider',
                                url: u.getUrl('ajaxRegionSuggest', {
                                    type: 'city'
                                }),
                                requestThreshold: 3
                            },
                            popupMixs: [{
                                block: 'b-modify-user',
                                elem: 'city-suggest-popup'
                            }]
                        },
                        mix: [
                            {
                                block: 'b-modify-user',
                                elem: 'city'
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'inline-input'
                            },
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'input',
                                    name: 'city'
                                }
                            }
                        ],
                        name: 'city',
                        content: inputControl(data.city)
                    }
                },
                hasLoginRights('super_control', 'is_developer', 'manager_control',
                'support_control', 'superreader_control', 'limited_support_control') && [
                    {
                        label: iget2('b-modify-user', 'strana', 'Страна:'),
                        control: [
                            data.can_edit_country_currency && data.edit_country_currency ?
                                {
                                    block: 'select',
                                    mix: [{
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            name: 'region_id',
                                            type: 'select'
                                        }
                                    }],
                                    name: 'country',
                                    content: [
                                        {
                                            block: 'button',
                                            mix: {
                                                block: 'select',
                                                elem: 'button'
                                            },
                                            content: (function() {
                                                if (!data.country) {
                                                    return data.countries[0][data.country_field_name];
                                                } else {
                                                    var result = '';

                                                    data.countries.some(function(country) {
                                                        if (country.region_id === data.country.region_id) {
                                                            result = country[data.country_field_name];
                                                            return true;
                                                        }
                                                        return false;
                                                    });

                                                    return result;
                                                }
                                            }())
                                        },
                                        {
                                            elem: 'control',
                                            content: [{
                                                elem: 'option',
                                                attrs: {
                                                    value: '0'
                                                },
                                                content: data.country ? data.country.localized_name : '-'
                                            }].concat(data.countries.sort(function(a, b) {
                                                return a[data.country_field_name].toLowerCase() >
                                                    b[data.country_field_name].toLowerCase() ?
                                                        1 :
                                                        -1;
                                            }).map(function(country) {
                                                var result = {
                                                    elem: 'option',
                                                    attrs: {
                                                        value: country.region_id
                                                    },
                                                    content: u.escapeHTML(country[data.country_field_name])
                                                };

                                                if (data.country && country.region_id == data.country.region_id) {
                                                    result.attrs.selected = 'selected';
                                                }

                                                return result;
                                            }, this))
                                        }
                                    ]
                                } :
                                [
                                    !!(data.can_edit_country_currency && !data.edit_country_currency) && [{
                                        block: 'link',
                                        url: u.getUrl('modifyUser', {
                                            edit_country_currency: 1,
                                            rcmd: u.escapeHTML(data.FORM.rcmd),
                                            rulogin: u.escapeHTML(data.FORM.rulogin),
                                            ulogin: u.escapeHTML(data.FORM.ulogin)
                                        }),
                                        content: iget2('b-modify-user', 'izmenit-stranu-valyutu', 'изменить страну/валюту')
                                    }, '&nbsp;'],
                                    {
                                        block: 'b-modify-user',
                                        elem: 'country',
                                        content: u.escapeHTML(data.country ? data.country.localized_name : '—')
                                    }

                                ],
                            '&nbsp;(',
                            iget2('b-modify-user', 'v-balanse', 'в Балансе:'), ' ', {
                                block: 'b-modify-user',
                                elem: 'balance-country',
                                content: data.no_balance_client_data ?
                                    iget2('b-modify-user', 'oshibka-polucheniya-dannyh', '<ошибка получения данных>') : data.balance_country ? u.escapeHTML(data.balance_country.localized_name) : '—'
                            }, ')'
                        ]
                    },
                    {

                        label: iget2('b-modify-user', 'valyuta-otobrazheniya', 'Валюта отображения:'),
                        control: [
                            data.can_edit_country_currency && data.edit_country_currency ?
                                {
                                    block: 'select',
                                    mix: [{
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            name: 'work_currency',
                                            type: 'select'
                                        }
                                    }],
                                    name: 'currency',
                                    content: [
                                        {
                                            block: 'button',
                                            mix: {
                                                block: 'select',
                                                elem: 'button'
                                            },
                                            content: u.currencies.getName(data.work_currency)
                                        },
                                        {
                                            elem: 'control',
                                            content: data.currencies.map(function(currency) {
                                                var result = {
                                                    elem: 'option',
                                                    attrs: {
                                                        value: u.escapeHTML(currency)
                                                    },
                                                    content: u.currencies.getName(currency)
                                                };

                                                currency === data.work_currency && (result.attrs.selected = 'selected');

                                                return result;
                                            }, this)
                                        }
                                    ]
                                } :
                                {
                                    block: 'b-modify-user',
                                    elem: 'currency',
                                    content: data.work_currency ?
                                        u.escapeHTML(
                                            u.currencies.getName(data.work_currency, { full: 1 })
                                        ) :
                                        '—'
                                },
                            '&nbsp;',
                            userRoleIs('agency') && [
                                '&nbsp;(', iget2('b-modify-user', 'bessrochno', 'бессрочно'), ')',
                                Object.keys(data.additional_currencies).map(function(key) {
                                    var currency = data.additional_currencies[key];
                                    return [
                                        ', ',
                                        {
                                            block: 'b-text',
                                            tag: currency.expired ? 'del' : 'span',
                                            content: [
                                                u.escapeHTML(u.currencies.getName(currency.code, {
                                                    full: 1
                                                })),
                                                '&nbsp;(',
                                                u.escapeHTML(iget2('b-modify-user', 'do-s', 'до {foo}', {
                                                    foo: u.formatDate(currency.expiration_date)
                                                })),
                                                ')'
                                            ]
                                        }
                                    ];
                                }, this)
                            ],
                            '(',
                            iget2('b-modify-user', 'v-balanse', 'в Балансе:'), ' ', {
                                block: 'b-modify-user',
                                elem: 'balance-currency',
                                content: data.no_balance_client_data ?
                                    iget2('b-modify-user', 'oshibka-polucheniya-dannyh', '<ошибка получения данных>') : (data.balance_currency ? u.escapeHTML(u.currencies.getName(data.balance_currency, {
                                        full: 1
                                    })) : '—')
                            }, ')'
                        ]
                    }
                ],
                data.user_is_any_client && hasLoginRights('super_control', 'is_developer', 'support_control',
                'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'pokazyvat-tizer-dlya-pervoy', 'Показывать тизер для первой помощи:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'show_fa_teaser'
                            }
                        }],
                        mods: {
                            checked: checked(data.show_fa_teaser),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: 'Yes',
                            name: 'show_fa_teaser'
                        }
                    }
                },
                (data.user_is_any_client &&
                    hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') &&
                    data.optimized_camps.length) && {
                        label: {
                            content: {
                                block: 'b-modify-user',
                                elem: 'important-label',
                                content: [
                                    iget2('b-modify-user', 'bylo-zayavok', 'Было заявок'), ':&nbsp;',
                                    {
                                        tag: 'strong',
                                        content: data.optimized_camps.reduce(function(res, c) {
                                            return res + parseInt(c.cnt, 10);
                                        }, 0)
                                    },
                                    ';&nbsp;',
                                    data.optimized_camps.map(function(c) {
                                        return {
                                            elem: 'optimize-request',
                                            content: [
                                                '№',
                                                c.cid,
                                                '&nbsp;-&nbsp;',
                                                {
                                                    tag: 'strong',
                                                    content: c.cnt
                                                },
                                                ';&nbsp;'
                                            ]
                                        };
                                    }, this)
                                ]
                            }
                        }
                    },
                data.user_is_any_client && data.show_device_targeting && {
                    label: iget2('b-modify-user', 'nastroyka-targetinga-na-ustroystva', 'Настройка таргетинга на устройства:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'allow_device_targeting'
                            }
                        }],
                        mods: {
                            checked: checked(data.allow_device_targeting),
                            disabled: checked(!hasLoginRights('super_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'allow_device_targeting'
                        }
                    }
                },
                userRoleIs('superreader') && hasLoginRights('super_control', 'is_developer', 'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'rol-super-menedzher', 'Роль супер-менеджер:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'is_super_manager'
                            }
                        }],
                        mods: {
                            checked: checked(data.is_super_manager),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'is_super_manager'
                        }
                    }
                },
                userRoleIs('agency') && hasLoginRights('super_control', 'is_developer', 'manager_control',
                    'support_control', 'superreader_control', 'limited_support_control') && {
                        label: iget2('b-modify-user', 'status-agentstva', 'Статус агентства:'),
                        control: {
                            block: 'select',
                            name: 'agency_status',
                            content: [
                                {
                                    block: 'button',
                                    mix: {
                                        block: 'select',
                                        elem: 'button'
                                    },
                                    content: agencyStatuses[data.agency_status]
                                },
                                {
                                    elem: 'control',
                                    content: Object.keys(agencyStatuses).map(function(status) {
                                        var result = {
                                            elem: 'option',
                                            attrs: {
                                                value: status
                                            },
                                            content: agencyStatuses[status]
                                        };

                                        status === data.agency_status && (result.attrs.selected = 'selected');

                                        return result;
                                    }, this)
                                }
                            ]
                        }
                    },
                (hasLoginRights('manager_control', 'support_control', 'limited_support_control', 'super_control') &&
                    (data.serviced || (userRoleIs('agency') && hasLoginRights('SetAgencyNotResident')))) && {
                        label: iget2('b-modify-user', 'nerezident-177', 'Нерезидент:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'not_resident'
                                }
                            }],
                            mods: {
                                checked: checked(data.not_resident),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                value: 'Yes',
                                name: 'not_resident'
                            }
                        }
                    } || (data.not_resident && {
                        label: '&nbsp;',
                        control: {
                            block: 'b-modify-user',
                            elem: 'not-resident',
                            content: iget2('b-modify-user', 'nerezident-178', 'нерезидент')
                        }
                    }),
                (data.user_is_any_client && hasLoginRights('super_control', 'placer_control', 'support_control', 'limited_support_control')) && {
                    label: iget2('b-modify-user', 'zablokirovat-favikonki-na-vydache', 'Заблокировать фавиконки на выдаче:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'is_favicon_blocked'
                            }
                        }],
                        mods: {
                            checked: checked(data.is_favicon_blocked),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'is_favicon_blocked'
                        }
                    }
                },
                (hasLoginRights('super_control', 'placer_control', 'support_control') || !!data.report_name) && [
                    {
                        label: iget2(
                            'b-modify-user',
                            'report-name',
                            'Публичное название рекламодателя для&nbsp;Transparency report:'
                        ),
                        control: hasLoginRights('super_control', 'placer_control', 'support_control') ?
                            {
                                block: 'input',
                                mix: [{
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                }],
                                name: 'report_name',
                                content: inputControl(data.report_name || '')
                            } :
                            u.escapeHTML(data.report_name || '')
                    },
                    {
                        label: iget2('b-modify-user', 'social-advertising', 'Является социальным клиентом:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'social_advertising'
                                }
                            }],
                            mods: {
                                checked: checked(data.social_advertising),
                                disabled: checked(!hasLoginRights('super_control', 'placer_control', 'support_control'))
                            },
                            checkboxAttrs: {
                                value: 1,
                                name: 'social_advertising'
                            }
                        }
                    }
                ],
                (data.allow_edit_description && !hasLoginRights('agency_control')) && [
                    {
                        label: '&nbsp;',
                        control: {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [{
                                block: 'b-modify-user',
                                elem: 'copy-user-data'
                            }],
                            content: iget2('b-modify-user', 'skopirovat-dannye-polzovatelya-v', 'Скопировать данные пользователя в поле')
                        }
                    },
                    {
                        mixes: {
                            row: [{
                                block: 'b-modify-user',
                                elem: 'row'
                            }],
                            control: [{
                                block: 'b-modify-user',
                                elem: 'control'
                            }],
                            label: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'label'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'description'
                                }
                            ]
                        },
                        label: iget2('b-modify-user', 'primechaniya', 'Примечания:'),
                        control: {
                            block: 'input',
                            mods: {
                                type: 'textarea'
                            },
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'descriptions'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'description'
                                    }
                                }
                            ],
                            name: 'description',
                            value: u.escapeHTML(data.description || ''),
                            content: {
                                elem: 'control',
                                attrs: {
                                    rows: 4,
                                    value: data.description || ''
                                }
                            }
                        }
                    }
                ],
                userRoleIs('agency') &&
                    hasLoginRights('manager_control', 'super_control', 'is_developer', 'ForbidAgencyAddRights') && {
                        label: iget2('b-modify-user', 'dop-prava-agentstvam', 'Доп.права агентствам:'),
                        control: [
                            (hasLoginRights('manager_control') &&
                            data.UID === data.ManagerOfAgencyUID ||
                            hasLoginRights('super_control', 'is_developer')) && [
                                {
                                    block: 'b-modify-user',
                                    elem: 'additional-right',
                                    content: [
                                        {
                                            block: 'checkbox',
                                            mix: [{
                                                block: 'i-glue',
                                                elem: 'model-field',
                                                js: {
                                                    type: 'checkbox',
                                                    name: 'sendAgencyMcbLetters'
                                                }
                                            }],
                                            text: iget2('b-modify-user', 'otpravlyat-kopii-pisem-po', 'Отправлять копии писем по МКБ кампаниям менеджеру агентства:'),
                                            mods: {
                                                checked: checked(data.sendAgencyMcbLetters)
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'sendAgencyMcbLetters',
                                                id: 'sendAgencyMcbLetters'
                                            }
                                        }
                                    ]
                                },

                                {
                                    block: 'b-modify-user',
                                    elem: 'additional-right',
                                    content: [
                                        {
                                            block: 'checkbox',
                                            mix: [{
                                                block: 'i-glue',
                                                elem: 'model-field',
                                                js: {
                                                    type: 'checkbox',
                                                    name: 'sendAgencyDirectLetters'
                                                }
                                            }],
                                            text: iget2(
                                                'b-modify-user',
                                                'otpravlyat-kopii-pisem-o-179',
                                                'Отправлять копии писем о событиях по кампаниям агентства в Директе менеджеру агентства:'
                                            ),
                                            mods: {
                                                checked: checked(data.sendAgencyDirectLetters)
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'sendAgencyDirectLetters',
                                                id: 'sendAgencyDirectLetters'
                                            }
                                        }
                                    ]
                                }
                            ],
                            hasLoginRights('manager_control', 'super_control', 'is_developer') && [
                                {
                                    block: 'b-modify-user',
                                    elem: 'additional-right',
                                    content: [
                                        {
                                            block: 'checkbox',
                                            mix: [{
                                                block: 'i-glue',
                                                elem: 'model-field',
                                                js: {
                                                    type: 'checkbox',
                                                    name: 'AllowAgencyMassADVQ'
                                                }
                                            }],
                                            text: iget2('b-modify-user', 'agentstvo-mozhet-uvelichivat-limit', 'Агентство может увеличивать лимит запросов в "подборе слов":'),
                                            mods: {
                                                checked: checked(data.AllowAgencyMassADVQ)
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'AllowAgencyMassADVQ',
                                                id: 'AllowAgencyMassADVQ'
                                            }
                                        }
                                    ]
                                }
                            ]
                        ]
                    },
                (data.user_is_any_client && data.client_by_agency_rights && hasLoginRights('ModifySubClient')) && {
                    label: iget2('b-modify-user', 'dopolnitelnye-prava', 'Дополнительные права:'),
                    control: [
                        data.client_by_agency_rights.map(function(client_rights) {
                            return {
                                block: 'b-modify-user',
                                elem: 'additional-rights',
                                content: [
                                    !hasLoginRights('agency_control') && {
                                        block: 'b-modify-user',
                                        elem: 'agency-title',
                                        content: [
                                            iget2('b-modify-user', 'agentstvo', 'Агентство'), ': ',
                                            {
                                                block: 'b-text',
                                                tag: 'strong',
                                                content: client_rights.agency_name
                                            }
                                        ]
                                    },

                                    client_rights.agency_control ? iget2('b-modify-user', 'primechaniya', 'Примечания:') : iget2('b-modify-user', 'primechaniya-agentstva', 'Примечания агентства:'),
                                    {
                                        block: ' b-modify-user',
                                        elem: 'additional-right',
                                        content: {
                                            block: 'input',
                                            mix: [{
                                                block: 'b-modify-user',
                                                elem: 'agency-remarks'
                                            }],
                                            mods: {
                                                type: 'textarea',

                                                disabled: hasLoginRights('support_control', 'limited_support_control') ? 'yes' : ''
                                            },
                                            name: 'client_description_' + client_rights.ClientID,
                                            value: client_rights.client_description || '',
                                            content: {
                                                elem: 'control',
                                                attrs: {
                                                    rows: 4
                                                }
                                            }
                                        }
                                    },
                                    {
                                        block: ' b-modify-user',
                                        elem: 'additional-right',
                                        elemMods: {
                                            disabled: hasLoginRights('support_control', 'limited_support_control') ? 'yes' : ''
                                        },
                                        mix: [{
                                            block: 'b-modify-user',
                                            elem: 'edit-campaign-right'
                                        }],
                                        content: {
                                            block: 'checkbox',
                                            mods: {
                                                checked: checked(client_rights.isSuperSubClient),
                                                disabled: hasLoginRights('support_control', 'limited_support_control') ? 'yes' : ''
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'isSuperSubClient_' + client_rights.ClientID
                                            },
                                            text: iget2('b-modify-user', 'redaktirovat-kampaniyu', 'редактировать кампанию.')
                                        }
                                    },
                                    {
                                        block: ' b-modify-user',
                                        elem: 'additional-right',
                                        elemMods: {
                                            disabled: hasLoginRights('support_control', 'limited_support_control') ? 'yes' : ''
                                        },
                                        content: {
                                            block: 'checkbox',
                                            mods: {
                                                checked: checked(client_rights.allowTransferMoney),

                                                disabled: hasLoginRights('support_control', 'limited_support_control') ? 'yes' : ''
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'allowTransferMoney_' + client_rights.ClientID
                                            },
                                            text: iget2('b-modify-user', 'perenosit-sredstva-s-kampanii', 'переносить средства с кампании на кампанию.')
                                        }
                                    },
                                    {
                                        block: ' b-modify-user',
                                        elem: 'additional-right',
                                        mix: [{
                                            block: 'b-modify-user',
                                            elem: 'xls-edit-right'
                                        }],
                                        mods: {
                                            disabled: hasLoginRights('support_control', 'limited_support_control') ?
                                                'yes' :
                                                (client_rights.isSuperSubClient ? '' : 'yes')
                                        },
                                        content: {
                                            block: 'checkbox',
                                            mods: {
                                                checked: checked(client_rights.allowImportXLS),
                                                disabled: hasLoginRights('support_control', 'limited_support_control') ?
                                                    'yes' :
                                                    (client_rights.isSuperSubClient ? '' : 'yes')
                                            },
                                            checkboxAttrs: {
                                                value: '1',
                                                name: 'allowImportXLS_' + client_rights.ClientID
                                            },
                                            text: iget2('b-modify-user', 'upravlenie-kampaniyami-s-pomoshchyu', 'управление кампаниями с помощью XLS/XLSX.')
                                        }
                                    }
                                ]
                            };
                        }, this)
                    ]
                },
                userRoleIs('manager') &&
                    hasLoginRights('super_control', 'is_developer', 'manager_control', 'support_control', 'superreader_control', 'limited_support_control') && {
                        label: iget2('b-modify-user', 'yandeks-ofis', 'Яндекс.Офис'),
                        control: {
                            block: 'select',
                            name: 'manager_office_id',
                            content: [
                                {
                                    block: 'button',
                                    content: (function() {
                                        var office = data.yandex_offices.filter(function(office) {
                                            return office.office_id == data.manager_office_id;
                                        }, this).pop() || data.yandex_offices[0];
                                        return office ? u.escapeHTML(office.office_name || '') : '';
                                    }.call(this))
                                },
                                {
                                    elem: 'control',
                                    content: data.yandex_offices.map(function(office) {
                                        var result = {
                                            elem: 'option',
                                            attrs: {
                                                value: office.office_id
                                            },
                                            content: u.escapeHTML(office.office_name || '')
                                        };

                                        office.office_id == data.manager_office_id &&
                                            (result.attrs.selected = 'selected');

                                        return result;
                                    }, this)
                                }
                            ]
                        }
                    },
                userRoleIs('manager') && [
                    {
                        label: iget2('b-modify-user', 'peredavat-uvedomleniya-v-crm', 'Передавать уведомления в CRM'),
                        control: {
                            block: 'checkbox',
                            mix: [
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'checkbox',
                                        name: 'manager_use_crm'
                                    }
                                }
                            ],
                            mods: {
                                checked: checked(data.manager_use_crm),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                value: '1',
                                name: 'manager_use_crm'
                            }
                        }
                    },
                    {
                        label: iget2('b-modify-user', 'e-mail-outlook-180', 'E-mail (Outlook):'),
                        control: {
                            block: 'input',
                            mix: [{
                                block: 'b-modify-user',
                                elem: 'inline-input'
                            }],
                            name: 'manager_private_email',
                            content: inputControl(data.manager_private_email || '')
                        },
                        mixes: {
                            row: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'row'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'private-email',
                                    elemMods: {
                                        show: data.manager_use_crm ? 'yes' : 'no'
                                    }
                                }
                            ],
                            //todo оторвать, когда b-layout-form научится оставлять неперекрытые миксы
                            label: [{
                                block: 'b-modify-user',
                                elem: 'label'
                            }],
                            control: [{
                                block: 'b-modify-user',
                                elem: 'control'
                            }]
                        }
                    }
                ],
                hasLoginRights('super_control', 'is_developer', 'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'testovyy-polzovatel', 'Тестовый пользователь:'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'hidden_status'
                            }
                        }],
                        mods: {
                            checked: checked(data.hidden_status),
                            disabled: checked(hasLoginRights('limited_support_control'))
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'hidden_status'
                        }
                    }
                },
                hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') && {
                    label: {
                        content: iget2('b-modify-user', 'pokazyvat-kapchu-cherez-kazhdye', 'Показывать капчу через каждые:'),
                        attrs: {
                            for: 'id_captcha_freq'
                        }
                    },
                    control: [
                        hasLoginRights('support_control', 'limited_support_control') ?
                            {
                                block: 'b-modify-user',
                                elem: 'captcha-freq',
                                content: u.escapeHTML(data.captcha_freq)
                            } :
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-modify-user',
                                        elem: 'inline-input',
                                        elemMods: {
                                            type: 'small'
                                        }
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'captcha_freq'
                                        }
                                    }
                                ],
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        name: 'captcha_freq',
                                        id: 'id_captcha_freq',
                                        value: u.escapeHTML(data.captcha_freq)
                                    }
                                }
                            },
                        ' ', iget2('b-modify-user', 'zaprosov', 'запросов'),
                        (function() {
                            var result = '';

                            if (data.is_captcha_amnested) result = ['(', iget2('b-modify-user', 'avtomaticheskaya-kapcha-vyklyuchena', 'автоматическая капча выключена'), ')'];
                            if (data.captcha_freq && data.captcha_expires) result = ['(', iget2('b-modify-user', 'avtomaticheski-vyklyuchitsya-s', 'автоматически выключится {foo}', {
                                foo: data.captcha_expires
                            }), ')'];

                            return result;
                        }())
                    ]
                },

                data.user_is_any_client && hasLoginRights(
                    'super_control', 'is_developer', 'support_control',
                    'is_superteamleader', 'is_teamleader', 'manager_control', 'superreader_control', 'limited_support_control') && {
                        label: iget2('b-modify-user', 'tekushchee-porogovoe-chislo-fraz', 'Текущее пороговое число фраз для авто-показа капчи:'),
                        control: [
                            {
                                block: 'b-modify-user',
                                elem: 'autoban-limit',
                                content: data.autoban_current_limit
                            },
                            ' ',
                            {
                                content: [
                                    iget2('b-modify-user', 'chislo-bonusnyh-fraz', 'число бонусных фраз'), ': ',
                                    {
                                        block: 'input',
                                        mix: [
                                            {
                                                block: 'b-modify-user',
                                                elem: 'inline-input'
                                            },
                                            {
                                                block: 'i-glue',
                                                elem: 'model-field',
                                                js: {
                                                    type: 'input',
                                                    name: 'autoban_bonus'
                                                }
                                            }
                                        ],
                                        name: 'autoban_bonus',
                                        content: inputControl(data.autoban_bonus)
                                    }
                                ]
                            },
                            !!data.is_autobanned && [
                                iget2('b-modify-user', 'polzovatel-byl-avtomaticheski-ogranichen', 'пользователь был автоматически ограничен {date}', {
                                    date: {
                                        block: 'b-modify-user',
                                        elem: 'autoban-date',
                                        content: data.autoban_date
                                    }
                                }),
                                {
                                    content: [
                                        iget2('b-modify-user', 'obshchee-chislo-fraz', 'общее число фраз'), ': ',
                                        {
                                            block: 'b-modify-user',
                                            elem: 'autoban-bids-count',
                                            content: data.clients_autoban_bids_count
                                        }
                                    ]
                                },
                                {
                                    block: 'b-text',
                                    content: [
                                        iget2('b-modify-user', 'summa-na-kliente', 'сумма на клиенте'), ': ',
                                        {
                                            block: 'b-modify-user',
                                            elem: 'autoban-sum-total',
                                            content: u.round2s(data.clients_autoban_sum_total)
                                        }
                                    ]
                                }
                            ],
                            !data.is_autobanned && data.autoban_date &&
                                ['(', {
                                    block: 'b-modify-user',
                                    elem: 'autoban-date',
                                    content: iget2('b-modify-user', 'ogranichenie-bylo-snyato-s', 'ограничение было снято {foo}', {
                                        foo: data.autoban_date
                                    })
                                }, ')']
                        ]
                    },
                hasLoginRights('super_control', 'is_developer', 'placer_control', 'support_control', 'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'zablokirovan-v-interfeyse', 'Заблокирован в интерфейсе:'),
                    control: hasLoginRights('support_control') ?
                        ({
                            block: 'b-modify-user',
                            elem: 'blocked-in-interface',
                            content: data.statusBlocked ? iget2('b-modify-user', 'da', 'Да') : iget2('b-modify-user', 'net', 'Нет')
                        }) : {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'statusBlocked'
                                }
                            }],
                            mods: {
                                checked: checked(data.statusBlocked),
                                // чтобы проходил перловый юнит-тест `no_settings_all.t`
                                // eslint-disable-next-line max-len
                                disabled: data.is_production && !(data.user_is_any_client || data.user_role == 'agency') || hasLoginRights('limited_support_control') ? 'yes' : ''
                            },
                            checkboxAttrs: {
                                value: 'Yes',
                                name: 'blocked_status'
                            }
                        }
                },
                hasLoginRights('super_control', 'is_developer', 'support_control', 'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'razreshyonnye-ip', 'Разрешённые ip:'),
                    control: {
                        block: 'input',
                        mix: [
                            {
                                block: 'b-modify-user',
                                elem: 'inline-input'
                            },
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'input',
                                    name: 'allowed_ips'
                                }
                            }
                        ],
                        name: 'allowed_ips',
                        content: inputControl(data.allowed_ips || '')
                    }
                },
                data.user_is_any_client && hasLoginRights('super_control', 'is_developer', 'superreader_control', 'limited_support_control') && {
                    label: iget2('b-modify-user', 'klient-razmeshchaet-reklamu-yandeksa', 'Клиент размещает рекламу Яндекса'),
                    control: [
                        {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'statusYandexAdv'
                                }
                            }],
                            mods: {
                                checked: checked(data.statusYandexAdv),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                id: 'id_statusYandexAdv',
                                value: 'Yes',
                                name: 'statusYandexAdv'
                            },
                            text: iget2('b-modify-user', 'tolko-v-setyah', 'только в сетях')
                        },
                        {
                            block: 'checkbox',
                            mix: [
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'checkbox',
                                        name: 'showOnYandexOnly'
                                    }
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'yandex-only-checkbox'
                                }
                            ],
                            mods: {
                                checked: checked(data.showOnYandexOnly),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                id: 'id_showOnYandexOnly',
                                value: 'Yes',
                                name: 'showOnYandexOnly'
                            },
                            text: iget2('b-modify-user', 'tolko-v-yandekse', 'только в Яндексе')
                        }
                    ]
                },
                userRoleIs('placer') && hasLoginRights('super_control', 'is_developer') && {
                    label: iget2(
                        'b-modify-user',
                        'vozmozhnost-prinimat-importiruemye-bannery',
                        'Возможность принимать импортируемые баннеры без модерации:'
                    ),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'isSuperPlacer'
                            }
                        }],
                        mods: {
                            checked: checked(data.isSuperPlacer)
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'isSuperPlacer'
                        }
                    }
                },
                userRoleIs('media') && hasLoginRights('super_control', 'is_developer') && {
                    label: {
                        content: [iget2('b-modify-user', 'supermediaplaner', 'Супермедиапланер'), ':'],
                        for: 'id_supermedia'
                    },
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'checkbox',
                                name: 'isSuperMedia'
                            }
                        }],
                        mods: {
                            checked: checked(data.isSuperMedia)
                        },
                        checkboxAttrs: {
                            value: '1',
                            name: 'isSuperMedia'
                        }
                    }
                },
                hasLoginRights(
                    'super_control', 'is_developer', 'support_control', 'placer_control',
                    'is_superteamleader', 'is_teamleader', 'manager_control', 'superreader_control', 'limited_support_control') && {
                        label: iget2('b-modify-user', 'zablokirovan-po-karme-pasporta', 'Заблокирован по карме Паспорта'),
                        control: [
                            {
                                block: 'checkbox',
                                mix: [
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'checkbox',
                                            name: 'is_bad_passport_karma'
                                        }
                                    }, {
                                        block: 'b-modify-user',
                                        elem: 'inline-control'
                                    }
                                ],
                                mods: {
                                    checked: checked(data.is_bad_passport_karma),
                                    disabled: checked(hasLoginRights('limited_support_control'))
                                },
                                checkboxAttrs: {
                                    value: 'Yes',
                                    name: 'is_bad_passport_karma'
                                }
                            }, hasLoginRights('limited_support_control') && {
                                block: 'link',
                                content: iget2('b-modify-user', 'go-to-internal-tool', 'управление через внутренний отчет'),
                                target: '_blank',
                                url: u.formatUrl({
                                    host: data.SCRIPT_CLEAR,
                                    query: {
                                        cmd: 'internalReports',
                                        report_id: 'change_passport_karma_lock_state',
                                        ir_param_action_type: '0',
                                        ir_param_uid: data.uid
                                    }
                                })
                            }
                        ]
                    },
                data.user_is_any_client && hasLoginRights('super_control', 'support_control') && [
                    {
                        label: iget2('b-modify-user', 'limit-kampaniy-na-clientid', 'Лимит кампаний на ClientID:'),
                        control: [
                            iget2('b-modify-user', 'active-aktivnyh-i-total', '{active} активных и {total} всего', {
                                active: {
                                    block: 'b-modify-user',
                                    elem: 'active-camp-limit',
                                    content: data.unarc_camp_count_limit
                                },

                                total: {
                                    block: 'b-modify-user',
                                    elem: 'camp-limit',
                                    content: data.camp_count_limit
                                }
                            }), ' ',
                            {
                                block: 'link',
                                url: u.getUrl('clientLimits', {
                                    action: 'view'
                                }),
                                content: iget2('b-modify-user', 'izmenit', 'изменить')
                            }
                        ]
                    },
                    {
                        label: {
                            content: iget2('b-modify-user', 'limit-chisla-obyavleniy-v', 'Лимит числа объявлений в каждой кампании ClientID:'),
                            for: 'id_banner_count_limit'
                        },
                        control: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-modify-user',
                                        elem: 'inline-input'
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'banner_count_limit'
                                        }
                                    }
                                ],
                                name: 'banner_count_limit',
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        id: 'id_banner_count_limit',
                                        value: data.banner_count_limit || ''
                                    }
                                }
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'default-value-hint',
                                content: [
                                    iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                    ' ',
                                    u.escapeHTML(data.default_banner_count_limit || '')
                                ]
                            }
                        ]
                    },
                    {
                        label: {
                            content: iget2('b-modify-user', 'limit-chisla-klyuchevyh-fraz', 'Лимит числа ключевых фраз в каждой группе ClientID:'),
                            for: 'id_keyword_count_limit'
                        },
                        control: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-modify-user',
                                        elem: 'inline-input'
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'keyword_count_limit'
                                        }
                                    }
                                ],
                                name: 'keyword_count_limit',
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        id: 'id_keyword_count_limit',
                                        value: data.keyword_count_limit || ''
                                    }
                                }
                            },
                            !!data.default_keyword_count_limit && {
                                block: 'b-modify-user',
                                elem: 'default-value-hint',
                                content: [
                                    iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                    ' ',
                                    u.escapeHTML(data.default_keyword_count_limit)
                                ]
                            }
                        ]
                    },
                    {
                        label: {
                            content: iget2('b-modify-user', 'limit-kolichestva-fidov-na', 'Лимит количества фидов на ClientID:'),
                            for: 'id_feed_count_limit'
                        },
                        control: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-modify-user',
                                        elem: 'inline-input'
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'feed_count_limit'
                                        }
                                    }
                                ],
                                name: 'feed_count_limit',
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        id: 'id_feed_count_limit',
                                        value: data.feed_count_limit || ''
                                    }
                                }
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'default-value-hint',
                                content: [
                                    iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                    ' ',
                                    u.escapeHTML(data.default_feed_count_limit || '')
                                ]
                            }
                        ]
                    },
                    {
                        label: {
                            content: iget2('b-modify-user', 'maksimalnoe-ogranichenie-na-razmera', 'Максимальное ограничение на размера файла фида (в байтах):'),
                            for: 'id_feed_max_file_size'
                        },
                        control: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-modify-user',
                                        elem: 'inline-input'
                                    },
                                    {
                                        block: 'i-glue',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'feed_max_file_size'
                                        }
                                    }
                                ],
                                name: 'feed_max_file_size',
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        id: 'id_feed_max_file_size',
                                        value: data.feed_max_file_size || ''
                                    }
                                }
                            },
                            {
                                block: 'b-modify-user',
                                elem: 'default-value-hint',
                                content: [
                                    iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                    ' ',
                                    u.numberFormatter.format(+data.default_feed_max_file_size || 0, {
                                        precision: 0
                                    }),
                                    ' ',
                                    iget2('b-modify-user', 'bayt', 'байт'),
                                    ' (',
                                    u.numberFormatter.format((+data.default_feed_max_file_size || 0) / (1024 * 1024), {
                                        precision: 0
                                    }),
                                    ' ',
                                    iget2('b-modify-user', 'mb', 'Мб'),
                                    ')'
                                ]
                            }
                        ]
                    }
                ],
                hasLoginRights('super_control') && data.ClientID > 0 && [
                    {
                        label: iget2('b-modify-user', 'pokazyvat-tizer-dlya-perevoda', 'Показывать тизер для перевода в валюту:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'force_multicurrency_teaser'
                                }
                            }],
                            mods: {
                                checked: checked(data.force_multicurrency_teaser)
                            },
                            checkboxAttrs: {
                                value: 'on',
                                name: 'force_multicurrency_teaser'
                            }
                        }
                    },
                    data.force_multicurrency_teaser && {
                        label: iget2('b-modify-user', 'razreshit-konvertaciyu-bez-kopirovaniya', 'Разрешить конвертацию без копирования (в рубли)'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'modify_convert_allowed'
                                }
                            }],
                            mods: {
                                checked: checked(data.modify_convert_allowed)
                            },
                            checkboxAttrs: {
                                name: 'modify_convert_allowed'
                            }
                        }
                    }
                ],
                data.user_is_any_client &&
                    data.has_agency_campaigns &&
                    hasLoginRights('super_control', 'support_control', 'limited_support_control','manager_control') && {
                        label: iget2('b-modify-user', 'zapretit-perenos-sredstv-s', 'Запретить перенос средств с клиента:'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'disallow_money_transfer'
                                }
                            }],
                            mods: {
                                checked: checked(data.disallow_money_transfer),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                value: 'Yes',
                                name: 'disallow_money_transfer'
                            }
                        }
                    },
                hasLoginRights('placer_control') && (userRoleIs('agency') || data.user_is_any_client) && [
                    {
                        label: iget2('b-modify-user', 'dostup-k-api', 'Доступ к API:'),
                        control: data.can_use_api ? iget2('b-modify-user', 'vklyuchen', 'Включен') : iget2('b-modify-user', 'vyklyuchen', 'Выключен')
                    }
                ],
                hasLoginRights('super_control', 'placer_control', 'support_control', 'limited_support_control') && [
                    {
                        label: iget2('b-modify-user', 'otklyuchit-pokazy-otobrazhaemoy-ssylki', 'Отключить показы отображаемой ссылки'),
                        control: {
                            block: 'checkbox',
                            mix: [{
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    type: 'checkbox',
                                    name: 'no_display_hrefs'
                                }
                            }],
                            mods: {
                                checked: checked(data.no_display_hrefs),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                value: 1,
                                name: 'no_display_hrefs'
                            }
                        }
                    }
                ],
                hasLoginRights('super_control', 'support_control', 'placer_control', 'limited_support_control') && [
                    {
                        label: iget2('b-modify-user', 'otklyuchit-pokazy-video-dopolneniy', 'Отключить показы видео-дополнений'),
                        control: {
                            block: 'checkbox',
                            mods: {
                                checked: checked(data.suspend_video),
                                disabled: checked(hasLoginRights('limited_support_control'))
                            },
                            checkboxAttrs: {
                                value: 1,
                                name: 'suspend_video'
                            }
                        }
                    }
                ],
                hasLoginRights('super_control') && (userRoleIs('manager') || userRoleIs('support')) && [
                    {
                        label: iget2('b-modify-user', 'can-manage-price-product', 'Может заводить продукты'),
                        control: {
                            block: 'checkbox',
                            mix: [
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'checkbox',
                                        name: 'can_manage_price_packages'
                                    }
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'canManagePricePackages'
                                }
                            ],
                            mods: {
                                checked: checked(data.can_manage_price_packages),
                                disabled: checked(data.can_approve_price_packages)
                            },
                            checkboxAttrs: {
                                value: 1,
                                name: 'can_manage_price_packages'
                            }
                        }
                    }
                ],
                hasLoginRights('super_control') && (userRoleIs('manager') || userRoleIs('support')) && [
                    {
                        label: iget2('b-modify-user', 'can-approve-price-product', 'Может апрувить продукты'),
                        control: {
                            block: 'checkbox',
                            mix: [
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'checkbox',
                                        name: 'can_approve_price_packages'
                                    }
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'canApprovePricePackages'
                                }
                            ],
                            mods: {
                                checked: checked(data.can_approve_price_packages),
                                disabled: checked(data.can_manage_price_packages)
                            },
                            checkboxAttrs: {
                                value: 1,
                                name: 'can_approve_price_packages'
                            }
                        }
                    }
                ],
                hasLoginRights('super_control') && {
                    label: {
                        content: iget2('b-modify-user', 'dont-show-label', 'Ограничение на запрещённые площадки'),
                        for: 'general_blacklist_size_limit'
                    },
                    control: [
                        {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'general_blacklist_size_limit'
                                    }
                                }
                            ],
                            name: 'general_blacklist_size_limit',
                            content: {
                                elem: 'control',
                                attrs: {
                                    id: 'id_general_blacklist_size_limit',
                                    value: u.escapeHTML(data.general_blacklist_size_limit || '')
                                }
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'default-value-hint',
                            content: [
                                iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                ' ',
                                1000
                            ]
                        }
                    ]
                },
                hasLoginRights('super_control') && {
                    label: {
                        content: iget2('b-modify-user', 'dont-show-video-label', 'Ограничение на запрещённые площадки видеообъявлений'),
                        for: 'video_blacklist_size_limit'
                    },
                    control: [
                        {
                            block: 'input',
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'video_blacklist_size_limit'
                                    }
                                }
                            ],
                            name: 'video_blacklist_size_limit',
                            content: {
                                elem: 'control',
                                attrs: {
                                    id: 'id_video_blacklist_size_limit',
                                    value: u.escapeHTML(data.video_blacklist_size_limit || '')
                                }
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'default-value-hint',
                            content: [
                                iget2('b-modify-user', 'po-umolchaniyu-171', 'по умолчанию'),
                                ' ',
                                20
                            ]
                        }
                    ]
                },
                hasLoginRights('super_control', 'manager_control', 'support_control') && {
                    label: {
                        content: iget2('b-modify-user', 'default_disallowed_page_ids', 'PageID на которых запрещены показы'),
                        for: 'default_disallowed_page_ids'
                    },
                    control: [
                        {
                            block: 'input',
                            mods: {
                                type: 'textarea'
                            },
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'descriptions'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'default_disallowed_page_ids'
                                    }
                                }
                            ],
                            name: 'default_disallowed_page_ids',
                            value: u.escapeHTML(data.default_disallowed_page_ids || ''),
                            content: {
                                elem: 'control',
                                attrs: {
                                    rows: 4,
                                    value: data.default_disallowed_page_ids || ''
                                }
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'default-value-hint',
                            content: iget2('b-modify-user', 'list-of-page-id', 'список PageID площадок')
                        }
                    ]
                },
                hasLoginRights('super_control', 'manager_control', 'support_control') && {
                    label: {
                        content: iget2('b-modify-user', 'default_allowed_domains', 'Белый список площадок по домену'),
                        for: 'default_allowed_domains'
                    },
                    control: [
                        {
                            block: 'input',
                            mods: {
                                type: 'textarea'
                            },
                            mix: [
                                {
                                    block: 'b-modify-user',
                                    elem: 'inline-input'
                                },
                                {
                                    block: 'b-modify-user',
                                    elem: 'descriptions'
                                },
                                {
                                    block: 'i-glue',
                                    elem: 'model-field',
                                    js: {
                                        type: 'input',
                                        name: 'default_allowed_domains'
                                    }
                                }
                            ],
                            name: 'default_allowed_domains',
                            value: u.escapeHTML(data.default_allowed_domains || ''),
                            content: {
                                elem: 'control',
                                attrs: {
                                    rows: 4,
                                    value: data.default_allowed_domains || ''
                                }
                            }
                        },
                        {
                            block: 'b-modify-user',
                            elem: 'default-value-hint',
                            content: iget2('b-modify-user', 'list-of-domain', 'список доменов площадок')
                        }
                    ]
                },
                {
                    mixes: { row: { block: 'b-modify-user', elem: 'hidden-row' } },
                    control: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                name: 'json_agency_options',
                                value: JSON.stringify({ // ignore stringify
                                    allow_clients_without_wallet: (data.agency_options || {})
                                        .allow_clients_without_wallet || '0',
                                    default_clients_with_wallet: (data.agency_options || {})
                                        .default_clients_with_wallet || '0'
                                })
                            }
                        },
                        mix: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                type: 'input',
                                name: 'agencyOptions'
                            }
                        }
                    }
                }
            ]).filter(identity);
        }.call(this)),

        hiddenInputs: u.flatten([
            commonHiddenInputs,
            hasLoginRights('super_control', 'is_developer', 'manager_control', 'superreader_control', 'limited_support_control') &&
                {
                    name: 'geo_id',
                    value: u.escapeHTML(data.geo_id),
                    mix: [{
                        block: 'b-modify-user',
                        elem: 'geoId'
                    }]
                },
            data.dont_edit_fio_email_by_agency && [
                {
                    name: 'FIO',
                    value: u.escapeHTML(data.FIO)
                },
                {
                    name: 'email',
                    value: u.escapeHTML(data.email)
                }
            ],
            data.can_edit_country_currency && data.edit_country_currency && {
                name: 'edit_country_currency',
                value: 1
            },
            hasLoginRights('super_control', 'placer_control', 'support_control') || {
                name: 'report_name',
                value: u.escapeHTML(data.report_name || '')
            }
        ]).filter(identity)
    };

    u.escapeHTML = originalEscape;

    return result;
});
