block('b-modify-user').content()(function() {
    var data = this.data,
        isAuditTabEnabled = hasLoginRights('super_control', 'support_control'),
        commonHiddenInputs = [
            {
                name: 'cmd',
                value: 'modifyUser'
            },
            {
                name: 'save',
                value: 'yes'
            },
            data.rcmd && {
                name: 'rcmd',
                value: data.rcmd
            },
            data.FORM.retpath && {
                name: 'retpath',
                value: data.FORM.retpath
            },
            !(data.rcmd == 'showManagerMyClients' && hasLoginRights('manager_control')) &&
                !(('showClients', 'showAgReps', 'clientDescriptions').indexOf(data.rcmd) !== -1 &&
                    hasLoginRights('agency_control') && !data.FORM.rulogin) && {
                        name: 'rulogin',
                        value: u.escapeHTML(data.FORM.rulogin || '')
                    },
            data.uid_par && {
                name: data.uid_par.key,
                value: data.uid_par.value
            }
        ];

    return [
        {
            block: 'b-page-title',
            title: this.ctx.title
        },
        {
            elem: 'error',
            content: data.error && data.error.replace(/\n/g, '<br/>')
        },
        data.FORM.rcmd === 'showStaff' && {
            block: 'link',
            mix: [{
                block: 'b-modify-user',
                elem: 'staff-link'
            }],
            url: u.getUrl('showStaff'),
            content: iget2('b-modify-user', 'sotrudniki', 'Сотрудники')
        },
        {
            block: 'tabs',
            mods: {
                control: 'menu',
                'with-confirm': 'yes',
                size: 's',
                theme: 'border-bottom',
                layout: 'horiz'
            },
            panes: 'modify-user-tabs',
            content: [
                {
                    elem: 'tab',
                    elemMods: { active: 'yes' },
                    content: {
                        block: 'link',
                        content: iget2('b-modify-user', 'obshchie', 'Общие')
                    }
                },
                hasLoginRights('super_control', 'is_developer', 'manager_control', 'support_control', 'superreader_control', 'limited_support_control') &&
                    {
                        elem: 'tab',
                        content: {
                            block: 'link',
                            content: iget2('b-modify-user', 'parametry-api-i-xls', 'Параметры API и XLS/XLSX')
                        }
                    },
                isAuditTabEnabled &&
                    {
                        elem: 'tab',
                        content: {
                            block: 'link',
                            content: iget2('b-modify-user', 'tab-name-audit-systems', 'Системы аудита')
                        }
                    }
            ].filter(Boolean)
        },
        {
            block: 'tabs-panes',
            id: 'modify-user-tabs',
            content: [
                {
                    elem: 'pane',
                    elemMods: { active: 'yes' },
                    content: {
                        block: 'b-modify-user',
                        elem: 'general-settings',
                        js: this.ctx.js,
                        commonHiddenInputs: commonHiddenInputs
                    }
                },
                hasLoginRights('super_control', 'is_developer', 'manager_control', 'support_control', 'superreader_control', 'limited_support_control') && {
                    elem: 'pane',
                    content: {
                        block: 'b-modify-user',
                        elem: 'api-settings',
                        commonHiddenInputs: commonHiddenInputs
                    }
                },
                isAuditTabEnabled && {
                    elem: 'pane',
                    content: {
                        block: 'b-modify-user',
                        elem: 'audit-system',
                        permittedProviders: (data.pixels || {}).permitted_providers
                    }
                }
            ]
        }
    ];
});
