BEM.DOM.decl('b-modify-user', {
    onSetMod: {
        js: function() {
            //форсим инициализацию i-glue
            u.graspSelf.call(this, {
                _api: '? i-glue inside api-settings',
                _general: 'i-glue inside general-settings',
                _setButton: '? button on method-limit-set',
                _resetButton: '? button on method-limit-reset',
                _cityInput: '? input on city',
                _tabsMenu: '? tabs-menu inside',
                _canManagePricePackages: '? checkbox on canManagePricePackages',
                _canApprovePricePackages: '? checkbox on canApprovePricePackages',
                _roles: '? radiobox on role-radiobox',
                _permissionControls: 'permission-control'
            });

            var params = this.params,
                _this = this,
                apiSettingsModel = this._apiSettingsModel = BEM.MODEL.getOne({
                    name: 'm-modify-user-api-settings',
                    id: 'm-modify-user-api-settings'
                }),
                generalSettingsModel = this._generalSettingsModel = BEM.MODEL.getOne({
                    name: 'm-modify-user-general-settings',
                    id: 'm-modify-user-general-settings'
                }),
                subscriptionManager = this._subscriptionManager = BEM.create('i-subscription-manager'),
                emptyLimitsLabel = this.elem('empty-limits-label'),
                updateResetButtonState = function() {
                    _this._resetButton.setMod('disabled',
                        _this._getLimitList(apiSettingsModel.get('current-method-limit-name')) ? '' : 'yes');
                };

            this._limitsList = this.elem('limits-list');

            this._bindValidation()._enableAddDescription();

            subscriptionManager.on(this._tabsMenu, 'ask-confirm', function(e, data) {
                var prevSelectedType = data.prevIndex === 0 ? 'general' : 'api',
                    model = prevSelectedType === 'general' ? generalSettingsModel : apiSettingsModel;

                if (model.isChanged() && !this._cofirmInProgress) {
                    this._cofirmInProgress = true;

                    BEM.blocks['b-confirm'].open({
                        message: iget2(
                            'b-modify-user',
                            'est-nesohranennye-izmeneniya-pri',
                            'Есть несохраненные изменения. При переходе на другую вкладку они будут потеряны. Действительно хотите перейти?'
                        ),
                        type: 'confirm',
                        onYes: function() {
                            model.rollback();
                            data.deferred.resolve();
                            this._cofirmInProgress = false;
                        }.bind(this),
                        onNo: function() {
                            this._cofirmInProgress = false;
                            data.deferred.fail();
                        }.bind(this),
                        ctx: this
                    });
                } else {
                    !this._cofirmInProgress && data.deferred.resolve();
                }

            }, this);

            if (params.permission.limitsRead) {
                params.methodLimits || (params.methodLimits = {});

                subscriptionManager.wrap(apiSettingsModel)
                    //значение ограничения
                    .on('current-method-limit-name', 'change', function() {
                        var limit = this._getLimitList(apiSettingsModel.get('current-method-limit-name'));

                        apiSettingsModel.set('current-method-limit-value', limit ? limit.get('value') : '');
                        updateResetButtonState();
                        apiSettingsModel.trigger('finishEditing');
                    }, this)
                    //лейбл при отсутствии заданных ограничений
                    .on('method-limits-list', 'change', function() {
                        this.setMod(emptyLimitsLabel, 'show', this._getLimitList().length ? 'no' : 'yes');
                        updateResetButtonState();
                    }, this)
                    //текстовое представление ограничений
                    .on('method-limits-list', 'change', this._formDescription, this);

                if (params.permission.limitsEdit) {
                    subscriptionManager.wrap(apiSettingsModel)
                        .on('startEditing', function() { this._setButton.setMod('disabled', '') }, this)
                        .on('finishEditing', function() { this._setButton.setMod('disabled', 'yes') }, this);

                    subscriptionManager.on(this._setButton, 'click', function() {
                        var name = apiSettingsModel.get('current-method-limit-name'),
                            value = apiSettingsModel.get('current-method-limit-value'),
                            model = this._getLimitList(name);

                        if (isNaN(parseInt(value, 10))) {
                            return BEM.blocks['b-confirm'].alert(iget2('b-modify-user', 'ogranicheniya-vyzovov-dolzhny-byt', 'Ограничения вызовов должны быть заданы целым числом'));
                        }

                        model ?
                            model.set('value', value) :
                            apiSettingsModel.get('method-limits-list').add({ name: name, value: value });

                        apiSettingsModel
                            .set('current-method-limit-value', value)
                            .trigger('finishEditing');
                    }, this);

                    subscriptionManager.on(this._resetButton, 'click', function() {
                        var name = apiSettingsModel.get('current-method-limit-name'),
                            model = this._getLimitList(name);

                        model && model.destruct();

                        apiSettingsModel
                            .set('current-method-limit-value', '')
                            .trigger('finishEditing');
                    }, this);

                    this.bindTo('method-limit-input', 'keypress', function() {
                        apiSettingsModel.trigger('startEditing');
                    });
                }
            }

            this._cityInput && subscriptionManager.wrap(this._cityInput)
                .on('change', function(e) {
                    this._generalSettingsModel.set('geo_id', undefined);
                    this.elem('geoId').val('');
                }, this)
                .on('select', function(e, data) {
                    this._generalSettingsModel.set('geo_id', data.item.params.id);
                    this.elem('geoId').val(data.item.params.id);
                }, this);

            this._canManagePricePackages && subscriptionManager.wrap(this._canManagePricePackages)
                .on('change', function(e, data) {
                    this.findBlockInside('canApprovePricePackages', 'checkbox')
                        .setMod('disabled', data.checked ? 'yes' : '');
                }, this);

            this._canApprovePricePackages && subscriptionManager.wrap(this._canApprovePricePackages)
                .on('change', function(e, data) {
                    this.findBlockInside('canManagePricePackages', 'checkbox')
                        .setMod('disabled', data.checked ? 'yes' : '');
                }, this);

            subscriptionManager.wrap(generalSettingsModel)
                .on('manager_use_crm', 'change', function(e, data) {
                    this.setMod(_this.elem('private-email'), 'show', data.value ? 'yes' : 'no');

                    BEM.DOM.update(
                        _this.elem('crm-alias'),
                        data.value ?
                            iget2('b-modify-user', 'crm-alias', 'CRM-алиас') :
                            iget2('b-modify-user', 'e-mail-outlook', 'E-mail (Outlook)'));

                }, this)
                .on('allowClientsWithoutWallet', 'change', function(e, data) {
                    data.value || generalSettingsModel.set('defaultClientsWithWallet', true);
                    this.findBlockInside('defaultWalletCheckbox', 'checkbox')
                        .setMod('disabled', data.value ? '' : 'yes');
                }, this);

            //todo: viewmodel?
            BEM.blocks['checkbox'].on(this.findElem('edit-campaign-right'), 'change', function(e) {
                var checked = e.target.isChecked(),
                    ctx = e.target.domElem.closest(this.buildSelector('additional-rights')),
                    xlsEditElem = this.findElem(ctx, 'xls-edit-right'),
                    xlsEditCheckbox = this.findBlockInside(xlsEditElem, 'checkbox');

                xlsEditCheckbox.setMod('disabled', checked ? '' : 'yes');

                if (!checked) {
                    xlsEditCheckbox.setMod('checked', '');
                }

                this.setMod(this.findElem(xlsEditElem, 'additional-right'), 'disabled', checked ? '' : 'yes');
            }, this);

            this._roles && this._roles.on('change', this._onRoleChange, this);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this.__base.apply(this, arguments);
    },

    /**
     * Возвращает инстанс модели m-method-limits-list, если передан name, либо список инстансов, если name не передан
     * @param {String} name
     * @returns {BEM.MODEL|BEM.MODEL[]}
     * @private
     */
    _getLimitList: function(name) {
        return name ?
            this._apiSettingsModel.get('method-limits-list').where({
                name: name
            }).pop() :
            this._apiSettingsModel.get('method-limits-list', 'raw');
    },

    /**
     * Формирует и устанавливает текстовое представление ограничений вызовов в соответствующий попап
     * @private
     */
    _formDescription: function() {
        var limitsList = this._limitsList;

        limitsList.empty();
        this._getLimitList().forEach(function(limit) {
            limitsList.append(BEMHTML.apply({
                tag: 'li',
                block: 'b-modify-user',
                elem: 'limits-list-item',
                mods: { method: limit.id },
                content: limit.get('name') + ': ' + limit.get('value')
            }));
        });
    },

    /**
     * Валидация форм перед отправкой
     * @returns {*}
     * @private
     */
    _bindValidation: function() {
        var params = this.params,
            apiForm = this.findBlockInside('api-settings', 'i-form'),
            generalForm = this.findBlockInside('general-settings', 'i-form');

        this._subscriptionManager.on(generalForm, 'submit', function() {
            this._validate(this._generalSettingsModel, {
                city: iget2('b-modify-user', 'vvedite-nazvanie-goroda', 'Введите название города'),
                geo_id: iget2('b-modify-user', 'nepravilno-vvedeno-nazvanie-goroda', 'Неправильно введено название города'),
                FIO: iget2('b-modify-user', 'vvedite-imya', 'Введите имя'),
                phone: iget2('b-modify-user', 'vvedite-telefon', 'Введите телефон'),
                email: iget2('b-modify-user', 'vvedite-korrektnyy-e-mail', 'Введите корректный e-mail')
            }, generalForm);
        }, this);

        apiForm && this._subscriptionManager.on(apiForm, 'submit', function(e) {
            if (params.permission.limitsEdit) {
                var methodLimits = this.findBlockInside('api-settings', 'i-glue').params.modelData.methods
                    .reduce(function(res, name) {
                        res[name] = '';

                        return res;
                    }, {});

                this._getLimitList().forEach(function(limit) {
                    methodLimits[limit.get('name')] = limit.get('value');
                });
                this.elem('json-limits-input').val(JSON.stringify(methodLimits));
            } else {
                this.elem('json-limits-input').val('{}');
            }

            return this._validate(this._apiSettingsModel, {
                'concurrent-calls': iget2('b-modify-user', 'kol-vo-odnovremennyh-vyzovov', 'Кол-во одновременных вызовов должно быть задано целым числом')
            }, apiForm);
        }, this);

        return this;
    },

    /**
     * Копирование параметров пользователя в поле "примечание"
     * @returns {BEM}
     * @private
     */
    _enableAddDescription: function() {
        this.params.permission.descEdit && this._subscriptionManager
            .on(this.findBlockOn('copy-user-data', 'link'), 'click', function() {
                var data = this.findBlockInside('general-settings', 'i-form').serialize(),
                    notes = data.description,
                    params = this.params;

                notes && (notes += '\n');

                notes += (params.login ? iget2('b-modify-user', 'login', 'Логин: ') + params.login + '\n' : '') +
                    (params.createTime ? iget2('b-modify-user', 'sozdan', 'Создан: ') + params.createTime + '\n' : '') +
                    iget2('b-modify-user', 'nazvanie', 'Название: ') + data.FIO + '\n' +
                    iget2('b-modify-user', 'telefon', 'Телефон: ') + data.phone + '\n' +
                    iget2('b-modify-user', 'e-mail', 'E-mail: ') + data.email;

                this.findBlockOn('descriptions', 'input').val(notes);
            }, this);

        return this;
    },

    /**
     * Установка фокуса на элемент
     * @param {String} elemName  имя элемента
     * @param {String} blockName имя блока - контрола
     * @private
     */
    _focusControl: function(elemName, blockName) {
        blockName = blockName || 'input';
        elemName = elemName.replace('_', '-'); //соответствие между названиями элементов и именами переменных
        if (elemName === 'geo-id') { //гео идентификатор - это город
            elemName = 'city';
        }
        this.findBlockOn(elemName, blockName).elem('control').focus();
    },

    /**
     * Обработка сабмитов
     * @param {BEM.MODEL} model модель, которую нужно валидировать
     * @param {Object} errors хэш сообщений об ошибках
     * @param {BEM} form блок формы
     * @private
     */
    _validate: function(model, errors, form) {
        var validationResult = model.validate(),
            errorMessages;

        if (validationResult.valid) {
            form.submit();
        } else {
            errorMessages = validationResult.errorFields.reduce(function(res, fieldName) {
                res.push(errors[fieldName]);
                return res;
            }, []);
            BEM.blocks['b-confirm'].open({
                message: errorMessages,
                type: 'alert',
                onYes: function() {
                    //если фокусировать сразу, то по нажатию enter опять произойдет сабмит в неверном поле и откроется алерт
                    this.afterCurrentEvent(function() {
                        this._focusControl(validationResult.errorFields[0]);
                    });
                }.bind(this)
            });

        }
    },

    _onRoleChange: function(e, data) {
        var isMainRepType = data.currentVal === 'main',
            checkboxes = this.findBlocksInside(this._permissionControls, 'checkbox');

        if (isMainRepType) {
            checkboxes.forEach(function(checkbox) {
                var isCheckedDefault = Number(checkbox.findElem('control').attr('value')) === 1;
                // Возввращаем дефолтные значения
                isCheckedDefault ?
                    checkbox.setMod('checked', 'yes') :
                    checkbox.delMod('checked');
                checkbox.setMod('disabled', 'yes');
            });
        } else {
            checkboxes.forEach(function(checkbox ) {
                checkbox.delMod('disabled');
            });
        }
    }
});
