u.register({

    'b-modify-user': {

        /**
         * Возвращает название CPM-кампании
         * @param {String} name — cpm_banner|cpm_deals|cpm_yndx_frontpage|cpm_price
         * @returns {String}
         */
        getNameCampaign: function(name) {
            var campaigns = {
                'cpm-banner': iget2('b-modify-user', 'cpm-banner', 'Медийная'),
                'cpm-deals': iget2('b-modify-user', 'cpm-deals', 'Сделки'),
                'cpm-yndx-frontpage': iget2('b-modify-user', 'cpm-yndx-frontpage', 'Медийный продукт на главной'),
                'cpm-price': iget2('b-modify-user', 'cpm-price', 'Прайсовые продажи главной')
            };

            return campaigns[u.beminize(name)] || name;

        },

        /**
         * Возвращает название типа критерия
         * @param {String} name — none|private|public|yandex
         * @returns {String}
         */
        getNameCriterion: function(name) {
            var criterion = {
                none: '&mdash;',
                private: iget2('b-modify-user', 'criterion-private', 'Приватные'),
                public: iget2('b-modify-user', 'criterion-public', 'Не приватные'),
                yandex: iget2('b-modify-user', 'criterion-yandex', 'На нашем инвентаре')
            };

            return criterion[u.beminize(name)] || name;

        }
    }

});
