// Код ждет данных от сервера!
// На текущий момент тут реализована логика построения фейковых данных!
block('b-mol-stat-data').elem('columns-content').def()(function() {
    var data = this.data,
        fieldName = this.ctx.field,
        rowData = this.ctx.data,
        isTotal = this.ctx.isTotal && !this.isCompare,
        isTotalDecorationNeeded = isTotal && !!~[
            'video_avg_true_view_cost'
        ].indexOf(fieldName),
        rawValue = rowData[fieldName],
        getFormattedValue = function(value, field, suffix) {
            // Если нам пришло число или строка с числом 0/'0' то мы обрабатываем значение
            // Иначе нужно его игнорировать
            if ((typeof value === 'string' && value.length) || (typeof value === 'number' && !isNaN(value))) {
                if (isNotEnoughShow(field)) {
                    return getNotEnoughShowsHint();
                }

                var precision = 0;

                if (typeof value === 'string' && !!~value.indexOf('.')) {
                    precision = value.substring(value.indexOf('.') + 1).length;
                }

                value = u.numberFormatter.format(value, {
                    exponentDelimiter: '&nbsp;',
                    // считаем символы после точки
                    precision: precision,
                    // DIRECT-54925: 11981: плюсы должны присутствовать в положительных Разницах
                    showPositiveSign: suffix === 'delta' || suffix === 'absdelta'
                });
            } else if (!value) {
                value = '&ndash;';
            }

            return isTotalDecorationNeeded ? getDecoratedValue(value) : value;
        },
        isNotEnoughShow = function(field) {
            var minShowsByType = {
                auction_win_rate: 1000
            };

            var minShows = minShowsByType[field];
            var shows = rowData.shows;

            return minShows && typeof shows === 'number' && !isNaN(shows) ?
                shows < minShows :
                false;
        },
        getNotEnoughShowsHint = function() {
            return {
                elem: 'too-few-data',
                content: {
                    block: 'b-icon-hint',
                    js: true,
                    to: ['top', 'bottom'],
                    icon: { 'size-12': 'info-yellow' },
                    content: iget2('b-mol-stat-data', 'too-few-data', 'Недостаточно показов для корректного расчета показателя')
                }
            };
        },
        getDeltaModifier = function(field, rawVal) {
            // eslint-disable-next-line max-len
            var declineGrowth = /^(sum|av_sum|pv_agoalcost|agoalcost|pv_bounce_ratio|bounce_ratio|fp_shows_avg_pos|fp_clicks_avg_pos|avg_bid)$/,
                formattedValue = u.numberFormatter.round(rawVal);

            if (formattedValue === 0 || isNaN(formattedValue)) {
                return '';
            }

            return declineGrowth.test(field) ?
                (formattedValue > 0 ? 'decline' : 'growth') :
                (formattedValue > 0 ? 'growth' : 'decline');
        },
        getDecoratedValue = function(value) {
            var decorated = value;

            if (fieldName === 'video_avg_true_view_cost') {
                var avgCpv = u._.get(data, 'campaign.strategy2.options.net.avg_cpv', 0);

                if (
                    (avgCpv > 0) && (
                        rawValue > avgCpv ||
                        ((avgCpv - rawValue) > (avgCpv * 0.2)) // заданная ставка меньше текущей больше чем на 20%
                    )
                ) {
                    decorated = [
                        {
                            elem: 'cpv-learn',
                            content: {
                                block: 'b-icon-hint',
                                mix: [{ block: 'cpv-learn', elem: 'icon' }],
                                js: true,
                                to: ['top', 'bottom'],
                                icon: { 'size-12': 'info-yellow' },
                                content: iget2('b-mol-stat-data', 'cpv-alert', 'Стратегия обучается — подбирает оптимальные ставки.')
                            }
                        },
                        value
                    ];
                }
            }

            return decorated;
        }

    if (this.isCompare) {
        return ['delta', 'absdelta', 'a', 'b'].map(function(suffix, i) {
            var valName = fieldName + '_' + suffix,
                elemMods = {},
                rawValue = rowData[valName],
                value = getFormattedValue(rawValue, fieldName, suffix);

            if (suffix === 'b') {
                elemMods = {
                    type: 'second-period'
                };
            } else if (rawValue && (suffix === 'delta' || suffix === 'absdelta')) {
                elemMods = {
                    type: getDeltaModifier(fieldName, rawValue)
                };
            }

            return {
                content: {
                    elem: 'comparison-result',
                    elemMods: elemMods,
                    content: value
                },
                mods: {
                    separate: i === 0 ? 'left' : undefined
                }
            };
        }, this);
    } else {
        return {
            content: {
                elem: 'comparison-result',
                content: getFormattedValue(rawValue, fieldName)
            },
            mods: {
                separate: this.ctx.isFirst ? 'left' : undefined
            }
        };
    }
});
