block('b-mol-stat-data').elem('detailed-table').def()(function() {
    var isGoalsColumnsMultiplied = this.isGoalsColumnsMultiplied,
        goals = this.data.goal_ids || [],
        isGoalsField = this.isGoalsField;

    return {
        rows: this.dataArray.map(function(rowData) {
            var cols = [],
                rowMix,
                rowElemMods,
                rowModelIndex = this.statDataModel ? this.statDataModel['detailed-rows'].length : -1,
                rowModelId = 'detailed-row-' + rowModelIndex;

            if (rowModelIndex !== -1) {
                // модификатор используется для поиска DOM-ноды в таблице
                rowElemMods = {
                    'detailed-row-id': rowModelId
                };
                rowMix = [{
                    block: 'i-glue',
                    js: {
                        modelName: 'm-mol-stat-data-row',
                        modelId: rowModelId
                    }
                }];

                // Кладет заготовку под данные. Заполняется внутри ячейк.
                this.statDataModel['detailed-rows'].push({
                    modelId: rowModelId
                });
            }

            // Срезы это текстовые данные, различные фразы или данные кампании.
            // Их обрабатываем через slices-content
            this.slicesFields.forEach(function(field, i, arr) {
                cols.push({
                    content: {
                        block: 'b-mol-stat-data',
                        elem: 'slices-content',
                        elemMods: { type: u.beminize(field) },
                        data: rowData,
                        field: field,
                        // rowModelIndex прокидывается в каждую ячейку строки
                        // используется для нахождения объекта строки в this.statDataModel['detailed-rows']
                        rowModelIndex: rowModelIndex
                    },
                    elemMods: {
                        type: 'slices',
                        'last-of-slices': (arr.length - 1) === i ? 'yes' : undefined,
                        'content-type': u.beminize(field)
                    }
                });
            });

            // Столбцы это числовые данные, для них шаблон columns-content
            this.columnsFields
                .reduce(function(result, field) {
                    return result.concat(
                        isGoalsColumnsMultiplied && isGoalsField(field) ?
                            goals.map(function(goalId) { return field + '_' + goalId }) :
                            field
                    )
                }, [])
                .forEach(function(field, i) {
                    cols.push(applyCtx({
                        block: 'b-mol-stat-data',
                        elem: 'columns-content',
                        data: rowData,
                        field: field,
                        isFirst: i === 0
                    }));
                }, this);

            return {
                cols: u._.flatten(cols),
                elemMods: rowElemMods,
                mix: rowMix
            };
        }, this)
    };
});
