block('b-mol-stat-data').elem('fraud').content()(function() {
    var content = [],
        fraudClicks = this.ctx.fraudClicks,
        fraudGiftClicks = this.ctx.fraudGiftClicks;

    if (fraudClicks) {
        if (hasLoginRights('super_control', 'superreader_control', 'support_control', 'limited_support_control')) {
            content.push(
                iget2(
                    'b-campaign-stat-data',
                    'nedeystvitelnye-kliki-fraudclicks-0',
                    'Недействительные клики: {fraudClicks}, из них подарено: {fraudGiftClicks}',
                    {
                        fraudClicks: fraudClicks,
                        fraudGiftClicks: fraudGiftClicks,
                        context: 'fraudClicks - 0; fraudGiftClicks - 0'
                    }
                )
            );
        } else {
            content.push(
                iget2('b-campaign-stat-data', 'nedeystvitelnye-kliki-fraudclicks-0-113', 'Недействительные клики: {fraudClicks}', {
                    fraudClicks: fraudClicks,
                    context: 'fraudClicks - 0'
                })
            );
        }

        content.push({
            block: 'b-help-link',
            mods: {
                type: 'modal'
            },
            width: 1110,
            url: u.getHelpUrl('antifraud-clicks')
        });
    }

    return content;
});
