block('b-mol-stat-data').elem('header-cell').def()(function() {

    var data = this.data,
        cellData = this.ctx.cellData || [],
        form = data.FORM,
        cellOptions = this.ctx.cellOptions,
        column = cellOptions.column,
        sorting = cellOptions.sorting || {},
        cell;

    // Если есть id - необходимо построить ссылку для сортировки
    if (column.id) {
        cell = u.table.getSortHeaderLink({
            col: column.id,
            caption: column.title,
            defCol: sorting.defaultColumn,
            downArrow: '&#9660;',
            upArrow: '&#9650;',
            broadcast: true,
            options: {
                defaultReverse: sorting.defaultReverse,
                classes: cellOptions.classes || '',
                metrikaGoal: cellOptions.metrikaGoalName
            }
        }, form);
    } else {
        cell = column.title;
    }

    column.help && (cell = [
        cell,
        '&nbsp',
        {
            block: 'b-help-link',
            mods: { type: 'modal' },
            stretched: true,
            url: column.help
        }
    ]);

    cellData.push(cell);

    return {
        content: cellData,
        elemMods: cellOptions.mods,
        attrs: u._.pick(cellOptions, ['rowspan', 'colspan'])
    };
});
