block('b-mol-stat-data').elem('slices-content').elemMod('type', 'contextcond-orig').def()(function() {
    var ctx = this.ctx,
        rowData = ctx.data,
        rowDataContextType = rowData.ContextType,
        uContextType = u.statisticsContextType;

    // ContextType - типы фраз в статистике из БК
    // CONTEXT_TYPE_PHRASE = 1;          # фразы
    // CONTEXT_TYPE_RET = 2;             # условие ретаргетинга (Условие подбора аудитории)
    // CONTEXT_TYPE_BROADMATCH = 3;      # броадматч
    // CONTEXT_TYPE_AD_SHARD = 4;        # рекламный шард поиска
    // CONTEXT_TYPE_SYNONYM = 5;         # расширенный синонимами поисковый запрос
    // CONTEXT_TYPE_INTENTS = 6;         # интенты
    // CONTEXT_TYPE_DYNAMIC = 7;         # условия нацеливания
    // CONTEXT_TYPE_PERFORMANCE = 8;     # фильтры перформанса
    // CONTEXT_TYPE_BM_SYNONYM = 10;     # автоматически добавленные фразы-синонимы («виртуальный» тип, для использования в МОЛ)
    // CONTEXT_TYPE_RELEVANCE_MATCH = 11 # автотаргетинг
    //                                 в поисковых запросах кажется такого быть не должно
    //
    // 3-6 - чистый ДРФ, отдается как 3
    if (rowDataContextType === uContextType.dynamic) {
        var condition = this.data.used_dynamic_conditions[rowData.PhraseID] || {};

        return applyCtx({
            block: 'b-statistics-dynamic-condition',
            name: condition.name,
            condition: condition.condition
        });
    } else if (rowDataContextType === uContextType.performance || rowDataContextType === uContextType.ret) {

        return rowData.phrase;
    } else if (rowDataContextType === uContextType.relevance_match) {

        return '---autotargeting';
    } else {
        var ctxData = this.ctx.data,
            // содержит id кампаний на которые у пользователя есть права на редактирование
            allowEditCamps = this.data.allow_edit_camps,
            adgroupType = ctxData.adgroup_type,
            bannersCount = +ctxData.adgroup_banners_count,
            archivedBannersCount = +ctxData.adgroup_archived_banners_count,
            isArchivedCamp = this.archivedCamps[ctxData.cid],
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // hasExtPhraseStatusSlice = this.slicesFields.indexOf('ext_phrase_status') !== -1,
            statType = this.data.statType,
            rowModelData = this.ctx.rowModelIndex === -1 ?
                undefined :
                this.statDataModel['detailed-rows'][this.ctx.rowModelIndex];

        if (allowEditCamps[ctxData.cid] &&
            (adgroupType === 'base' || adgroupType === 'mobile_content') &&
            (rowData.ContextType === uContextType.phrase || rowData.ContextType === uContextType.drf ||
                rowData.ContextType === uContextType.bm_synonym) &&
                    !(rowData.ContextType === u.statisticsContextType.drf && 1 === +rowData.PhraseID) && // DIRECT-59600 это баг БК(его правят), отсеиваем на клиенте
                        !isArchivedCamp && bannersCount !== archivedBannersCount && // Группа в интерфейсе считается архивной, если все баннеры - архивны
                            // hasExtPhraseStatusSlice && // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
                            statType === 'ext_phrases' && rowModelData) {

            rowModelData = this.statDataModel['detailed-rows'][this.ctx.rowModelIndex];
            rowModelData.phrase = rowData.phrase;
            // нормальна форма участвует в построении индекса, по которому происходит изменения статуса фразы в m-mol-stat-data
            rowModelData.norm_ext_phrase = rowData.norm_ext_phrase;

            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            //
            // запрещает повторно добавить фраза в одну и туже группу
            // if (rowData.ext_phrase_status === 'added') {
            //     rowModelData['ext_phrase_status'] = 'added';
            // } else {
            return {
                block: 'checkbox',
                mix: [{
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        type: 'checkbox',
                        name: 'contextcond_ext_checkbox'
                    }
                }],
                text: {
                    content: applyCtx({
                        block: 'b-statistic-phrase-minus-words',
                        phrase: rowData.phrase,
                        limit: 0
                    })
                }

            };
            //}
        }

        return applyCtx({
            block: 'b-statistic-phrase-minus-words',
            phrase: rowData.phrase,
            limit: 0
        });
    }
});
