block('b-mol-stat-data').elem('slices-content').elemMod('type', 'date')(

    def()(function() {
        var data = this.ctx.data,
            date = data.date;

        if (this.data.group_by_date == 'none') {
            date = u.moment(this.data.date_from).format('DD.MM.YY') +
                ' – ' + u.moment(this.data.date_to).format('DD.MM.YY');
        }

        return date;
    }),

    match(function() {
        return this.isCompare;
    }).def()(function() {
        var dateA = this.ctx.data.date_a,
            dateB = this.ctx.data.date_b;

        if (this.data.group_by_date == 'none') {
            dateA = u.moment(this.data.date_from).format('DD.MM.YY') +
                ' – ' + u.moment(this.data.date_to).format('DD.MM.YY');

            dateB = u.moment(this.data.date_from_b).format('DD.MM.YY') +
                ' – ' + u.moment(this.data.date_to_b).format('DD.MM.YY');
        }

        return [
            {
                elem: 'first-period',
                content: iget2('b-mol-stat-data', 'a-period-period', 'A: {period}', {
                    period: dateA,
                    context: 'period - период'
                })
            },
            {
                elem: 'second-period',
                content: iget2('b-mol-stat-data', 'b-period-period', 'B: {period}', {
                    period: dateB,
                    context: 'period - период'
                })
            }
        ];
    })
);
