block('b-mol-stat-data').elem('slices-content').elemMod('type', 'search-query')(

    def()(function() {
        return {
            block: 'b-mol-stat-data',
            elem: 'search-query-wrap',
            content: this.ctx.data[this.ctx.field]
        };
    }),

    def()(function() {
        var ctxData = this.ctx.data,
            // содержит id кампаний на которые у пользователя есть права на редактирование
            allowEditCamps = this.data.allow_edit_camps,
            adgroupType = ctxData.adgroup_type,
            isArchivedCamp = this.archivedCamps[ctxData.cid],
            bannersCount = +ctxData.adgroup_banners_count,
            archivedBannersCount = +ctxData.adgroup_archived_banners_count,
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // slicesFields = this.slicesFields || [],
            // hasSearchQueryStatusSlice = slicesFields.indexOf('search_query_status') !== -1,

            // разрешает работать с фразой ДО в отчете по одной кампании
            canEditDynamic = adgroupType === 'dynamic' && this.data.isSingleCamp,
            isLimitedSupport = this.data.login_rights.limited_support_control,
            rowModelData = this.ctx.rowModelIndex === -1 ?
                undefined :
                this.statDataModel['detailed-rows'][this.ctx.rowModelIndex];

        if (!(allowEditCamps[ctxData.cid] || isLimitedSupport) ||
                (adgroupType !== 'base' && adgroupType !== 'mobile_content' && adgroupType !== 'performance' && !canEditDynamic) ||
                    // группа в интерфейсе считается архивной, если все баннеры - архивны
                    isArchivedCamp || bannersCount === archivedBannersCount ||
                        // !hasSearchQueryStatusSlice || // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
                            !rowModelData) {

            return applyNext();
        }

        rowModelData['search_query'] = ctxData[this.ctx.field];
        // нормальна форма участвует в построении индекса, по которому происходит изменения статуса фразы в m-mol-stat-data
        rowModelData['norm_search_query'] = ctxData.norm_search_query;
        rowModelData['phrase_id'] = ctxData.PhraseID;
        rowModelData['report_row_hash'] = ctxData.report_row_hash;

        // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
        //
        // запрещает повторно добавить фраза в одну и туже группу
        // if (ctxData.search_query_status === 'added') {
        //     rowModelData['search_query_status'] = 'added';
        //
        //     return applyNext();
        // }

        return {
            block: 'checkbox',
            mix: [{
                block: 'i-glue',
                elem: 'model-field',
                js: {
                    type: 'checkbox',
                    name: 'search_query_checkbox'
                }
            }],
            text: {
                content: {
                    block: 'b-mol-stat-data',
                    elem: 'search-query-wrap',
                    content: ctxData[this.ctx.field]
                }
            }
        };
    }),

    match(function() {
        return !this.ctx.data[this.ctx.field];
    }).def()({
        block: 'b-stat-table',
        elem: 'empty',
        content: '&ndash;'
    })
);
