block('b-mol-stat-data').elem('table-head').def()(function() {
    var data = this.data,
        currency = ', ' + u.currencies.getName(this.ctx.currency || this.data.client_currency),
        attributionModel = this.data.FORM.attribution_model || this.data.attribution_model,
        isPostViewAvailable = hasEnabledFeatures('post_view_statistics'),
        needPlacePrefix = isPostViewAvailable && attributionModel === 'last_yandex_direct_view_cross_device',
        isARP = this.data.statType === 'ext_phrases', // Additional relevant phrase
        campType = this.data.campaign && this.data.campaign.mediaType,
        useBanner = campType === 'mcbanner',
        placePostClick = u.placePostClick,
        placePostView = u.placePostView,
        helpLinks = {
            eshows: u.getHelpUrl('report-wizard-weighted-impressions'),
            aprgoodmultigoal: u.getHelpUrl('report-wizard-engagement-rating'),
            aprgoodmultigoal_cpa: u.getHelpUrl('report-wizard-engagement-rating'),
            aprgoodmultigoal_conv_rate: u.getHelpUrl('report-wizard-engagement-rating'),
            agoals_profit: u.getHelpUrl('report-wizard-profit'),
            auction_wins: u.getHelpUrl('report-wizard-renderings'),
            auction_win_rate: u.getHelpUrl('report-wizard-renderings-rate'),
            served_impressions: u.getHelpUrl('cpm-campaign-outdoor-served-impressions'),
            auction_hits: u.getHelpUrl('report-wizard-auction-hits'),
            imp_reach_rate: u.getHelpUrl('report-wizard-share-of-voice'),
            uniq_completed_viewers: u.getHelpUrl('completed-reach'),

            viewable_impressions_mrc: u.getHelpUrl('mrc-viewable-impressions'),
            nonviewable_impressions_mrc: u.getHelpUrl('mrc-nonviewable-impressions'),
            undetermined_impressions_mrc: u.getHelpUrl('mrc-undetermined-impressions'),
            measured_rate_mrc: u.getHelpUrl('mrc-measured-rate'),
            viewable_rate_mrc: u.getHelpUrl('mrc-viewable-rate'),

            content_targeting: u.getHelpUrl('report-wizard-category-targeting'),
            uniq_viewers: u.consts('rights').enableCpmStatistics ? u.getHelpUrl('unique-user') : undefined,
            agoalincome: u.getHelpUrl('report-wizard-revenue')
        },
        commonFields = {
            camp_name: iget2('b-mol-stat-data', 'kampaniya', 'Кампания'),
            campaign: iget2('b-mol-stat-data', 'no-kampanii', '№ кампании'),
            period: +this.data.FORM.single_camp ? iget2('b-mol-stat-data', 'vsego-na-kampaniyu', 'Всего на кампанию') : iget2('b-mol-stat-data', 'vsego-po-akkauntu', 'Всего по аккаунту'),
            tags: iget2('b-mol-stat-data', 'metka', 'Метка'),
            adgroup_name: iget2('b-mol-stat-data', 'gruppa', 'Группа'),
            adgroup: iget2('b-mol-stat-data', 'no-gruppy', '№ группы'),
            banner: useBanner ? iget2('b-mol-stat-data', 'no-bannera', '№ баннера') : iget2('b-mol-stat-data', 'no-obyavleniya', '№ объявления'),
            banner_type: useBanner ? iget2('b-mol-stat-data', 'tip-bannera', 'Тип баннера') : iget2('b-mol-stat-data', 'tip-obyavleniya', 'Тип объявления'),
            targettype: iget2('b-mol-stat-data', 'tip-ploshchadki', 'Тип площадки'),
            page_group: iget2('b-mol-stat-data', 'nazvanie-ploshchadki', 'Название площадки'),
            page: iget2('b-mol-stat-data', 'nazvanie-ploshchadki-podrobno', 'Название площадки (подробно)'),
            ssp: iget2('b-mol-stat-data', 'vneshnie-seti', 'Внешние сети'),
            position: iget2('b-mol-stat-data', 'placement-type', 'Вид размещения'),
            has_image: iget2('b-mol-stat-data', 'izobrazhenie', 'Изображение'),
            banner_image_type: iget2('b-mol-stat-data', 'formaty', 'Форматы'),
            image_size: iget2('b-mol-stat-data', 'razmer-izobrazheniya', 'Размер изображения'),
            turbo_page_type: iget2('b-mol-stat-data', 'turbo_page_type-2', 'Турбо-версия площадки'),
            device_type: iget2('b-mol-stat-data', 'tip-ustroystva', 'Тип устройства'),
            detailed_device_type: iget2('b-mol-stat-data', 'tip-operacionnoy-sistemy', 'Тип операционной системы'),
            connection_type: iget2('b-mol-stat-data', 'tip-svyazi', 'Тип связи'),
            gender: iget2('b-mol-stat-data', 'pol', 'Пол'),
            targeting_category: iget2('b-mol-stat-data', 'semantic-correspondence-type', 'Категория таргетинга'),
            prisma_income_grade: iget2('b-mol-stat-data', 'prisma-income-grade', 'Уровень платежеспособности'),
            age: iget2('b-mol-stat-data', 'vozrast', 'Возраст'),
            client_id: iget2('b-mol-stat-data', 'client-id', 'Идентификатор клиента'),
            place_id: iget2('b-mol-stat-data', 'place-id', 'Номер плейса'),
            internal_product_name: iget2('b-mol-stat-data', 'internal-product-name', 'Название продукта'),
            place_description: iget2('b-mol-stat-data', 'place-description', 'Описание плейса'),
            operating_system: iget2('b-mol-stat-data', 'operating-system', 'Операционная система'),
            browser: iget2('b-mol-stat-data', 'browser', 'Браузер'),
            page_id: iget2('b-mol-stat-data', 'page-id', 'Номер пейджа'),
            client_login: iget2('b-mol-stat-data', 'client-login', 'Аккаунт'),
            close_clicks: iget2('b-mol-stat-data', 'close-clicks', 'Клики закрытия'),
            close_ctr: iget2('b-mol-stat-data', 'close-ctr', 'CTR закрытия'),
            click_place: iget2('b-mol-stat-data', 'mesto-klika', 'Место клика'),
            contextcond: iget2('b-mol-stat-data', 'uslovie-pokaza', 'Условие показа'),
            bs_criterion_id: iget2('b-mol-stat-data', 'nomer_usloviya-pokaza', '№ Условия показа'),
            campaign_type: iget2('b-mol-stat-data', 'tip-kampanii', 'Тип кампании'),
            region: iget2('b-mol-stat-data', 'region-targetinga', 'Регион таргетинга'),
            physical_region: iget2('b-mol-stat-data', 'region-mestonahozhdeniya', 'Регион местонахождения'),
            region_source: iget2('b-mol-stat-data', 'region-type', 'Тип соответствия региона'),
            date: iget2('b-mol-stat-data', 'data', 'Дата'),
            shows: iget2('b-mol-stat-data', 'pokazy', 'Показы'),
            avg_nshow: iget2('b-mol-stat-data', 'avg-nshow', 'Заметность показов (%)'),
            eshows: iget2('b-mol-stat-data', 'eshows', 'Взвешенные показы'),
            clicks: iget2('b-mol-stat-data', 'kliki', 'Клики'),
            ctr: iget2('b-mol-stat-data', 'ctr', 'CTR (%)'),
            ectr: iget2('b-mol-stat-data', 'wctr', 'wCTR (%)'),
            sum: iget2('b-mol-stat-data', 'rashod-vsego', 'Расход всего') + currency,
            av_sum: iget2('b-mol-stat-data', 'sr-cena-klika', 'Ср. цена клика') + currency,
            fp_clicks_avg_pos: iget2('b-mol-stat-data', 'sr-poziciya-klika', 'Ср. позиция клика'),
            fp_shows_avg_pos: iget2('b-mol-stat-data', 'sr-poziciya-pokaza', 'Ср. позиция показа'),
            avg_x: iget2('b-mol-stat-data', 'avg_x', 'Ср. объём трафика'),
            winrate: iget2('b-mol-stat-data', 'procent-poluchennyh-pokazov', 'Процент полученных показов (%)'),
            bounce_ratio: placePostClick(iget2('b-mol-stat-data', 'otkazy', 'Отказы (%)'), needPlacePrefix),
            pv_bounce_ratio: placePostView(iget2('b-mol-stat-data', 'otkazy', 'Отказы (%)')),
            aconv: placePostClick(iget2('b-mol-stat-data', 'konversiya', 'Конверсия (%)'), needPlacePrefix),
            pv_aconv: placePostView(iget2('b-mol-stat-data', 'konversiya', 'Конверсия (%)')),
            agoalcost: placePostClick(iget2('b-mol-stat-data', 'cena-nbsp-celi', 'Цена&nbsp;цели') + currency, needPlacePrefix),
            pv_agoalcost: placePostView(iget2('b-mol-stat-data', 'cena-nbsp-celi', 'Цена&nbsp;цели') + currency),
            agoalnum: placePostClick(iget2('b-mol-stat-data', 'konversii', 'Конверсии'), needPlacePrefix),
            pv_agoalnum: placePostView(iget2('b-mol-stat-data', 'konversii', 'Конверсии')),
            all_agoalnum: iget2('b-mol-stat-data', 'all-konversii', 'Всего конверсий'),
            agoalroi: placePostClick(iget2('b-mol-stat-data', 'rentabelnost', 'Рентабельность'), needPlacePrefix),
            pv_agoalroi: placePostView(iget2('b-mol-stat-data', 'rentabelnost', 'Рентабельность')),
            agoalcrr: placePostClick(iget2('b-mol-stat-data', 'crr', 'Доля рекламных расходов (%)')),
            pv_agoalcrr: placePostView(iget2('b-mol-stat-data', 'crr', 'Доля рекламных расходов (%)')),
            agoalincome: placePostClick(iget2('b-mol-stat-data', 'dohod', 'Доход') + currency, needPlacePrefix),
            pv_agoalincome: placePostView(iget2('b-mol-stat-data', 'dohod', 'Доход') + currency),
            agoals_profit: placePostClick(iget2('b-mol-stat-data', 'profit', 'Прибыль') + currency, needPlacePrefix),
            pv_agoals_profit: placePostView(iget2('b-mol-stat-data', 'profit', 'Прибыль') + currency),
            search_query: iget2('b-mol-stat-data', 'poiskovyy-zapros', 'Поисковый запрос'),
            search_query_status: iget2('b-mol-stat-data', 'status-zaprosa', 'Статус запроса'),
            contexttype: iget2('b-mol-stat-data', 'tip-usloviya-pokaza', 'Тип условия показа'),
            contextcond_ext: isARP ? iget2('b-mol-stat-data', 'dopolnitelnaya-fraza', 'Дополнительная фраза') : iget2('b-mol-stat-data', 'uslovie-pokaza', 'Условие показа'),
            ext_phrase_status: isARP ? iget2('b-mol-stat-data', 'status-frazy', 'Статус фразы') : iget2('b-mol-stat-data', 'status-usloviya', 'Статус условия'),
            retargeting_coef: iget2('b-mol-stat-data', 'uslovie-podbora-korrektirovki', 'Условие подбора (корректировки)'),
            strategy_id: iget2('b-mol-stat-data', 'strategy-id', 'Стратегия'),
            bm_type: iget2('b-mol-stat-data', 'tip-dopolnitelnoy-frazy', 'Тип дополнительной фразы'),
            sim_distance: iget2('b-mol-stat-data', 'no-algoritma-podbora', '№ алгоритма подбора'),
            adepth: placePostClick(iget2('b-mol-stat-data', 'glubina-str', 'Глубина (стр.)'), needPlacePrefix),
            pv_adepth: placePostView(iget2('b-mol-stat-data', 'glubina-str', 'Глубина (стр.)')),
            contextcond_orig: iget2('b-mol-stat-data', 'uslovie-pokaza', 'Условие показа'),
            contexttype_orig: iget2('b-mol-stat-data', 'tip-usloviya-pokaza', 'Тип условия показа'),
            content_targeting: iget2('b-mol-stat-data', 'content-targeting', 'Жанры и тематики'),
            criterion_type: iget2('b-mol-stat-data', 'tip-usloviya-pokaza', 'Тип условия показа'),
            matched_phrase: iget2('b-mol-stat-data', 'podobrannaya-fraza', 'Подобранная фраза'),
            match_type: iget2('b-mol-stat-data', 'tip-sootvetstviya', 'Тип соответствия'),
            avg_cpm: iget2('b-mol-stat-data', 'sr-cena-tys-pokazov', 'Ср. цена тыс. показов') + currency,
            cpm_winrate: iget2('b-mol-stat-data', 'dolya-vyigryshey-po-pokazam', 'Доля выигрышей по показам (%)'),
            uniq_viewers: iget2('b-mol-stat-data', 'ohvat', 'Охват'),
            uniq_users_winrate: iget2('b-mol-stat-data', 'vykuplennyh-unikalnyh-polzovateley', '% выкупленных уникальных пользователей'),
            avg_view_freq: iget2('b-mol-stat-data', 'sr-chastota-pokazov', 'Ср. частота показов'),
            deal: iget2('b-mol-stat-data', 'nomer-sdelki', '№ сделки'),
            deal_name: iget2('b-mol-stat-data', 'nazvania-sdelki', 'Сделка'),
            aprgoodmultigoal: placePostClick(iget2('b-mol-stat-data', 'uroven-vovlechennosti', 'Уровень вовлеченности'), needPlacePrefix),
            pv_aprgoodmultigoal: placePostView(iget2('b-mol-stat-data', 'uroven-vovlechennosti', 'Уровень вовлеченности')),
            aprgoodmultigoal_cpa: placePostClick(iget2('b-mol-stat-data', 'tsena-vovlechenia', 'Цена вовлечения') + currency, needPlacePrefix),
            pv_aprgoodmultigoal_cpa: placePostView(iget2('b-mol-stat-data', 'tsena-vovlechenia', 'Цена вовлечения') + currency),
            aprgoodmultigoal_conv_rate: placePostClick(iget2('b-mol-stat-data', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)'), needPlacePrefix),
            pv_aprgoodmultigoal_conv_rate: placePostView(iget2('b-mol-stat-data', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)')),
            ab_segment: iget2('b-mol-stat-data', 'ab-segment', 'Сегмент'),
            avg_time_to_conv: placePostClick(iget2('b-mol-stat-data', 'avg-time-to-conv', 'Ср. время до конверсии, час.'), needPlacePrefix),
            pv_avg_time_to_conv: placePostView(iget2('b-mol-stat-data', 'avg-time-to-conv', 'Ср. время до конверсии, час.')),
            avg_bid: iget2('b-mol-stat-data', 'srednia-stavka-za-klik', 'Ср. ставка за клик') + currency,
            auction_wins: iget2('b-mol-stat-data', 'auction-wins2', 'Выигрыши в аукционах'),
            auction_hits: iget2('b-mol-stat-data', 'auction_hits', 'Участие в аукционах'),
            auction_win_rate: iget2('b-mol-stat-data', 'auction-win-rate2', 'Доля выигрышей (%)'),
            imp_reach_rate: iget2('b-mol-stat-data', 'imp-reach-rate', 'SOV (%)'),
            served_impressions: iget2('b-mol-stat-data', 'served_impressions', 'Выходы'),
            uniq_completed_viewers: iget2('b-mol-stat-data', 'uniq-completed-viewers', 'Достроенный охват'),
            cpcv: iget2('b-mol-stat-data', 'cpcc-completed-view', 'Ср. цена досмотра 100% ролика') + currency,
            video_mute: iget2('b-mol-stat-data', 'video-mute', 'Клики выключить звук'),
            video_unmute: iget2('b-mol-stat-data', 'video-unmute', 'Клики включить звук'),
            video_first_quartile: iget2('b-mol-stat-data', 'clip-first-quartile', 'Проигрывание 25% ролика'),
            video_first_quartile_rate: iget2('b-mol-stat-data', 'clip-first-quartile-rate', 'Доля проигрываний 25% ролика'),
            video_midpoint: iget2('b-mol-stat-data', 'clip-midpoint', 'Проигрывание 50% ролика'),
            video_midpoint_rate: iget2('b-mol-stat-data', 'clip-midpoint-rate', 'Доля проигрываний 50% ролика'),
            video_third_quartile: iget2('b-mol-stat-data', 'clip-third-quartile', 'Проигрывание 75% ролика'),
            video_third_quartile_rate: iget2('b-mol-stat-data', 'clip-third-quartile-rate', 'Доля проигрываний 75% ролика'),
            video_complete: iget2('b-mol-stat-data', 'clip-complete', 'Проигрывание 100% ролика'),
            video_complete_rate: iget2('b-mol-stat-data', 'clip-complete-rate', 'Доля проигрываний 100% ролика'),
            avg_nshow_complete: iget2('b-mol-stat-data', 'avg-nshow-complete', 'Заметность досмотров (%)'),
            video_true_view: iget2('b-mol-stat-data', 'clip-true-view', 'Просмотры'),
            video_true_view_rate: iget2('b-mol-stat-data', 'clip-true-view-rate', 'Доля просмотров (%)'),
            video_avg_true_view_cost: iget2('b-mol-stat-data', 'clip-avg-true-view-cost', 'Ср. цена просмотра ролика') + currency,
            inventory_type: iget2('b-mol-stat-data', 'inventory-type', 'Тип инвентаря'),
            ad_site_clicks: campType === 'cpm_price' ?
                iget2('b-mol-stat-data', 'ad-site-clicks-cpm_price', 'Открытие раскрывающегося блока') :
                iget2('b-mol-stat-data', 'ad-site-clicks-cpm_banner', 'Показ пэкшота'),
            viewable_impressions_mrc: iget2('b-mol-stat-data', 'viewable-impressions-mrc', 'Видимые показы, стандарт MRC'),
            nonviewable_impressions_mrc: iget2('b-mol-stat-data', 'nonviewable-impressions-mrc', 'Невидимые показы, стандарт MRC'),
            undetermined_impressions_mrc: iget2('b-mol-stat-data', 'undetermined-impressions-mrc', 'Неустановленные показы, стандарт MRC'),
            measured_rate_mrc: iget2('b-mol-stat-data', 'measured-rate-mrc', 'Доля измеряемых показов, стандарт MRC (%)'),
            viewable_rate_mrc: iget2('b-mol-stat-data', 'viewable-rate-mrc', 'Доля видимых показов, стандарт MRC (%)')
        },
        needDisableSortLinkFields = [
            'contextcond_orig', // DIRECT-101006
            'search_query' // DIRECT-101006
        ],
        firstColumn = this.slicesFields[0] || this.columnsFields[0],
        headerCells = [],
        subHeadCells = [],
        subHeadsGoalsCells = [],
        rows = [],
        headRowMix,
        headRowMixFake,
        isCompare = this.isCompare,
        isGoalsColumnsMultiplied = this.isGoalsColumnsMultiplied,
        goals = this.goals,
        isGoalsField = this.isGoalsField,
        // Словарь заголовочных ячеек на которые нужно навесить цель метрики
        // 'ключ ячейки': 'название цели'
        fieldsWithMetrikaGoal = {
            search_query: 'SORT-REQUEST',
            contextcond_orig: 'SORT-SHOW'
        },
        getCell = function(field, index, options) {
            return {
                elem: 'header-cell',
                elemMods: { 'content-type': u.beminize(field) },
                cellOptions: u._.extend(options, {
                    metrikaGoalName: fieldsWithMetrikaGoal[field],
                    column: {
                        id: options.disableSortLink ? undefined : field,
                        title: options.title || commonFields[field],
                        help: helpLinks[field]
                    },
                    sorting: {
                        defaultReverse: field === firstColumn ? 0 : 1,
                        defaultColumn: firstColumn
                    }
                })
            };
        },
        getGoalName = function(goalId) {
            return u['goalsIdName'][goalId] || u._.get(u._.find(data.goals_list, { goal_id: goalId }), 'name', goalId);
        };

    // правильная сортировка для полей представленных в виде двух колонок
    // в b-mol-stat-data.bemtree.xjst есть разделение полей на две колонки
    if (firstColumn === 'adgroup_name') {
        firstColumn = 'adgroup';
    } else if (firstColumn === 'camp_name') {
        firstColumn = 'campaign';
    } else if (firstColumn === 'deal_name') {
        firstColumn = 'deal';
    }

    // Собираем заголовки для срезов
    headerCells = headerCells.concat(
        this.slicesFields.map(function(field, index, arr) {
            var slicesOptions = {
                mods: {
                    type: 'slices',
                    bottom: 'black',
                    'last-of-slices': (arr.length - 1) === index ? 'yes' : undefined
                }
            };

            if (isCompare || isGoalsColumnsMultiplied) {
                slicesOptions.rowspan = 1 + (isCompare ? 1 : 0) + (isGoalsColumnsMultiplied ? 1 : 0);
            }

            // Отключаем сортировку по специфичным полям
            if (needDisableSortLinkFields.indexOf(field) !== -1) {
                slicesOptions.disableSortLink = true;
            }

            return getCell(field, index, slicesOptions);
        })
    );

    // Собираем заголовки для столбцов
    headerCells = headerCells.concat(
        this.columnsFields.map(function(field, index) {
            var isGoal = isGoalsField(field),
                columnsOptions = {
                    mods: {
                        aligned: isCompare || isGoalsColumnsMultiplied && isGoal ? 'center' : 'right',
                        separate: isCompare ? 'left' : (index === 0 ? 'left' : undefined),
                        bottom: isCompare || isGoalsColumnsMultiplied && isGoal ? undefined : 'black'
                    }
                },
                colspan = 1,
                rowspan = 1;

            // при включенном сравнение отключаем сортировку по заголовкам
            // и добавляем ширину, т.к. под заголовком будут 4 подзаголовка (разница, разница %, период а, период б)
            if (isCompare) {
                colspan = 4;
                columnsOptions.disableSortLink = true;
            }

            // Отключаем сортировку по специфичным полям
            if (needDisableSortLinkFields.indexOf(field) !== -1) {
                columnsOptions.disableSortLink = true;
            }

            // При детализации по целям метрики
            if (isGoalsColumnsMultiplied) {
                if (isGoal) {
                    colspan *= goals.length;
                    columnsOptions.disableSortLink = true;
                } else {
                    rowspan = 2;
                }
            }

            if (colspan !== 1) {
                columnsOptions.colspan = colspan;
            }

            if (rowspan !== 1) {
                columnsOptions.rowspan = rowspan;
            }

            return getCell(field, index, columnsOptions)
        })
    );

    if (this.statDataModel) {
        u._.extend(this.statDataModel.head, { modelId: 'head' });
        u._.extend(this.statDataModel['fake-head'], { modelId: 'fake-head' });

        headRowMix = [{
            block: 'i-glue',
            js: {
                modelName: 'm-mol-stat-data-head-row',
                modelId: 'head',
                modelParentName: 'm-mol-stat-data',
                modelParentId: 'stat-data'
            }
        }];

        // синхронизация описана в m-mol-stat-data
        headRowMixFake = [{
            block: 'i-glue',
            js: {
                modelName: 'm-mol-stat-data-head-row',
                modelId: 'fake-head',
                modelParentName: 'm-mol-stat-data',
                modelParentId: 'stat-data'
            }
        }];
    }

    rows.push({
        elem: 'head',
        cols: applyCtx(headerCells),
        mix: headRowMix
    });

    if (isGoalsColumnsMultiplied) {
        subHeadsGoalsCells = this.columnsFields.reduce(function(result, field, index) {
            if (isGoalsField(field)) {
                result = result.concat(goals.map(function(goalId, y) {
                    var goalName = getGoalName(goalId);

                    return {
                        elem: 'header-cell',
                        cellOptions: {
                            column: {
                                title: '<span title="' + u.escapeHTML(goalName) + '">' + goalName + '</span>'
                            },
                            mods: {
                                bottom: isCompare ? undefined : 'black',
                                separate: isCompare ? 'left' : (index === 0 ? 'left' : undefined),
                                type: 'goal'
                            },
                            colspan: isCompare ? 4 : 1
                        }
                    };
                }))
            }

            return result;
        }, []);

        rows.push({
            elem: 'head',
            elemMods: { subhead: 'yes' },
            cols: applyCtx(subHeadsGoalsCells)
        });
    }

    // Если включен режим сравнения - добавляем подзаголовки для столбцов
    if (isCompare) {
        var subHeads = [
            {
                title: iget2('b-mol-stat-data', 'raznica', 'Разница, %'),
                suffix: 'delta'
            },
            {
                title: iget2('b-mol-stat-data', 'raznica-181', 'Разница'),
                suffix: 'absdelta'
            },
            {
                title: iget2('b-mol-stat-data', 'period-a', 'Период A'),
                suffix: 'a'
            },
            {
                title: iget2('b-mol-stat-data', 'period-b', 'Период B'),
                suffix: 'b'
            }
        ];

        this.columnsFields
            .reduce(function(result, field) {
                return result.concat(
                    isGoalsColumnsMultiplied && isGoalsField(field) ?
                        goals.map(function(goalId) { return field + '_' + goalId; }) :
                        field
                );
            }, [])
            .forEach(function(columnFieldName) {
                subHeads.forEach(function(field, i) {
                    subHeadCells.push({
                        elem: 'header-cell',
                        cellOptions: {
                            column: {
                                id: columnFieldName + '_' + field.suffix,
                                title: field.title
                            },
                            sorting: {
                                defaultReverse: field === firstColumn ? 0 : 1,
                                defaultColumn: firstColumn + '_delta'
                            },
                            mods: {
                                bottom: 'black',
                                separate: i === 0 ? 'left' : undefined
                            }
                        }
                    });
                });
            });

        rows.push({
            elem: 'head',
            elemMods: {
                subhead: 'yes'
            },
            cols: applyCtx(subHeadCells)
        });
    }

    // дублируем строки хедера таблицы для плавающей плашки
    rows.push({
        elem: 'head',
        cols: applyCtx(headerCells),
        mix: [{ elem: 'fake-head' }].concat(headRowMixFake)
    });

    isGoalsColumnsMultiplied && rows.push({
        elem: 'head',
        elemMods: { subhead: 'yes' },
        mix: { elem: 'fake-head' },
        cols: applyCtx(subHeadsGoalsCells)
    });

    isCompare && rows.push({
        elem: 'head',
        elemMods: { subhead: 'yes' },
        mix: { elem: 'fake-head' },
        cols: applyCtx(subHeadCells)
    });

    return { rows: rows };
});
