block('b-mol-stat-data').elem('total-table').def()(function() {
    var isGoalsColumnsMultiplied = this.isGoalsColumnsMultiplied,
        goals = this.data.goal_ids || [],
        isGoalsField = this.isGoalsField;

    return {
        rows: u._.filter([
            {
                elem: 'row',
                cols: u._.flatten(
                    this.totalFields
                        .reduce(function(result, field) {
                            return result.concat(
                                isGoalsColumnsMultiplied && isGoalsField(field) ?
                                    goals.map(function(goalId) { return field + '_' + goalId }) :
                                    field
                            )
                        }, [])
                        .map(function(field, i) {
                            var period = {
                                content: this.isCompare ?
                                [
                                    {
                                        elem: 'first-period',
                                        content: iget2('b-mol-stat-data', 'a-from-nachalo-perioda', 'A: {from} — {to}', {
                                            from: u.moment(this.data.date_from).format('DD.MM.YY'),
                                            to: u.moment(this.data.date_to).format('DD.MM.YY'),
                                            context: 'from - начало периода; to - конец периода'
                                        })
                                    },
                                    {
                                        elem: 'second-period',
                                        content: iget2('b-mol-stat-data', 'b-from-nachalo-perioda', 'B: {from} — {to}', {
                                            from: u.moment(this.data.date_from_b).format('DD.MM.YY'),
                                            to: u.moment(this.data.date_to_b).format('DD.MM.YY'),
                                            context: 'from - начало периода; to - конец периода'
                                        })
                                    }
                                ] :
                                    this.data.FORM.stat_type == 'search_queries' ?
                                        iget2('b-mol-stat-data', 'vsego-po-poiskovym-zaprosam', 'Всего по поисковым запросам с {from} по {to}', {
                                            from: u.moment(this.data.date_from).format('DD.MM.YY'),
                                            to: u.moment(this.data.date_to).format('DD.MM.YY'),
                                            context: 'from - начало периода; to - конец периода'
                                        }) :
                                        iget2('b-mol-stat-data', 'vsego-s-from-nachalo', 'Всего с {from} по {to}', {
                                            from: u.moment(this.data.date_from).format('DD.MM.YY'),
                                            to: u.moment(this.data.date_to).format('DD.MM.YY'),
                                            context: 'from - начало периода; to - конец периода'
                                        }),
                                attrs: { colspan: this.slicesFields.length }
                            };

                            return field === 'period' ?
                                period :
                                applyCtx({
                                    block: 'b-mol-stat-data',
                                    elem: 'columns-content',
                                    // для ДРФ полное ИТОГО приходит в grand_totals
                                    data: this.data.statType == 'ext_phrases' ? this.data.grand_totals : this.data.totals,
                                    field: field,
                                    isTotal: true,
                                    isFirst: i === 1
                                });
                        }, this)
                ),
                summary: true
            },
            this.data.statType == 'ext_phrases' ?
                {
                    elem: 'row',
                    elemMods: {
                        'grand-totals': 'yes'
                    },
                    cols: u._.flatten(this.totalFields.map(function(field, i) {
                        var totlaTitle = {
                            content: iget2('b-mol-stat-data', 'vsego-po-dopolnitelnym-frazam', 'Всего по дополнительным фразам'),
                            attrs: {
                                colspan: this.slicesFields.length
                            }
                        };

                        return field === 'period' ?
                            totlaTitle :
                            applyCtx({
                                block: 'b-mol-stat-data',
                                elem: 'columns-content',
                                data: this.data.totals,
                                field: field,
                                isFirst: i === 1
                            });
                    }, this)),
                    summary: true
                } :
                ''
        ])
    };
});
