block('b-mol-stat-data')(

    def()(function() {
        var data = this.data,
            clientId = u._.get(data, 'campaign.ClientID'),
            slicesFields = [], // порядок срезов
            isPercOfImpDisabled = u.consts('isPercOfImpDisabled'),
            columnsFields = isPercOfImpDisabled ? data.columns.filter(function(field) {
                return field !== 'winrate'
            }) : data.columns, // порядок столбцов
            totalFields = [].concat(columnsFields), // В итоговой таблице у нас только период и столбцы. (concat для создания нового массива!)
            dataArray = data.data_array, // данные для детальной таблицы
            // в campaigns_list приходят кампании со всех страниц статистики,
            // выбираем только те кампании, которые отображены на текущей странице
            cidsOnPage = dataArray.reduce(function(result, rowData) {
                result[rowData.cid] = true;

                return result;
            }, {}),

            // отфильтровываем кампании, у которых нет превью
            campsWithoutPreviewOnPage = data.campaigns_list.reduce(function(result, campaign) {
                var match = cidsOnPage[campaign.cid] &&
                    [
                        'internal_distrib',
                        'internal_free',
                        'internal_autobudget',
                        'cpm_price'
                    ].indexOf(campaign.type) !== -1;

                if (match) {
                    result[campaign.cid] = campaign;
                }

                return result;
            }, {}),
            // отфильтровываем не текстово-графические кампании и строим объект кампаний, ключом которого будет
            // cid, значением объект кампании
            campsWithPreviewOnPage = data.campaigns_list.reduce(function(result, campaign) {
                var match = cidsOnPage[campaign.cid] &&
                    [
                        'text',
                        'mobile_content',
                        'dynamic',
                        'performance',
                        'mcbanner',
                        'cpm_banner',
                        'cpm_deals',
                        'cpm_yndx_frontpage',
                        'content_promotion'
                    ].indexOf(campaign.type) !== -1;

                if (match) {
                    result[campaign.cid] = campaign;
                }

                return result;
            }, {}),
            // Убрать как только b-group-preview2-opener будет работать со всеми типами кампаний/баннеров
            // https://st.yandex-team.ru/DIRECT-70469 - задача на убирание
            otherCampsOnPage = data.campaigns_list.reduce(function(result, campaign) {
                var match = cidsOnPage[campaign.cid] &&
                    [
                        'text',
                        'mobile_content',
                        'dynamic',
                        'performance',
                        'mcbanner',
                        'cpm_banner',
                        'cpm_deals',
                        'cpm_yndx_frontpage',
                        'content_promotion',
                        'cpm_price'
                    ].indexOf(campaign.type) === -1;

                if (match) {
                    result[campaign.cid] = campaign;
                }

                return result;
            }, {}),
            // кампании перенесенные в архив
            archivedCamps = data.campaigns_list.reduce(function(result, campaign) {
                if (campaign.archived === 'Yes') {
                    result[campaign.cid] = campaign;
                }

                return result;
            }, {}),
            goals = data.goal_ids || [],
            isGoalsField = function(field) {
                var goalsFields = [
                    // Post-click
                    'aconv', 'agoalnum',
                    // Post-view
                    'pv_aconv', 'pv_agoalcost', 'pv_agoalnum'
                ];

                if (!u.hasClientFeature('single_goal_cost_enabled')) {
                    goalsFields.push('agoalcost');
                }

                return goalsFields.indexOf(field) !== -1;
            },
            isGoalsColumnsMultiplied = goals.length > 1 &&
                columnsFields.some(isGoalsField),
            isMultiClientEnabled = u.consts('rights').enableStatsMultiClientsMode;

        // Перебираем массив срезов, т.к. некоторые из них
        // представлены как две колонки
        u['b-statistics-form']
            .mapNamesToClientFormat(data.group_by, isMultiClientEnabled)
            .forEach(function(field) {
                if (field === 'adgroup') {
                    slicesFields.push('adgroup_name', 'adgroup');
                } else if (field === 'campaign') {
                    slicesFields.push('camp_name', 'campaign');
                } else if (field === 'deal') {
                    slicesFields.push('deal_name', 'deal');
                } else {
                    slicesFields.push(field);
                }
            });

        // Столбец "Дата" и данные о периоде мы показываем только при группировке, отличной от "за выбранный период"
        // В противном случае мы убираем столбец дата, а период показываем только если срезов > 0
        if (data.group_by_date === 'none' && slicesFields.length) {
            totalFields.unshift('period');
        } else {
            slicesFields.unshift('date');
            totalFields.unshift('period');
        }

        // модель таблицы m-mol-stat-data строиться в процессе формирования данных
        return applyNext({
            statDataModel: this.ctx.needModel ?
                {
                    head: {}, // данные для хедера таблицы m-mol-stat-data-head-row
                    'fake-head': {}, // дублирующая модель для синхронизации с плавающей плашкой
                    'detailed-rows': [] // данные для строк m-mol-stat-data-row
                } :
                undefined,
            slicesFields: slicesFields,
            columnsFields: columnsFields,
            totalFields: totalFields,
            dataArray: dataArray,
            otherCampsOnPage: otherCampsOnPage,
            campsWithoutPreviewOnPage: campsWithoutPreviewOnPage,
            isCompare: !!+data.compare_periods,
            archivedCamps: archivedCamps,
            clientId: clientId,
            campsWithPreviewOnPage: Object.keys(campsWithPreviewOnPage).length ? campsWithPreviewOnPage : null,
            goals: goals,
            isGoalsField: isGoalsField,
            isGoalsColumnsMultiplied: isGoalsColumnsMultiplied
        });
    }),

    content()(function() {
        var data = this.data;

        return [].concat(
            Boolean(this.ctx.showStrategyInfo) && {
                block: 'b-stat-strategy-changes-info',
                mix: [
                    {
                        block: 'p-campaign-stat',
                        elem: 'strategy-changes-info'
                    }
                ]
            },
            [
                this.data.statType == 'moc' && {
                    block: 'b-mol-stat-data',
                    elem: 'metrika-link',
                    content: {
                        block: 'b-metrika-link',
                        orderId: this.data.campaign.OrderID,
                        metrikaCounters: this.data.campaign.metrika_counters,
                        goalId: (this.data.filters && this.data.filters['goal_id'] && this.data.filters['goal_id'].eq) || undefined,
                        dateFrom: this.data.date_from,
                        dateTo: this.data.date_to,
                        group: this.data.group_by_date == 'none' ? undefined : this.data.group_by_date,
                        attribution: this.data.FORM.attribution_model || this.data.attribution_model
                    }
                }
            ],
            this.ctx.content || [],
            {
                elem: 'fraud',
                fraudClicks: data.fraud_clicks,
                fraudGiftClicks: data.fraud_gift_clicks
            },
            {
                elem: 'fraud-cpm-shows',
                fraudShowsTotalMrc: data.fraud_shows_total_mrc,
                fraudShowsGivtRate: data.fraud_shows_givt_rate
            },
            {
                block: 'b-stat-table',
                mods: {
                    type: 'mol',
                    compare: this.isCompare ? 'yes' : undefined
                },
                content: applyCtx([
                    {
                        elem: 'total-table'
                    },
                    {
                        elem: 'table-head',
                        currency: this.ctx.currency
                    },
                    {
                        elem: 'detailed-table'
                    },
                    {
                        elem: 'bottom-table'
                    }
                ]),
                // mix должен идти после content, т.к. в content формируются данные для модели
                mix: this.statDataModel ?
                    {
                        block: 'i-glue',
                        js: {
                            modelName: 'm-mol-stat-data',
                            modelId: 'stat-data',
                            modelData: this.statDataModel
                        }
                    } :
                    undefined
            }
        );
    }),

    match(function() {
        return this.campsWithPreviewOnPage;
    }).content()(function() {
        var data = this.data,
            allowEditCamps = data.allow_edit_camps,
            campsWithPreviewOnPage = this.campsWithPreviewOnPage;

        return [
            applyNext(),
            Object.keys(campsWithPreviewOnPage).map(function(cid) {
                var campData = campsWithPreviewOnPage[cid];

                return {
                    block: 'i-model',
                    modelParams: {
                        name: u.campaign.getCampaignModelName(campData.type),
                        id: cid,
                        data: u._.extend(campData, {
                            editable: !!allowEditCamps[cid],
                            mediaType: campData.type
                        })
                    }
                };
            })
        ];

    })
);
