block('b-new-agency-client')(

    addJs()(function() {
        return {
            retpath: this.data.FORM.retpath,
            mediaType: this.data.FORM.mediaType,
            agencyClient: !hasLoginRights('manager_control', 'super_control', 'superreader_control', 'limited_support_control')
        };
    }),

    content()(function() {
        var lang = this.data.lang,
            form,
            getFrameUrl = function(path) {
                return u.formatUrl({
                    host: u.getLegalUrl(path),
                    query: {
                        mode: 'text',
                        lang: lang || 'ru'
                    }
                });
            };

        form = [
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-new-agency-client', 'imya-185', 'Имя') + ':'
                    },
                    {
                        elem: 'field',
                        content: {
                            block: 'input',
                            mix: {
                                block: 'b-new-agency-client',
                                elem: 'model-field',
                                js: {
                                    name: 'firstname',
                                    type: 'input'
                                }
                            },
                            js: {
                                name: 'firstname'
                            },
                            content: {
                                elem: 'control',
                                attrs: {
                                    tabindex: 1,
                                    autocomplete: 'off'
                                }
                            }
                        }
                    },
                    {
                        elem: 'hint',
                        content: {
                            elem: 'error',
                            mix: [
                                {
                                    elem: 'model-field',
                                    js: {
                                        name: 'firstnameError',
                                        type: 'inline'
                                    }
                                }
                            ]
                        }
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-new-agency-client', 'familiya', 'Фамилия') + ':'
                    },
                    {
                        elem: 'field',
                        content: {
                            block: 'input',
                            mix: {
                                block: 'b-new-agency-client',
                                elem: 'model-field',
                                js: {
                                    name: 'lastname',
                                    type: 'input'
                                }
                            },
                            js: {
                                name: 'lastname'
                            },
                            content: {
                                elem: 'control',
                                attrs: {
                                    tabindex: 2,
                                    autocomplete: 'off'
                                }
                            }
                        }
                    },
                    {
                        elem: 'hint',
                        content: {
                            elem: 'error',
                            mix: [
                                {
                                    elem: 'model-field',
                                    js: {
                                        name: 'lastnameError',
                                        type: 'inline'
                                    }
                                }
                            ]
                        }
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-new-agency-client', 'login-186', 'Логин') + ':'
                    },
                    {
                        elem: 'field',
                        content: [
                            {
                                block: 'input',
                                mix: {
                                    block: 'b-new-agency-client',
                                    elem: 'model-field',
                                    js: {
                                        name: 'login',
                                        type: 'input'
                                    }
                                },
                                js: {
                                    name: 'login'
                                },
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        tabindex: 3,
                                        autocomplete: 'off'
                                    }
                                }
                            },
                            {
                                block: 'b-login-suggest'
                            }
                        ]
                    },
                    {
                        elem: 'hint',
                        mix: {
                            elem: 'model-field',
                            js: {
                                name: 'loginState',
                                type: 'mod',
                                modName: 'login-state',
                                block: 'b-new-agency-client',
                                elem: 'hint'
                            }
                        },
                        content: [
                            '@yandex.ru',
                            {
                                elem: 'invalid-login',
                                content: iget2('b-new-agency-client', 'nedopustimyy-login', 'недопустимый логин')
                            },
                            {
                                elem: 'not-available',
                                content: iget2('b-new-agency-client', 'login-dlya-registracii-nedostupen', 'логин для регистрации недоступен')
                            },
                            {
                                elem: 'valid-login',
                                content: iget2('b-new-agency-client', 'login-svoboden', 'логин свободен')
                            },
                            {
                                elem: 'validate-login',
                                content: iget2('b-new-agency-client', 'proverka', 'проверка') + '...'
                            },
                            {
                                elem: 'inline-error',
                                mix: [
                                    {
                                        elem: 'error'
                                    },
                                    {
                                        elem: 'model-field',
                                        js: {
                                            name: 'loginError',
                                            type: 'inline'
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-new-agency-client', 'parol', 'Пароль') + ':'
                    },
                    {
                        elem: 'field',
                        content: [
                            {
                                block: 'input',
                                mix: {
                                    block: 'b-new-agency-client',
                                    elem: 'model-field',
                                    js: {
                                        name: 'password',
                                        type: 'input'
                                    }
                                },
                                js: {
                                    name: 'password'
                                },
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        tabindex: 4,
                                        type: 'password',
                                        autocomplete: 'off'
                                    }
                                }
                            },
                            {
                                elem: 'password-status',
                                content: [
                                    {
                                        elem: 'password-status-box',
                                        content: {
                                            elem: 'password-status-bar',
                                            attrs: {
                                                style: 'width: 0%'
                                            }
                                        }
                                    },
                                    {
                                        elem: 'password-status-text'
                                    }
                                ]
                            },
                            {
                                elem: 'error',
                                mix: {
                                    elem: 'model-field',
                                    js: {
                                        name: 'passwordError',
                                        type: 'inline'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        elem: 'hint',
                        content: [
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes'
                                },
                                mix: {
                                    block: 'b-new-agency-client',
                                    elem: 'password-hint-toggler'
                                },
                                content: iget2('b-new-agency-client', 'kak-vybrat-parol', 'Как выбрать пароль'),
                                js: true
                            },
                            {
                                elem: 'inline-error',
                                mix: [
                                    {
                                        elem: 'error'
                                    },
                                    {
                                        elem: 'model-field',
                                        js: {
                                            name: 'passwordRequiredError',
                                            type: 'inline'
                                        }
                                    }
                                ]
                            },
                            {
                                elem: 'password-hint',
                                content: {
                                    elem: 'how-to',
                                    elemMods: { hidden: 'yes' },
                                    mix: {
                                        elem: 'comment'
                                    },
                                    content: [
                                        iget2(
                                            'b-new-agency-client',
                                            'parol-dolzhen-soderzhat-ne',
                                            'Пароль должен содержать не менее 6 символов. Можно использовать латинские буквы, цифры и символы из списка'
                                        ) + ':',
                                        {
                                            elem: 'symbols',
                                            content: '` ! @ # $ % ^ & * ( ) _ = + - [ ] { } ; : " | , . < > \\ / ?'
                                        },
                                        iget2('b-new-agency-client', 'parol-ne-mozhet-sovpadat', 'Пароль не может совпадать с логином.')
                                    ]
                                }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-new-agency-client', 'parol-eshchyo-raz', 'Пароль ещё раз') + ':'
                    },
                    {
                        elem: 'field',
                        content: [
                            {
                                block: 'input',
                                mix: {
                                    block: 'b-new-agency-client',
                                    elem: 'model-field',
                                    js: {
                                        name: 'password2',
                                        type: 'input'
                                    }
                                },
                                js: {
                                    name: 'password2'
                                },
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        tabindex: 5,
                                        type: 'password',
                                        autocomplete: 'off'
                                    }
                                }
                            },
                            {
                                elem: 'error',
                                mix: {
                                    elem: 'model-field',
                                    js: {
                                        name: 'password2Error',
                                        type: 'inline'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        elem: 'hint',
                        content: [
                            {
                                elem: 'inline-error',
                                mix: [
                                    {
                                        elem: 'error'
                                    },
                                    {
                                        elem: 'model-field',
                                        js: {
                                            name: 'password2RequiredError',
                                            type: 'inline'
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];

        return [
            {
                elem: 'top-error'
            },
            {
                elem: 'top-error-hint'
            },
            {
                elem: 'section',
                content: form
            },
            {
                elem: 'section',
                content: {
                    block: 'b-captcha',
                    url: this.data.captcha_url,
                    js: {
                        captchaId: this.data.captcha_id
                    },
                    error: {
                        elem: 'error',
                        mix: {
                            block: 'b-new-agency-client',
                            elem: 'model-field',
                            js: {
                                name: 'captchaCodeError',
                                type: 'inline'
                            }
                        }
                    },
                    tabindex: 7
                }
            },
            {
                elem: 'section',
                mix: {
                    elem: 'accept-rules'
                },
                content: {
                    block: 'checkbox',
                    mods: {
                        checked: 'yes'
                    },
                    mix: {
                        block: 'b-new-agency-client',
                        elem: 'accept-checkbox'
                    },
                    checkboxAttrs: {
                        tabindex: 8
                    },
                    text: {
                        mix: {
                            block: 'b-new-agency-client',
                            elem: 'comment'
                        },
                        content: iget2(
                            'b-new-agency-client',
                            'nazhimaya-knopku-zavershit-registraciyu',
                            'Нажимая кнопку «Завершить регистрацию», я принимаю условия {rules} и даю своё согласие Яндексу на обработку моих персональных данных, в соответствии с Федеральным законом от 27.07.2006 года №152-ФЗ «О персональных данных», на условиях и для целей, определенных {confidential}',
                            {
                                rules: function(text) {
                                    return [
                                        {
                                            block: 'link',
                                            mods: {
                                                pseudo: 'yes'
                                            },
                                            mix: {
                                                block: 'b-new-agency-client',
                                                elem: 'frame-toggler',
                                                js: {
                                                    name: 'rules'
                                                }
                                            },
                                            content: text
                                        },
                                        {
                                            block: 'b-new-agency-client',
                                            elem: 'rules-frame',
                                            tag: 'iframe',
                                            attrs: {
                                                src: getFrameUrl('rules')
                                            }
                                        }
                                    ];
                                }(iget2('b-new-agency-client', 'nazhimaya-knopku-zavershit-registraciyu-param-rules', 'Пользовательского соглашения')),

                                confidential: function(text) {
                                    return [
                                        {
                                            block: 'link',
                                            mods: {
                                                pseudo: 'yes'
                                            },
                                            mix: {
                                                block: 'b-new-agency-client',
                                                elem: 'frame-toggler',
                                                js: {
                                                    name: 'confidential'
                                                }
                                            },
                                            content: text
                                        },
                                        '.',
                                        {
                                            block: 'b-new-agency-client',
                                            elem: 'confidential-frame',
                                            tag: 'iframe',
                                            attrs: {
                                                src: getFrameUrl('confidential')
                                            }
                                        }
                                    ];
                                }(
                                    iget2('b-new-agency-client', 'nazhimaya-knopku-zavershit-registraciyu-param-confidential', 'Политикой конфиденциальности')
                                ),

                                context: 'rules - Пользовательского соглашения; confidential - Политикой конфиденциальности'
                            }
                        )
                    }
                }
            },
            {
                elem: 'footer',
                content: {
                    block: 'button',
                    attrs: {
                        tabindex: 9
                    },
                    mix: {
                        block: 'b-new-agency-client',
                        elem: 'register-button'
                    },
                    content: iget2('b-new-agency-client', 'zaregistrirovat', 'Зарегистрировать')
                }
            }
        ];
    })
);
