BEM.DOM.decl({ block: 'b-new-agency-client', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var model = this.model,
                updateSuggest = $.debounce(this._updateSuggest, 1000, false, this),
                checkLogin = $.debounce(this._checkLogin, 1000, false, this),
                checkPassword = $.debounce(this._checkPassword, 500, false, this),
                captcha = this.captcha = this.findBlockInside('b-captcha');

            BEM.blocks['i-utils'].graspSelf.call(this, {
                _registerButton: 'button on register-button',
                _acceptCheckbox: 'checkbox on accept-checkbox'
            });

            this._registerButton.on('click', function() {
                var validateResult = model.validate();

                ['firstname', 'lastname', 'login', 'password', 'password2', 'captchaCode'].forEach(function(fieldName) {
                    model.updateValidateError(fieldName, validateResult);
                });

                if (!(validateResult.errors || []).length) {
                    this._register();
                }
            }, this);

            this.bindTo('password-hint-toggler', 'pointerclick', function() {
                this.toggleMod(this.elem('how-to'), 'hidden', 'yes', '');
            });

            BEM.DOM.blocks['input'].on(this.domElem, 'change', function(e) {
                var target = e.target,
                    name = target.params.name;

                if (/^(firstname|lastname|login|password|password2)$/g.test(name)) {
                    model.updateValidateError(name, model.validate());

                    name === 'password' && model.isEmpty(name) &&
                        model.updateValidateError('password2', model.validate());
                }

                if (/^(firstname|lastname|login)$/g.test(name)) {
                    updateSuggest();
                }
            }, this);

            model
                .on('login', 'change', function(e, data) {
                    model.set('loginState', data.value ? 'checking' : '');

                    checkLogin(data.value);

                    model.recheckPasswordIsLoginError();
                })
                .on('password', 'change', function(e, data) {
                    model.set('passwordState', 'checking');

                    checkPassword(data.value);

                    model.checkPasswordState();

                    this.elem('password-status-bar')
                        .attr('style', 'width: ' + Math.floor((data.value || '').length / 255 * 100) + '%');
                }, this)
                .on('passwordState', 'change', $.debounce(function(e, data) {
                    var state = data.value,
                        length = model.getPasswordLength() && model.getPasswordLength(true),
                        texts = {
                            weak: length ? iget2('b-new-agency-client', 'prostoy-s', 'простой, {foo}', {
                                foo: length
                            }) : '',
                            'error-weak': length ? iget2('b-new-agency-client', 'slishkom-prostoy-s', 'слишком простой, {foo}', {
                                foo: length
                            }) : '',
                            strong: length ? iget2('b-new-agency-client', 'nadyozhnyy-s', 'надёжный, {foo}', {
                                foo: length
                            }) : '',
                            checking: iget2('b-new-agency-client', 'proverka-nadezhnosti', 'проверка надежности...')
                        },
                        statusElem = this.elem('password-status'),
                        statusTextElem = this.elem('password-status-text');

                    this.toggleMod(statusElem, 'checking', 'yes', state === 'checking');

                    this.delMod(statusElem, 'state');

                    if (/^(weak|error-weak|strong|error)$/g.test(state)) {
                        this.setMod(statusElem, 'state', length ? state : '');
                    }

                    if (/^(weak|error-weak|strong|checking)$/g.test(state)) {
                        statusTextElem.text(texts[state]);
                    } else if (state === 'error') {
                        statusTextElem.text('');
                    }
                }, 10, false, this))
                .on('passwordError', 'change', function(e, data) {
                    if (data.value) this.elem('password-status-text').text('');
                }, this)
                .on('passwordRequiredError', 'change', function(e, data) {
                    if (data.value) this.elem('password-status-text').text('');
                }, this);

            captcha.on('change', function(e, data) {
                model
                    .set('captchaCode', data.val)
                    .set('captchaId', data.id);
            }, this);

            this.bindTo('frame-toggler', 'pointerclick', function(e) {
                var name = this.elemParams($(e.currentTarget)).name;

                this.toggleMod(this.elem(name + '-frame'), 'visible', '', 'yes');

                return false;
            });

            this._acceptCheckbox.on('change', function(event) {
                this._registerButton.setMod('disabled', event.target.isChecked() ? '' : 'yes');
            }, this);

            // выставление логина, которым проинициализирована модель для события change
            // явно триггерить события change нельзя, так как не даёт нужного эффекта
            (function(login) {
                model
                    .clear('login')
                    .set('login', login);
            })
                .call(this, model.get('login'));
        }
    },

    /**
     * Обновляет подсказки логина.
     *
     * @private
     */
    _updateSuggest: function() {
        var firstname = this.model.get('firstname'),
            lastname = this.model.get('lastname'),
            login = this.model.get('login');

        if (!firstname || !lastname) return;

        var track = this.model.get('trackId'),
            params = { cmd: 'ajaxSuggestLogin', firstname: firstname, lastname: lastname };

        if (track) params.track_id = track;

        if (login) params.login = login;

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this
        }).get(
            params,
            function(result) {
                var logins = (result || {}).logins || [];

                if (logins.length) this._renderLoginSuggest(logins);
            });
    },

    /**
     * Отрисовывает подсказки логина.
     *
     * @param {Array} logins - Доступные логины.
     * @private
     */
    _renderLoginSuggest: function(logins) {
        var block = this.findBlockInside('b-login-suggest');

        block && BEM.DOM.replace(block.domElem, BEMHTML.apply({
            block: 'b-login-suggest',
            logins: logins,
            actionMix: { block: 'b-new-agency-client', elem: 'suggest-item' }
        }));
    },

    /**
     * Проверяет логи на доступность и валидность.
     *
     * @param {String} login - Логин.
     * @private
     */
    _checkLogin: function(login) {
        if (!this.model.validate('login').valid) {
            this.model.isEmpty('login') || this.model.set('loginState', 'invalid-login');

            return;
        }

        this.model.set('loginState', 'checking');

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this,
            type: 'POST'
        }).get(
            { cmd: 'ajaxValidateLogin', login: login, track_id: this.model.get('trackId') },
            function(result) {
                var errors = result.validation_errors || result.errors;

                if (errors) {
                    this._updateLoginValidateError(errors);
                } else {
                    this.model.set('loginState', 'available');
                }
            },
            function() {
                this.model.set('loginState', '');
            });
    },

    /**
     * Обновляет ошибки валидации.
     *
     * @param {Array} errors - Стек ошибок.
     * @private
     */
    _updateLoginValidateError: function(errors) {
        var firstErrCode = errors[0].code;

        this.model.set('loginState', firstErrCode === 'notavailable' ? 'not-available' : '');

        if (firstErrCode && firstErrCode !== 'notavailable') {
            this.model.set('loginState', 'invalid-login');

            this.model.set('loginError', this.model.getLoginInvalidText());
        }
    },

    /**
     * Проверяет пароль на строгость и валидность.
     *
     * См. документацию https://wiki.yandex-team.ru/passport/python/api/bundle/validate#proveritparol
     *
     * @param {String} password - Пароль.
     * @private
     */
    _checkPassword: function(password) {
        if (!this.model.validate('password').valid) {
            this.model.set('passwordState', 'error');

            return;
        }

        this.model.set('passwordState', 'checking');

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this,
            type: 'POST'
        }).get(
            { cmd: 'ajaxValidatePassword', password: password, track_id: this.model.get('trackId') },
            function(result) {
                var errors,
                    warnings,
                    state = 'error';

                if (result.status === 'ok') {
                    errors = result.validation_errors;

                    if (errors) {
                        errors[0].code === 'weak' && (state = 'error-weak');
                    } else {
                        state = 'strong';

                        warnings = result.validation_warnings;

                        warnings && warnings[0].code === 'weak' && (state = 'weak');
                    }
                }

                this.model.set('passwordState', state);
            },
            function() {
                this.model.set('passwordState', 'error');
            });
    },

    /**
     * Регистрирует нового пользователя.
     *
     * @private
     */
    _register: function() {
        var login = this.model.get('login'),
            lang = BEM.blocks['i-global'].param('lang');

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this,
            type: 'POST'
        }).get(
            {
                cmd: 'ajaxRegisterLogin',
                firstname: this.model.get('firstname'),
                lastname: this.model.get('lastname'),
                login: login,
                password: this.model.get('password'),
                language: lang == 'ua' ? 'uk' : lang,
                track_id: this.model.get('trackId'),
                x_captcha_code: this.model.get('captchaCode'),
                x_captcha_id: this.captcha.getId()
            },
                function(result) {
                    var type,
                        mediaType = this.params.mediaType || 'text',
                        params = u.parseUrl(this.params.retpath || ''),
                        location,
                        isRetpathOnSafeDomain = !params.host ||
                            /^(\S+\.)*yandex\.(com|tr|ru|ua|kz|by|com\.tr)$/.test(params.host),
                        errors = result.errors || [];

                    if (result.uid) {

                        if (this.params.retpath && isRetpathOnSafeDomain) {
                            params.query || (params.query = {});

                            params.query.login = login;
                            params.query.csrf_token = u.consts('csrf_token');
                            params.query.mediaType = mediaType;

                            location = u.formatUrl(params);
                        } else {
                            type = this.params.agencyClient ? 'subclient' : 'client';

                            location = u.getUrl('stepZeroProcess', {
                                newlogin: login,
                                type: type,
                                mediaType: mediaType
                            });
                        }

                        this.__self.doc.get(0).location = location;
                    } else {
                        this.captcha.refresh();

                        if (errors[0].code === 'incorrectcaptcha') {
                            this._showTopError(
                                iget2('b-new-agency-client', 'vy-nepravilno-vveli-kontrolnye', 'Вы неправильно ввели контрольные символы.'),
                                this._getCaptchaErrorHint());
                        } else {
                            this._showTopError(iget2('b-new-agency-client', 'oshibka-pri-registracii-novogo', 'Ошибка при регистрации нового клиента.'));
                        }
                    }
                },
                function() {
                    this.captcha.refresh();

                    this._showTopError(iget2('b-new-agency-client', 'oshibka-pri-registracii-novogo', 'Ошибка при регистрации нового клиента.'));
                });
    },

    /**
     * Показывает подсказку при ошибке каптчи.
     *
     * @private
     */
    _getCaptchaErrorHint: function() {
        return iget2(
            'b-new-agency-client',
            'esli-vy-vidite-eto',
            'Если вы видите это сообщение не первый раз, возможно вам необходимо включить куки (Cookies) в настройках вашего браузера.'
        ) +
            ' ' + iget2('b-new-agency-client', 'o-tom-kak-eto', 'О том, как это сделать, можно {link}.', {
                link: function(text) {
                    return BEMHTML.apply({
                        block: 'b-help-link',
                        mods: { margin: 'no' },
                        url: u.getCommonHelpUrl('/common/browsers-settings/browsers-cookies.xml'),
                        text: text
                    });
                }(iget2('b-new-agency-client', 'o-tom-kak-eto-param-link', 'прочитать в разделе помощи')),

                context: 'link - прочитать в разделе помощи'
            });
    },

    /**
     * Показывает ошибки валидации в верху страницы.
     *
     * @param {String} errorText - Текст ошибки.
     * @param {String} [hintHtml] - Текст подсказки.
     * @private
     */
    _showTopError: function(errorText, hintHtml) {
        this.elem('top-error').html(BEMHTML.apply({ block: 'b-icon', mods: { 'size-23': 'notice' } }) + errorText);
        this.elem('top-error-hint').html(hintHtml || '');
    }
}, {
    live: function() {
        this.liveBindTo('suggest-item', 'pointerclick', function(event) {
            this.model.set('login', this.elemParams(this.findElem(event.data.domElem, 'suggest-item')).data);
        });

        return false;
    }
});
