block('b-new-potential-report')(

    def()(function() {
        var finish = new Date(),
            start = new Date(),
            dateToString = function(date) {
                return date.toISOString().split('T')[0];
            };

        finish.setDate(finish.getDate() - 1);
        start.setDate(start.getDate() - 31);

        return applyNext({
            today: dateToString(new Date()),
            finish: dateToString(finish),
            start: dateToString(start),
            url: this.ctx.url
        });
    }),

    addJs()(function() {
        return {
            url: this.url
        };
    }),

    content()(function() {
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'b-new-potential-report',
                elem: 'form'
            }],
            mixes: {
                row: [{
                    block: 'b-new-potential-report',
                    elem: 'row'
                }],
                label: [{
                    block: 'b-new-potential-report',
                    elem: 'label'
                }],
                submit: [{
                    block: 'b-new-potential-report',
                    elem: 'submit-row'
                }]
            },
            rows: [
                {
                    mixes: {
                        row: [{
                            block: 'b-new-potential-report',
                            elem: 'controls-row'
                        }]
                    },
                    control: {
                        block: 'b-new-potential-report',
                        elem: 'controls',
                        content: [
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes'
                                },
                                mix: [{
                                    block: 'b-new-potential-report',
                                    elem: 'copy-last'
                                }],
                                content: iget2('b-new-potential-report', 'skopirovat-iz-predydushchego-zadaniya', 'Скопировать из предыдущего задания')
                            },
                            '<br/>',
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes'
                                },
                                mix: [{
                                    block: 'b-new-potential-report',
                                    elem: 'clear'
                                }],
                                content: iget2('b-new-potential-report', 'ochistit-polya-modulya', 'Очистить поля модуля')
                            }
                        ]
                    }
                },
                {
                    control: {
                        block: 'b-new-potential-report',
                        elem: 'subtitle',
                        content: iget2('b-new-potential-report', 'informacionnyy-blok', 'Информационный блок') + ':'
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'nazvanie-klienta-187', 'Название клиента'),
                    control: {
                        block: 'input',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'client-name'
                        }],
                        content: {
                            elem: 'control'
                        }
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'nazvanie-kategorii', 'Название категории'),
                    control: {
                        block: 'input',

                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'category-name'
                        }],
                        content: {
                            elem: 'control'
                        }
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'data-podgotovki', 'Дата подготовки'),
                    control: {
                        block: 'b-date-input',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'report-date'
                        }],
                        dateFormat: 'YYYY-MM-DD',
                        value: this.today
                    }
                },
                {
                    control: {
                        block: 'b-new-potential-report',
                        elem: 'subtitle',
                        content: iget2('b-new-potential-report', 'funkcionalnyy-blok', 'Функциональный блок') + ':'
                    }
                },
                {
                    control: [
                        {
                            block: 'b-new-potential-report',
                            elem: 'pane',
                            content: [
                                {
                                    block: 'radiobox',
                                    js: {
                                        id: 'fetchby'
                                    },
                                    name: 'fetchby',
                                    value: 'cids',
                                    content: [{
                                        elem: 'radio',
                                        controlAttrs: {
                                            value: 'cids'
                                        },
                                        content: iget2('b-new-potential-report', 'id-kampaniy', 'ID кампаний')
                                    }]
                                },
                                {
                                    block: 'input',
                                    mix: [{
                                        block: 'b-new-potential-report',
                                        elem: 'cids'
                                    }],
                                    mods: {
                                        type: 'textarea'
                                    },
                                    content: {
                                        elem: 'control'
                                    }
                                },
                                {
                                    block: 'radiobox',
                                    js: {
                                        id: 'fetchby'
                                    },
                                    name: 'fetchby',
                                    value: 'cids',
                                    content: [{
                                        elem: 'radio',
                                        controlAttrs: {
                                            value: 'logins'
                                        },
                                        content: iget2('b-new-potential-report', 'loginy', 'Логины')
                                    }]
                                },
                                {
                                    block: 'input',
                                    mix: [{
                                        block: 'b-new-potential-report',
                                        elem: 'logins'
                                    }],
                                    mods: {
                                        disabled: 'yes'
                                    },
                                    content: {
                                        elem: 'control'
                                    }
                                }
                            ]
                        },
                        {
                            block: 'b-new-potential-report',
                            elem: 'pane',
                            content: [
                                {
                                    block: 'b-new-potential-report',
                                    elem: 'textarea-title',
                                    content: iget2('b-new-potential-report', 'rasshireniya', 'Расширения')
                                },
                                {
                                    block: 'input',
                                    mods: {
                                        type: 'textarea'
                                    },
                                    mix: [{
                                        block: 'b-new-potential-report',
                                        elem: 'ext-phrases'
                                    }],
                                    content: {
                                        elem: 'control',
                                        mix: [{
                                            block: 'b-new-potential-report',
                                            elem: 'ext-phrases-control'
                                        }]
                                    }
                                }
                            ]
                        }
                    ]
                },
                {
                    label: iget2('b-new-potential-report', 'period', 'Период'),
                    control: {
                        block: 'b-date-range-picker',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'dates'
                        }],
                        start: {
                            value: this.start
                        },
                        finish: {
                            value: this.finish
                        },
                        ranges: [
                            {
                                title: iget2('b-new-potential-report', '7-dney', '7 дней'),
                                start: -8,
                                finish: -1
                            },
                            {
                                title: iget2('b-new-potential-report', '30-dney', '30 дней'),
                                start: -31,
                                finish: -1
                            },
                            {
                                title: iget2('b-new-potential-report', '90-dney', '90 дней'),
                                start: -91,
                                finish: -1
                            }
                        ],
                        dateFormat: 'YYYY-MM-DD'
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'gruppirovat', 'Группировать'),
                    control: {
                        block: 'select',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'date-group'
                        }],
                        content: [
                            {
                                block: 'button',
                                content: iget2('b-new-potential-report', 'po-nedelyam', 'По неделям')
                            },
                            {
                                elem: 'control',
                                content: [
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'day'
                                        },
                                        content: iget2('b-new-potential-report', 'po-dnyam', 'По дням')
                                    },
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'week',
                                            selected: 'selected'
                                        },
                                        content: iget2('b-new-potential-report', 'po-nedelyam', 'По неделям')
                                    },
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'month'
                                        },
                                        content: iget2('b-new-potential-report', 'po-mesyacam', 'По месяцам')
                                    },
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'none'
                                        },
                                        content: iget2('b-new-potential-report', 'za-vsyo-vremya', 'За всё время')
                                    }
                                ]
                            }
                        ]
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'regiony', 'Регионы'),
                    control: {
                        block: 'b-potential-report-region',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'region'
                        }],
                        mods: {
                            'disabled-from-campaign': 'yes'
                        },
                        regionsModelId: '1',
                        url: this.url
                    }
                },
                {
                    label: '&nbsp;',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'geo-stat-flag'
                        }],
                        mods: {
                            checked: 'yes'
                        },
                        text: iget2('b-new-potential-report', 'uchityvat-geotargeting-dlya-statistiki', 'Учитывать геотаргетинг для статистики клиента')
                    }
                },
                {
                    label: '&nbsp;',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'ext-phases-geo'
                        }],
                        text: iget2('b-new-potential-report', 'zadat-region-dlya-rasshirenogo', 'Задать регион для расширеного списка фраз')
                    }
                },
                {
                    label: '&nbsp;',
                    control: {
                        block: 'b-potential-report-region',
                        mods: {
                            disabled: 'yes',
                            'disabled-from-campaign': 'yes'
                        },
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'ext-geo'
                        }],
                        regionsModelId: '2',
                        url: this.url
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'valyuta', 'Валюта'),
                    control: applyCtx({
                        block: 'b-new-potential-report',
                        elem: 'currency'
                    })
                },
                {
                    label: '&nbsp;',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'use-common-minus-words'
                        }],
                        mods: {
                            checked: 'yes'
                        },
                        text: iget2('b-new-potential-report', 'uchityvat-edinye-minus-frazy', 'Учитывать единые минус-фразы на кампанию для медиапланов')
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'operatory', 'Операторы'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'remove-phrases-operators'
                        }],
                        mods: {
                            checked: 'yes'
                        },
                        text: iget2('b-new-potential-report', 'otbrosit-operatory-dlya-spiska', 'Отбросить операторы для списка фраз клиента')
                    }
                },
                {
                    label: '&nbsp;',
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'remove-ext-phrases-operators'
                        }],
                        mods: {
                            checked: 'yes'
                        },
                        text: iget2('b-new-potential-report', 'otbrosit-operatory-dlya-rasshirennogo', 'Отбросить операторы для расширенного списка фраз')
                    }
                },
                {
                    label: iget2('b-new-potential-report', 'advq', 'ADVQ'),
                    control: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-new-potential-report',
                            elem: 'use-turkish-advq'
                        }],
                        text: iget2('b-new-potential-report', 'ispolzovat-bazu-dlya-turcii', 'Использовать базу для Турции')
                    }
                },
                applyCtx({
                    block: 'b-potential-report-region',
                    elem: 'popup'
                })
            ],
            submit: iget2('b-new-potential-report', 'vygruzit-potencial', 'Выгрузить потенциал')
        };
    })
);
