BEM.DOM.decl('b-new-potential-report', {

    DATE_FORMAT: 'YYYY-MM-DD',
    CMD: 'addClientPotentialReport',

    STORE_FLAG: 'b-new-potential-report',

    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                extGeoToggle: 'checkbox on ext-phases-geo',
                extGeoRegion: 'b-potential-report-region on ext-geo',
                clientName: 'input on client-name',
                categoryName: 'input on category-name',
                reportDate: 'b-date-input on report-date',
                dates: 'b-date-range-picker on dates',
                extPhrases: 'input on ext-phrases',
                cids: 'input on cids',
                logins: 'input on logins',
                fetchBy: 'radiobox inside',
                dateGroup: 'select on date-group',
                region: 'b-potential-report-region on region',
                regionExt: 'b-potential-report-region on ext-geo',
                geoStatFlag: 'checkbox on geo-stat-flag',
                currency: 'select on currency',
                useCommonMinusWords: 'checkbox on use-common-minus-words',
                removePhrasesOperators: 'checkbox on remove-phrases-operators',
                removeExtPhrasesOperators: 'checkbox on remove-ext-phrases-operators',
                useTurkishAdvq: 'checkbox on use-turkish-advq',
                submit: 'button inside submit-row'
            });

            this.logins.on('change', this._checkLoginsCids, this);
            this.cids.on('change', this._checkLoginsCids, this);
            this.fetchBy.on('change', this._checkLoginsCids, this);

            this.extGeoToggle.on('change', this._onExtPhasesGeoChange, this);

            this
                .bindTo(this.elem('form'), 'submit', this._onFormSubmit)
                .bindTo(this.elem('copy-last'), 'click', this._onCopyLastClick);

            // если переключаем радиобаттон, то дизейблить другое поле
            this.fetchBy.on('change', this._onFetchByChange, this);

            // регион запрашивает номера кампаний для подбора списка регионов
            this.region.on('request-data', this._onRegionRequestData, this);
            this.regionExt.on('request-data', this._onRegionRequestData, this);

            this._request = BEM.create('i-request_type_ajax', {
                url: this.params.url,
                cache: false,
                type: 'POST',
                dataType: 'json'
            });
        }
    },

    /**
     * Обработчик изменения логинов, номеров кампаний, или типа отправляемых данных
     *   нужен, чтобы правильно дизейблить кнопку у регионов
     * @private
     */
    _checkLoginsCids: function() {
        var fetchBy = this.fetchBy.val(),
            hasLoginsOrCids = !!this._splitUserInput(this[fetchBy].val()).join(',');

        this.regionExt.setMod('disabled-from-campaign', hasLoginsOrCids ? '' : 'yes');
        this.region.setMod('disabled-from-campaign', hasLoginsOrCids ? '' : 'yes');
    },

    /**
     * Обработчик изменения радиобокса логины/кампании
     * @param {Event} event событие изменения
     * @param {Object} event.block блок радиобокса
     */
    _onFetchByChange: function(event) {
        var isLoginsChecked = event.block.val() === 'logins';

        this.logins.setMod('disabled', isLoginsChecked ? '' : 'yes');
        this.cids.setMod('disabled', isLoginsChecked ? 'yes' : '');
    },

    /**
     * Обработчик клика на кнопку "скопировать из предыдущего"
     */
    _onCopyLastClick: function() {
        var data = u.store.get(this.STORE_FLAG);

        if (!data) return;

        this.fillForm(data);
        this.region.restore();
        this.regionExt.restore();
    },

    /**
     * Обработчик отправки формы
     * @param {Event} event событие
     */
    _onFormSubmit: function(event) {
        event.preventDefault();

        var range = this.dates.getRange(),
            fetchBy = this.fetchBy.val(),
            extGeoChecked = this.extGeoToggle.isChecked(),
            data = {
                cmd: this.CMD,
                client_name: this.clientName.val(),
                category_name: this.categoryName.val(),
                report_date: this.reportDate.val(),
                ext_phrases: this.extPhrases.val(),
                date_from: range.start,
                date_to: range.finish,
                date_group: this.dateGroup.val(),
                geo: this.region.getGeo(),
                geo_stat_flag: +this.geoStatFlag.isChecked(),
                ext_phrases_geo_flag: +extGeoChecked,
                use_common_minus_words: +this.useCommonMinusWords.isChecked(),
                remove_phrases_operators: +this.removePhrasesOperators.isChecked(),
                remove_ext_phrases_operators: +this.removeExtPhrasesOperators.isChecked(),
                use_turkish_advq: +this.useTurkishAdvq.isChecked(),
                currency: this.currency.val()
            };

        // Отправляем или номера кампаний или логины
        data[fetchBy] = this._splitUserInput(this[fetchBy].val()).join(',');

        // если стоит галочка "Задать регион для расширенного списка фраз" отправляем дополнительно
        if (extGeoChecked) data.ext_phrases_geo = this.regionExt.getGeo();

        if (!this.validate(data)) return;

        this.submit.setMod('disabled', 'yes');

        // раньше тут был код
        // this._request.get(data, this._onServerSuccess.bind(this, data), this._onServerError.bind(this));
        // Но возникла бага DIRECT-35476
        // из-за того, что в i-request_type_ajax есть конструкция
        // $.extend({}, params.data, request)
        // и слабые компы просто виснут, если передать 3 мегабайта в фразах
        $.ajax({
            type: 'POST',
            data: data,
            error: this._onServerError,
            success: function(res) {
                this._onServerSuccess(data, res);
            },
            context: this
        });
    },

    /**
     * Обработчик ошибки от сервера
     */
    _onServerError: function() {
        BEM.blocks['b-confirm']
            .alert(iget2('b-new-potential-report', 'servernaya-oshibka-povtorite-nemnogo', 'Серверная ошибка, повторите немного позже'));
        this.submit.delMod('disabled');
    },

    /**
     * Обработчик положительного ответа от сервера
     * @param {Object} data данные, отправляемые на сервер, используются для сохранения настроек
     * @param {Object} res ответ от сервера
     * @param {Array} [res.errors] ошибки
     */
    _onServerSuccess: function(data, res) {
        this.submit.delMod('disabled');

        if (res.errors && res.errors.length) {
            BEM.blocks['b-confirm']
                .alert(iget2('b-new-potential-report', 'oshibki', 'Ошибки') + ':<br/><br/>' + res.errors.map(function(err) {
                    return u.escapeHTML(err.slice(0, 1000));
                }).join('<br/>'));

            return;
        }

        this._onReportCreated(data);
    },

    /**
     * Обработчик положительного ответа от сервера
     * @param {Object} data данные формы
     */
    _onReportCreated: function(data) {
        u.store.set(this.STORE_FLAG, data);
        this.region.store();
        this.regionExt.store();

        this.clearForm();

        this.trigger('created-new-report');
    },

    /**
     * Обработчик изменения чекбокса "задать регион для расширенного списка фраз"
     * @param {Event} event событие
     */
    _onExtPhasesGeoChange: function(event) {
        this.extGeoRegion.setMod('disabled', event.block.isChecked() ? '' : 'yes');
    },

    /**
     * Обработчик события запроса номеров кампаний или логинов от региона
     * @param {Event} event событие
     * @param {Object} event.block блок региона
     */
    _onRegionRequestData: function(event) {
        var fetchBy = this.fetchBy.val();

        event.block.setRegionByData(fetchBy, this._splitUserInput(this[fetchBy].val()));
    },

    /**
     * Проверка данных, вернет true если все в порядке
     * @param {Object} data данные
     * @returns {Boolean}
     */
    validate: function(data) {

        var errors = [];

        data.cids || data.logins || data.ext_phrases ||
            errors.push(iget2(
                'b-new-potential-report',
                'zapolnite-hotya-by-odno',
                'Заполните хотя бы одно из полей: "ID кампаний", "Логины", "Расширения"'
            ));

        if (data.use_common_minus_words && !data.cids && !data.logins)
            errors.push(iget2(
                'b-new-potential-report',
                'vvedite-loginy-ili-nomera',
                'Введите логины или номера кампаний, либо снимите галку "учитывать единые минус-фразы"'
            ));

        if (errors.length) {
            BEM.blocks['b-confirm']
                .alert(iget2('b-new-potential-report', 'dlya-otpravki-formy', 'Для отправки формы') + ':<br/><br/>' + errors.join('<br/>'));

        }

        return errors.length === 0;
    },

    /**
     * Форматирует пользовательский ввод, табы, переводы строк и запятые заменяет на запятые
     * @param {String} val пользовательский ввод
     * @returns {String[]}
     */
    _splitUserInput: function(val) {
        return val.split(/\s*[\t\,\n]+\s*/);
    },

    /**
     * Очищает форму
     */
    clearForm: function() {
        this.fillForm({
            client_name: '',
            category_name: '',
            cids: '',
            logins: '',
            report_date: u.moment().format(this.DATE_FORMAT),
            date_from: u.moment().subtract(31, 'day').format(this.DATE_FORMAT),
            date_to: u.moment().subtract(1, 'day').format(this.DATE_FORMAT),
            ext_phrases: '',
            date_group: 'week',
            geo_stat_flag: 1,
            ext_phrases_geo_flag: 0,
            use_common_minus_words: 1,
            remove_phrases_operators: 1,
            remove_ext_phrases_operators: 1,
            useTurkishAdvq: 0,
            currency: 'y.e.'
        });

        this.region.clear();
        this.regionExt.clear();
    },

    /**
     * Заполняет форму указанными данными
     * @param {Object} data данные для заполнения
     */
    fillForm: function(data) {
        this.clientName.val(data.client_name);
        this.categoryName.val(data.category_name);
        this.reportDate.val(data.report_date);
        this.cids.val(data.cids);
        this.logins.val(data.logins);
        this.fetchBy.val(data.logins ? 'logins' : 'cids');
        this.extPhrases.val(data.ext_phrases);
        this.dates.setRange({ start: data.date_from, finish: data.date_to });
        this.dateGroup.val(data.date_group);
        this.currency.val(data.currency);

        this.geoStatFlag.setMod('checked', data.geo_stat_flag ? 'yes' : '');
        this.extGeoToggle.setMod('checked', data.ext_phrases_geo_flag ? 'yes' : '');
        this.useCommonMinusWords.setMod('checked', data.use_common_minus_words ? 'yes' : '');
        this.removePhrasesOperators.setMod('checked', data.remove_phrases_operators ? 'yes' : '');
        this.removeExtPhrasesOperators.setMod('checked', data.remove_ext_phrases_operators ? 'yes' : '');
        this.useTurkishAdvq.setMod('checked', data.use_turkish_advq ? 'yes' : '');
    }

}, {

    live: function() {
        /**
         * Обработчик клика по кнопке очищения формы
         */
        this.liveBindTo('clear', 'click', function() {
            this.clearForm();

            return false;
        });
    }
});
