block('b-new-report-form').elem('period').content()(function() {
    var now = new Date(),
        lastMonthDate = new Date(),
        lastMonthCountDays,
        sevenDaysAgo = new Date(),
        months = [
            iget2('b-new-report-form', 'yanvar', 'январь'),
            iget2('b-new-report-form', 'fevral', 'февраль'),
            iget2('b-new-report-form', 'mart', 'март'),
            iget2('b-new-report-form', 'aprel', 'апрель'),
            iget2('b-new-report-form', 'may', 'май'),
            iget2('b-new-report-form', 'iyun', 'июнь'),
            iget2('b-new-report-form', 'iyul', 'июль'),
            iget2('b-new-report-form', 'avgust', 'август'),
            iget2('b-new-report-form', 'sentyabr', 'сентябрь'),
            iget2('b-new-report-form', 'oktyabr', 'октябрь'),
            iget2('b-new-report-form', 'noyabr', 'ноябрь'),
            iget2('b-new-report-form', 'dekabr', 'декабрь')
        ],
        formatDate = function(date) {
            var month = date.getMonth() + 1,
                day = date.getDate();

            return (date.getYear() + 1900) + '-' +
                (month < 10 ? '0' + month : month) + '-' + (day < 10 ? '0' + day : day);
        };

    lastMonthDate.setMonth(now.getMonth() - 1);
    lastMonthCountDays = (new Date(lastMonthDate.getYear(), lastMonthDate.getMonth() + 1, 0)).getDate();
    sevenDaysAgo.setDate(now.getDate() - 7);

    return [
        {
            block: 'radiobox',
            value: 'custom',
            mix: [{
                block: 'b-new-report-form',
                elem: 'period-type'
            }],
            content: [
                {
                    elem: 'radio',
                    mix: [{
                        block: 'b-new-report-form',
                        elem: 'all-periods-radio'
                    }],
                    controlAttrs: { value: 'all' },
                    content: iget2('b-new-report-form', 's-nachala-kampanii', 'с начала кампании')
                },
                {
                    block: 'b-new-report-form',
                    elem: 'period-picker-wrap',
                    content: [
                        {
                            block: 'radiobox',
                            elem: 'radio',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'period-picker-radio'
                            }],
                            controlAttrs: { value: 'custom' },
                            content: iget2('b-new-report-form', 'za', 'за')
                        },
                        {
                            block: 'b-date-range-picker',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'period-picker'
                            }],
                            start: {
                                value: formatDate(sevenDaysAgo),
                                limits: { earlier: '2000-01-01' }
                            },
                            finish: {
                                value: formatDate(now),
                                limits: { earlier: '2000-01-01' }
                            },
                            ranges: [
                                {
                                    title: iget2('b-new-report-form', '7-dney', '7 дней'),
                                    start: -7,
                                    finish: 0
                                },
                                {
                                    title: iget2('b-new-report-form', '30-dney', '30 дней'),
                                    start: -30,
                                    finish: 0
                                },
                                // отчет за предыдущий месяц
                                {
                                    title: months[lastMonthDate.getMonth()] + ' ' + (lastMonthDate.getYear() + 1900),
                                    start: -(lastMonthCountDays + now.getDate() - 1),
                                    finish: -now.getDate()
                                }
                            ],
                            dateFormat: 'YYYY-MM-DD',
                            viewFormat: 'DD MMM YYYY'
                        }
                    ]
                }
            ]
        },
        {
            elem: 'period-comment',
            content: iget2('b-new-report-form', 'dannye-za-segodnyashniy-den', 'данные за сегодняшний день могут быть неполными')
        }
    ];
});
