/**
 * @typedef {Object} ReportFormCampaign кампания в форме заявки на оффлайновый отчет статистики
 * @property {String} cid идентификатор кампании
 * @property {String} title заголовок кампании
 * @property {String} total потрачено на кампанию, с указанием валюты
 * @property {Boolean} isActive активна ли кампания
 * @property {String} type тип кампании (текстовый, динамический, ...)
 * @property {String} startDate дата создания кампании
 */

/**
 * @typedef {Object} Goal кампания в форме заявки на оффлайновый отчет статистики
 * @property {String} goal_id идентификатор цели
 * @property {String} name имя цели
 */

/**
 * @param {ReportFormCampaign[]} this.ctx.camps
 * @param {Boolean} this.ctx.isSupport отображать ли в виде для суппортов
 * @param {String} this.ctx.url url контроллера
 * @param {String} this.ctx.ulogin логин владельца кампаний
 * @param {Boolean} this.ctx.isSuper отображать ли в виде для суперов
 * @param {Goal[]} this.ctx.goalsList список целей
 */
block('b-new-report-form')(

    js()(function() {
        return {
            ulogin: this.ctx.ulogin,
            url: this.ctx.url
        };
    }),

    def().match(function() {
        return this.ctx.isSupport;
    })(function() {
        return applyNext({
            'mods.type': 'bm'
        });
    }),

    content()(function() {
        var hasDynamic = this.ctx.camps.some(function(camp) { return camp.type == 'dynamic'; }),
            hasPerformance = this.ctx.camps.some(function(camp) { return camp.type == 'performance'; }),
            hasVideoAddons = !!this.ctx.features.video_report,
            goalsList = this.ctx.goalsList,
            isPostviewConversionsReportEnabled = u.consts('isPostviewConversionsReportEnabled') &&
                this.ctx.camps.some(function(camp) { return Boolean(+camp.isAvailableForPostview); }),
            hasManyReportTypes = hasDynamic || hasPerformance || hasVideoAddons || isPostviewConversionsReportEnabled,
            isSuperReaderControl = this.ctx.isSuperReaderControl;

        return {
            block: 'b-layout-table',
            mix: [{
                block: 'b-new-report-form',
                elem: 'layout'
            }],
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'tip-otcheta', 'Тип отчета') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: {
                                block: 'radiobox',
                                name: 'type',
                                value: this.ctx.isSupport ? 'bm' : 'pdf',
                                mix: [{
                                    block: 'b-new-report-form',
                                    elem: 'report-type'
                                }],
                                content: [
                                    {
                                        elem: 'radio',
                                        elemMods: { disabled: this.ctx.isSupport ? 'yes' : '' },
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio',
                                            elemMods: { 'has-bullet': hasManyReportTypes ? 'yes' : 'no' }
                                        }],
                                        content: iget2('b-new-report-form', 'obshchiy-otchet-po-kampaniyam', 'Общий отчет по кампаниям (.pdf)'),
                                        controlAttrs: { value: 'pdf' }
                                    },
                                    isPostviewConversionsReportEnabled && {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio'
                                        }],
                                        content: iget2('b-new-report-form', 'postview-conversions-report', 'Отчет по поствью-конверсиям (.xls/xlsx)'),
                                        controlAttrs: { value: 'postview' }
                                    },
                                    hasDynamic && {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio'
                                        }],
                                        content: iget2('b-new-report-form', 'dinamicheskie-obyavleniya-xls-xlsx', 'Динамические объявления (.xls/xlsx)'),
                                        controlAttrs: { value: 'dynamic' }
                                    },
                                    hasPerformance && {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio'
                                        }],
                                        content: iget2('b-new-report-form', 'smart-bannery-xls-xlsx', 'Смарт-баннеры (.xls/xlsx)'),
                                        controlAttrs: { value: 'performance' }
                                    },
                                    hasVideoAddons && {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio'
                                        }],
                                        content: iget2('b-new-report-form', 'video-postclick-addons', 'Видеодополнения (постклик)'),
                                        controlAttrs: { value: 'video' }
                                    },
                                    hasVideoAddons && {
                                        elem: 'radio',
                                        mix: [{
                                            block: 'b-new-report-form',
                                            elem: 'report-type-radio'
                                        }],
                                        content: iget2('b-new-report-form', 'video-postview-addons', 'Видеодополнения (поствью)'),
                                        controlAttrs: { value: 'videoPostview' }
                                    }
                                ]
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [{
                        block: 'b-new-report-form',
                        elem: 'params-row'
                    }],
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'kampaniya', 'Кампания') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: this.ctx.camps && this.ctx.camps.length ?
                                {
                                    block: 'b-checklist',
                                    mods: { mode: (this.mods.type === 'bm' || this.ctx.camps.length === 1) ? 'single' :
                                        'multi' },
                                    mix: [{
                                        block: 'b-new-report-form',
                                        elem: 'campaigns',
                                        elemMods: { many: this.ctx.camps.length > 1 && hasManyReportTypes ? 'yes' : '' }
                                    }],
                                    items: this.ctx.camps.map(function(el) {
                                        var filters = [el.type];

                                        if (el.isAvailableForPostview) {
                                            filters.push('postview');
                                        }

                                        return {
                                            id: el.cid,
                                            title: el.title,
                                            type: el.type,
                                            isActive: true,
                                            filters: filters
                                        };
                                    }),
                                    searchPlaceholder: iget2('b-new-report-form', 'nayti-kampaniyu', 'Найти кампанию')
                                } :
                                iget2('b-new-report-form', 'u-vas-net-ni', 'У вас нет ни одной кампании')
                        }
                    ]
                },
                this.ctx.isSuper && {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'categories-row'
                        }
                    ],
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'kategorii-i-proizvoditeli', 'Категории и производители') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: [
                                {
                                    block: 'b-new-report-form',
                                    elem: 'add-categories-container',
                                    content: {
                                        block: 'checkbox',
                                        mix: [{ block: 'b-new-report-form', elem: 'add-categories' }],
                                        checkboxAttrs: { value: '1', name: 'add_categories' },
                                        text: iget2('b-new-report-form', 'dobavit-informaciyu-o-kategoriyah', 'Добавить информацию о категориях')
                                    }
                                },
                                {
                                    block: 'b-new-report-form',
                                    elem: 'add-vednor-container',
                                    content: {
                                        block: 'checkbox',
                                        mix: [{ block: 'b-new-report-form', elem: 'add-vendor' }],
                                        checkboxAttrs: { value: '1', name: 'add_vendor' },
                                        text: iget2('b-new-report-form', 'dobavit-informaciyu-o-proizvoditelyah', 'Добавить информацию о производителях')
                                    }

                                }
                            ]
                        }
                    ]
                },
                hasVideoAddons && {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'metric-goal-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'video-addition-row',
                            elemMods: { hidden: 'yes' }
                        }
                    ],
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'metric-goal', 'Цель метрики') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: goalsList.length ?
                                {
                                    block: 'b-checklist',
                                    mods: { mode: 'multi' },
                                    mix: [{
                                        block: 'b-new-report-form',
                                        elem: 'metric-goal',
                                        elemMods: { many: goalsList.length > 1 ? 'yes' : '' }
                                    }],
                                    items: goalsList.map(function(el) {
                                        return {
                                            id: el.goal_id,
                                            title: el.name,
                                            isActive: true
                                        };
                                    }),
                                    searchPlaceholder: iget2('b-new-report-form', 'nayti-tzel', 'Найти цель')
                                } :
                                iget2('b-new-report-form', 'u-vas-net-ni-tzel', 'У вас нет ни одной цели')
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [{
                        block: 'b-new-report-form',
                        elem: 'params-row'
                    }],
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'otchetnyy-period', 'Отчетный период') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: {
                                block: 'b-new-report-form',
                                elem: 'period'
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'grouping-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'no-video-addition-row',
                            elemMods: { hidden: 'yes' }
                        }
                    ],
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'label'
                            }],
                            content: iget2('b-new-report-form', 'gruppirovka', 'Группировка') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: {
                                block: 'select',
                                mix: [{
                                    block: 'b-new-report-form',
                                    elem: 'grouping'
                                }],
                                name: 'grouping',
                                content: [
                                    {
                                        block: 'button',
                                        content: iget2('b-new-report-form', 'po-dnyam', 'По дням')
                                    },
                                    {
                                        elem: 'control',
                                        content: [
                                            {
                                                elem: 'option',
                                                attrs: {
                                                    value: 'day',
                                                    selected: 'selected'
                                                },
                                                content: iget2('b-new-report-form', 'po-dnyam', 'По дням')
                                            },
                                            {
                                                elem: 'option',
                                                attrs: { value: 'week' },
                                                content: iget2('b-new-report-form', 'po-nedelyam', 'По неделям')
                                            },
                                            {
                                                elem: 'option',
                                                attrs: { value: 'month' },
                                                content: iget2('b-new-report-form', 'po-mesyacam', 'По месяцам')
                                            },
                                            {
                                                elem: 'option',
                                                attrs: { value: 'year' },
                                                content: iget2('b-new-report-form', 'po-godam', 'По годам')
                                            }
                                        ]
                                    }
                                ]
                            }
                        }
                    ]
                },
                hasVideoAddons && {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'grouping-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'video-addition-row',
                            elemMods: { hidden: 'yes' }
                        }
                    ],
                    content: [
                        {
                            elem: 'cell',
                            mix: [
                                {
                                    block: 'b-new-report-form',
                                    elem: 'label'
                                },
                                {
                                    block: 'b-new-report-form',
                                    elem: 'label-group-banners'
                                },
                            ],
                            content: iget2('b-new-report-form', 'group-banners', 'Группировка<br/>по баннерам') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'control'
                            }],
                            content: {
                                block: 'tumbler',
                                name: 'grouping',
                                mods: {
                                    size: 's'
                                },
                                mix: { block: 'b-new-report-form', elem: 'grouping' },
                                leftText: iget2('b-new-report-form', 'Yes', 'Вкл'),
                                rightText: iget2('b-new-report-form', 'No', 'Выкл')
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'warning-row'
                        }
                    ],
                    content: [
                        { elem: 'cell' },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'warning'
                            }],
                            content: iget2(
                                'b-new-report-form',
                                'vremya-sozdaniya-otcheta-zavisit',
                                'Время создания отчета зависит от размера кампании и обычно составляет от 5 минут до часа.'
                            )
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'post-view-disabled-warning-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'warning-row'
                        }
                    ],
                    content: [
                        { elem: 'cell' },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'warning'
                            }],
                            content: iget2(
                                'b-new-report-form',
                                'post-view-disabled-warning-row',
                                'Запрошено максимальное количество отчетов по поствью-конверсиям. Пожалуйста, дождитесь готовности ранее запрошенных отчетов перед запросом следующих.'
                            )
                        }
                    ]
                },
                {
                    elem: 'row',
                    mix: [
                        {
                            block: 'b-new-report-form',
                            elem: 'params-row'
                        },
                        {
                            block: 'b-new-report-form',
                            elem: 'errors-row'
                        }
                    ],
                    content: [
                        { elem: 'cell' },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'errors'
                            }],
                            content: {
                                block: 'b-new-report-form',
                                elem: 'errors-list',
                                tag: 'ul'
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'submit-panel'
                            }]
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-new-report-form',
                                elem: 'submit-panel'
                            }],
                            content: {
                                block: 'button',
                                mods: {
                                    disabled: this.ctx.camps &&
                                                  this.ctx.camps.length &&
                                                  !isSuperReaderControl ? '' : 'yes',
                                    theme: 'action'
                                },
                                mix: [{
                                    block: 'b-new-report-form',
                                    elem: 'submit'
                                }],
                                content: iget2('b-new-report-form', 'zakazat-otchet', 'Заказать отчет')
                            }
                        }
                    ]
                }
            ]
        };
    })
);
