BEM.DOM.decl('b-new-report-form', {
    /**
     * @property {String} формат даты в данных кампании и в запросах
     */
    _dateFormat: 'YYYY-MM-DD',

    /**
     * @property {Object} отношение тип отчета - режим работы формы
     */
    _reportTypeToMode: {
        pdf: 'multi',
        bm: 'single',
        dynamic: 'multi',
        performance: 'multi',
        video: 'multi',
        videoPostview: 'multi',
        postview: 'multi',
    },

    /**
     * @property {Object} отношение тип отчета - значение фильтра
     */
    _reportTypeToFilterType: {
        pdf: undefined, //pdf - общий отчет, отключаем для него фильтр
        bm: 'text',
        dynamic: 'dynamic',
        performance: 'performance',
        video: undefined,
        videoPostview: undefined,
        postview: 'postview',
    },

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                submit: 'button on submit',
                reportType: 'radiobox on report-type',
                grouping: '? select on grouping',
                groupingBanner: '? tumbler on grouping',
                addCategories: '? checkbox on add-categories',
                addVendor: '? checkbox on add-vendor',
                periodType: 'radiobox on period-type',
                periodPicker: 'b-date-range-picker on period-picker',
                errors: 'errors-row',
                campaigns: '? b-checklist on campaigns', // отсутствует, если нет кампаний
                _metricGoal: '? b-checklist on metric-goal', // отсутствует, если нет целей
            });

            this._request = BEM.create('i-request_type_ajax', {
                url: this.params.url,
                cache: false,
                type: 'POST',
                dataType: 'json'
            });

            this.reportType
                .on('change', function(e) {
                    var video = ['video', 'videoPostview'],
                        value = e.block.val(), // pdf bm dynamic performance video postview
                        startDate = new Date('2000-01-01'),
                        startDateForVideoAdditrion = new Date('2018-03-31'),
                        isVideoAdditionsSelected = video.indexOf(value) !== -1,
                        isVideoAdditionRowsHidden = true;

                    this.setMod('type', value);

                    if (isVideoAdditionsSelected) {
                        isVideoAdditionRowsHidden = false;
                        startDate = startDateForVideoAdditrion;
                    }

                    this.setMod(this.elem('video-addition-row'), 'hidden', isVideoAdditionRowsHidden ? 'yes' : '');
                    this.setMod(this.elem('no-video-addition-row'), 'hidden', isVideoAdditionRowsHidden ? '' : 'yes');

                    this.periodPicker.setRangeLimits({
                        start: { earlier: startDate }
                    });

                    if (value === 'postview') {
                        this.periodType.val('custom');
                    }
                }, this)
                .trigger('change');

            this.submit.on('click', this._onSubmit, this);
        },

        type: function(mod, val) {
            this.reportType.val(val);

            if (this.addCategories && this.addVendor) {
                this.addCategories.setMod('disabled', val == 'performance' ? '' : 'yes');
                this.addVendor.setMod('disabled', val == 'performance' ? '' : 'yes');
            }

            if (this.campaigns) {
                this.campaigns.setMod('mode', this.campaigns.isOnlyOneItem() ? 'single' :
                    this._reportTypeToMode[val]);
                this.campaigns.setItemTypeForFilter(this._reportTypeToFilterType[val]);
            }
        }
    },

    /**
     * Возвращает тип группировки по типу отчета
     * @param {String} reportType
     * @returns {String}
     */
    _getGroupingType: function(reportType) {
        var grouping = this.grouping.val(),
            groupingBanner = this.groupingBanner && this.groupingBanner.val(),
            typeToGrouping = {
                pdf: grouping,
                dynamic: grouping,
                performance: grouping,
                video: groupingBanner === 'true' ? 'banner' : '',
                videoPostview: groupingBanner === 'true' ? 'banner' : '',
                bm: '',
                postview: ''
            };

        return typeToGrouping[reportType];
    },

    /**
     * Говорит, есть ли среди переданных кампаний начатые раньше, чем переданная дата
     * @param {ReportFormCampaign[]} campaigns
     * @param {u.moment} date
     * @returns {Boolean}
     */
    _isAnyCampaignIsOlderThan: function(campaigns, date) {
        return campaigns.some(function(campaign) {
            return u.moment(campaign.startDate, this._dateFormat).isBefore(date);
        }, this);
    },

    _getVideoSubmitData: function() {
        var reportType = this.reportType.val(),
            videoSubmitData = {};

        if (['video', 'videoPostview'].indexOf(reportType) === -1) {
            return videoSubmitData;
        }

        return {
            type: 'video',
            goals: this._metricGoal ? this._metricGoal.getSelected().join(',') : '',
            report_type: reportType === 'video' ? 'postclick' : 'postview'
        };
    },

    /**
     * Обработчик submit формы
     */
    _onSubmit: function() {
        if (!this.campaigns) return;

        var campaignsObjects = this.campaigns.getSelectedItems(),
            campaignsIds = this.campaigns.getSelected();

        if (!campaignsIds.length) {
            alert(iget2('b-new-report-form', 'vyberite-kampanii', 'Выберите кампании'));

            return;
        }

        var type = this.getMod('type') || 'pdf',
            periodRange = this.periodPicker.getRange(),
            isCustomPeriod = this.periodType.val() === 'custom',
            reportTimeMargin = u.moment().subtract(3, 'months').startOf('day'), //дата - граница допустимого периода заказа отчета
            aC = this.addCategories,
            aV = this.addVendor,
            data = u._.extend({
                cmd: 'addPdfReport',
                ulogin: this.params.ulogin,
                cids: campaignsIds.join(','),
                grouping: this._getGroupingType(type),
                type: type,
                add_categories: +!!(aC && aC.getMod('disabled') != 'yes' && aC.isChecked()), // обязательны 0 / 1
                add_vendor: +!!(aV && aV.getMod('disabled') != 'yes' && aV.isChecked()),
                date_from: isCustomPeriod ? periodRange.start : '',
                date_to: isCustomPeriod ? periodRange.finish : '',
            }, this._getVideoSubmitData()),
            typeToMessage = {
                dynamic: iget2(
                    'b-new-report-form',
                    'otchet-po-dinamicheskim-obyavleniyam',
                    'Отчет по динамическим объявлениям доступен только за 3 месяца, пожалуйста, измените отчетный период'
                ),
                performance: iget2(
                    'b-new-report-form',
                    'otchet-po-smart-banneram',
                    'Отчет по смарт-баннерам доступен только за 3 месяца, пожалуйста, измените отчетный период'
                )
            },
            haveOldCampaignInSelectedPeriod = isCustomPeriod ?
                u.moment(periodRange.start, this._dateFormat).isBefore(reportTimeMargin) :
                this._isAnyCampaignIsOlderThan(campaignsObjects, reportTimeMargin);

        if (haveOldCampaignInSelectedPeriod && typeToMessage[type]) {
            BEM.blocks['b-confirm'].alert(typeToMessage[type]);

            return;
        }

        this.submit.setMod('disabled', 'yes');
        this.delMod(this.errors, 'show');

        this._request.get(
            data,
            function(res) {
                this.submit.setMod('disabled', '');

                if (res.ok) {
                    this.trigger('created-new-report');

                } else if (res.errors) {
                    this._showErrors(res.errors);
                }
            },
            { callbackCtx: this });
    },

    /**
     * Отображает список ошибок
     * @param {Array} errors
     * @private
     */
    _showErrors: function(errors) {
        BEM.DOM.update(this.elem('errors-list'), BEMHTML.apply(
            errors.map(function(error) {

                return {
                    block: 'b-new-report-form',
                    elem: 'error',
                    tag: 'li',
                    content: error
                };
            })));

        this.setMod(this.errors, 'show', 'yes');
    }
});
