BEM.DOM.decl('b-new-show-camps-warning', {
    onSetMod: {

        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._noticeBlock = this.findBlockInside('b-notice');

            this._subscriptionManager.on(this.findBlockOn('close-button', 'button'), 'click', this._close, this);
            this._subscriptionManager.on(this._noticeBlock, 'close', this._onClose, this);
        }
    },

    /**
    * Удаляет блок и подписки на события
    */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
    * Скрывает панель предупреждения
    */
    _close: function() {
        BEM.blocks['i-switch-to-dna'].doSwitch(true);
    },

    /**
    * Обработчик события закрытия панели предупреждения
    */
    _onClose: function() {
        $.cookie('hide_new_show_camps_warning', 1, { path: '/', expires: 365 * 100 });
    }
});
