block('b-news')(

    def()(function() {
        // в случае отсутствия новостей блок не показываем
        return this.ctx.news ? applyNext() : '';
    }),

    content()(function() {
        var theme = (this.ctx.mods || {}).theme;

        return [
            {
                elem: 'title',
                tag: 'h2',
                content: [
                    iget2('b-news', 'novosti', 'Новости'),
                    {
                        block: 'link',
                        mods: { theme: theme },
                        mix: [{
                            block: 'b-news',
                            elem: 'rss'
                        }],
                        url: this.ctx.links.rss,
                        content: {
                            elem: 'rss-icon',
                            tag: 'img',
                            attrs: {
                                src: '/data3/desktop.blocks/b-news/__rss/b-news__rss.gif',
                                width: '18px',
                                height: '13px'
                            }
                        }
                    }
                ]
            },
            {
                elem: 'list',
                tag: 'ul',
                content: this.ctx.news.map(function(news) {

                    return {
                        elem: 'item',
                        tag: 'li',
                        content: [
                            {
                                elem: 'item-date',
                                content: news.date
                            },
                            {
                                elem: 'item-text',
                                theme: theme,
                                content: news.content
                            }
                        ]
                    };
                })
            },
            {
                elem: 'archive',
                theme: theme,
                url: this.ctx.links.archive,
                text: iget2('b-news', 'arhiv-novostey', 'Архив новостей')
            }
        ];
    }),

    elem('item-text').content()(function() {

        return this.ctx.content.map(function(cnt) {
            return cnt.link_url ?
                {
                    block: 'link',
                    mods: { theme: this.ctx.theme },
                    url: cnt.link_url,
                    content: cnt.text
                } :
                cnt.text;
        }, this);
    }),

    elem('archive').replace()(function() {
        return {
            block: 'link',
            mods: { theme: this.ctx.theme },
            mix: [
                {
                    block: 'b-metrika',
                    js: {
                        goal: 'NEWS_ARCHIVE',
                        counter: '34'
                    }
                },
                {
                    block: 'b-metrika',
                    js: {
                        goal: 'NEWS_ARCHIVE',
                        counter: '191494'
                    }
                },
                {
                    block: 'b-news',
                    elem: 'archive'
                }
            ],
            url: this.ctx.url,
            content: this.ctx.text
        }
    })
);
