(function(ctx) {

    var salt = function(key) {
        return key + '~' + u.consts('uid') + ':' + u.consts('ulogin');
    };

    u.register({

        'b-notice-tooltip': {
            /**
             * Возвращает показатель выставленной куки, блокирующей показ
             * @param {String} key
             * @returns {Boolean}
             */
            hasCookie: function(key) {
                if (!key) return false;

                var cookies = u._.get(ctx, 'data.COOKIES');

                key = salt(key);

                return (cookies ? cookies[key] : $.cookie(key)) == 1;
            },
            /**
             * Выставляет блокирующую показ куку
             * @param {String} key
             * @param {Number} [expires]
             */
            setCookie: function(key, expires) {
                // кука на 100 лет
                $.cookie(salt(key), 1, { expires: expires || 100 * 365 });
            }
        }
    });

})(this);
