/**
 * @param {Object} params объект с параметрами для генерации ссылки на оферту
 * @param {String} params.source тип оферты (обычная, АПИ, девелоперское API)
 * @param {String} params.yandexDomain текущий домен
 * @param {Number} [params.firmId] ID фирмы, в которую платит клиент
 *                  (если оно есть, то ссылка на оферту вычисляется по нему, игнорируя домен)
 */
block('b-oferta-accept')(
    js()(true),

    content()(function() {
        return {
            elem: 'oferta-content',
            params: this.ctx.params,
            acceptRadioName: this.ctx.acceptRadioName
        };
    }),

    elem('oferta-content').content()(function() {
        return [
            {
                block: 'b-iframe',
                mix: [{
                    block: 'b-oferta-accept',
                    elem: 'iframe'
                }],
                src: u['i-oferta'].getOfertaUrl(u._.extend(this.ctx.params || {}, {
                    query: { format: 'html' }
                }))
            },
            {
                block: 'radiobox',
                mix: [{
                    block: 'b-oferta-accept',
                    elem: 'radiobox'
                }],
                name: this.ctx.acceptRadioName || 'oferta',
                value: 'reject',
                content: [
                    {
                        elem: 'radio',
                        content: iget2('b-oferta-accept', 'soglasen', 'Согласен'),
                        controlAttrs: { value: 'accept' }
                    },
                    '&nbsp;&nbsp;',
                    {
                        elem: 'radio',
                        content: iget2('b-oferta-accept', 'ne-soglasen', 'Не согласен'),
                        controlAttrs: { value: 'reject' }
                    }
                ]
            },
            {
                block: 'b-modal-popup-opener',
                mix: [{
                    block: 'b-oferta-accept',
                    elem: 'help'
                }],
                url: u['i-oferta'].getOfertaUrl(this.ctx.params),
                text: iget2('b-oferta-accept', 'otkryt-ofertu-v-novom', 'Открыть оферту в новом окне'),
                useNativeWindow: true,
                windowParams: {
                    width: 1024,
                    height: 600
                }
            }
        ];
    })
);
