block('b-office-contacts')(
    elem('contacts-data').def()(function() {
        var data = applyCtx({ block: 'i-office-contacts' });

        var officeCity = u.getOfficeCityFromData(this.data);

        return {
            officeCity: officeCity,
            office: data.offices[officeCity]
        };
    }),

    elem('contacts-list').def()(function() {
        var data = applyCtx({
                block: 'b-office-contacts',
                elem: 'contacts-data'
            }),
            office = data.office,
            contacts;

        ['client', 'support'].forEach(function(v) {
            office[v] || (office[v] = {});
        });

        // // DIRECT-60696 Эксперимент с мордами Директа
        // if (+this.data.variant > 0) {
        //     office.client.landline = [];
        //     office.client.regional = [];
        //     office.support.landline = [];
        //     office.support.regional = [
        //         [
        //             '8 800 234-63-17',
        //             0,
        //             iget2(
        //                 'b-office-contacts',
        //                 'otdel-klientskogo-servisa-zvonok',
        //                 'отдел клиентского сервиса, звонок из регионов России бесплатный'
        //             )
        //         ]
        //     ];
        // }

        contacts = []
            .concat(office.client.landline || [])
            .concat(office.client.regional || [])
            .concat(office.support.landline || [])
            .concat(office.support.regional || []);

        return contacts;
    })
);
