BEM.DOM.decl({ name: 'b-offline-set-phrases-prices', modName: 'type', modVal: 'content-promotion' }, {

    /**
     * Обновляет конструктор цен в соответсвии с новыми данными
     * @param {Object} data
     * @override
     */
    _updatePricesConstructorHtml: function(data) {
        var strategy = this._getCampaignModel().get('strategy');

        BEM.DOM.update(
            this.elem('constructor-wrapper'),
            BEMHTML.apply(this._getConstructorJSON(strategy, 'simple', data))
        );
    },

    /**
     * Преобразует данные в значения, которые понимает сервер при сохранении
     * @param {Object} [strategy]
     * @param {'simple'|'wizard'} [activeTab]
     * @param {Object} value
     * @override
     * @returns {Object}
     */
    convertToServerFormat: function(strategy, activeTab, value) {
        return {
            tab_simple: 1,
            simple_platform: 'search',
            simple_price: value['price_' + value.platform]
        };
    },

    /**
     * Возвращает bemjson элемента конструктора c заданным type
     * @param {Object} strategy
     * @param {'simple'|'wizard'} type
     * @param {Object} data
     * @returns {Array}
     * @override
     */
    _getConstructorJSON: function(strategy, type, data) {

        return [this._getConstructorJSONForm(type, 'search', data)];
    },

    /**
     * Фильтрует данные, уходящие на сохранение
     * @param {Object} data
     * @param {Object} [strategy]
     * @param {String} [activeTab]
     * @param {'client'|'server'} filterType
     * @override
     * @returns {Object}
     */
    filterData: function(data, strategy, activeTab, filterType) {
        return u._.pick(data, ({
            client: ['price_search'],
            server: ['tab_simple', 'simple_platform', 'simple_price']
        })[filterType] || []);
    }
});
