BEM.DOM.decl({ name: 'b-offline-set-phrases-prices', modName: 'type', modVal: 'dynamic-groups' }, {
    /**
     * Открываем попап
     * @returns {BEM}
     */
    _openPopup: function() {
        var content = this._content;

        this.delMod(content, 'success');
        this.setMod(content, 'disabled', this._getCampaignModel().get('nobsdata') ? 'yes' : '');

        this._saveButton.delMod('disabled').delMod('focused');

        this.setMod(content, 'tab', this._activeTab);

        this.afterCurrentEvent(function() {
            this._getPopup().show(this.currentBtn);
            this._popupRepaint();
        });

        return this;
    },

    /**
     * Обновляет конструктор цен в соответсвии с новыми данными
     * @param {Object} data
     * @override
     */
    _updatePricesConstructorHtml: function(data) {
        var strategy = this._getCampaignModel().get('strategy');

        BEM.DOM.update(
            this.elem('constructor-wrapper'),
            BEMHTML.apply(this._getConstructorJSON(strategy, 'simple', data))
        );
    }
});
