BEM.DOM.decl({ name: 'b-offline-set-phrases-prices', modName: 'type', modVal: 'mcbanner' }, {
    /**
     * Преобразует данные в значения, которые понимает сервер при сохранении
     * @param {Object} [strategy]
     * @param {'simple'|'wizard'} [activeTab]
     * @param {Object} value
     * @override
     * @returns {Object}
     */
    convertToServerFormat: function(strategy, activeTab, value) {
        var result = this.__base.apply(this, arguments);

        if (activeTab !== 'simple') {
            result.wizard_search_price_base = value.price_base_search;
            result.search_proc_base = value.proc_base_search;
        }

        return result;
    },

    /**
     * Фильтрует данные, уходящие на сохранение
     * @param {Object} data
     * @param {Object} [strategy]
     * @param {String} [activeTab]
     * @param {'client'|'server'} filterType
     * @override
     * @returns {Object}
     */
    filterData: function(data, strategy, activeTab, filterType) {
        return u._.pick(data, ({
            client: {
                'common-simple': ['price_context', 'price_search', 'platform', 'is_simple'],
                'common-wizard': ['price_context', 'price_search', 'platform', 'is_simple', 'context_scope', 'proc_search', 'price_base_search', 'proc_base_search']
            },
            server: {
                'common-simple': ['tab_simple', 'simple_platform', 'simple_price'],
                'common-wizard': [
                    'tab_simple', 'wizard_search_phrases', 'wizard_network_scope', 'wizard_context_retargetings',
                    'wizard_context_phrases', 'wizard_platform', 'wizard_search_proc',
                    'wizard_search_max_price', 'wizard_network_max_price'
                ]
            }
        })[filterType]['common-' + activeTab] || []);
    }
});
