BEM.DOM.decl({ name: 'b-offline-set-phrases-prices', modName: 'type', modVal: 'performance' }, {

    /**
     * Открывает попап
     * @override
     * @returns {BEM}
     */
    _openPopup: function() {
        var content = this._content;

        this.delMod(content, 'success');
        this.setMod(content, 'disabled', this._getCampaignModel().get('nobsdata') ? 'yes' : '');

        this._saveButton.delMod('disabled').delMod('focused');

        this.afterCurrentEvent(function() {
            this._getPopup().show(this.currentBtn);
            this._popupRepaint();
        });

        return this;
    },

    /**
     * Обработчик события загрузки новой информации для страницы кампании
     * @param {Object} data
     * @override
     * @returns {BEM}
     */
    _onNewDataLoaded: function(data) {
        this._title.text(this._getTitleText());

        BEM.DOM.update(this.elem('constructor-wrapper'), BEMHTML.apply((function(data) {
            var campModel = this._getCampaignModel(),
                currency = campModel.get('currency'),
                strategy = campModel.get('strategy'),
                cid = campModel.get('cid');

            return {
                block: 'b-prices-constructor',
                mods: {
                    type: 'performance',
                    performance: ({
                        autobudget_avg_cpc_per_camp: 'avg-cpc',
                        autobudget_avg_cpc_per_filter: 'avg-cpc',
                        autobudget_avg_cpa_per_camp: 'avg-cpa',
                        autobudget_avg_cpa_per_filter: 'avg-cpa'
                    })[strategy.name || strategy.net.name]
                },
                mix: {
                    block: 'b-offline-set-phrases-prices',
                    elem: 'constructor-item'
                },
                modelParams: {
                    id: cid,
                    parentName: campModel.name,
                    parentId: cid
                },
                savedData: data,
                strategy: strategy,
                currency: currency,
                currencyName: u.currencies.getName(currency),
                minPay: u.currencies.getConst(currency, 'BIG_RATE'),
                viewMode: 'offline'
            };
        }).call(this, data)));

        this._pricesConstructor = this.findBlockInside(this._content, 'b-prices-constructor');

        this._bindConstructorEvents({ isBind: true });

        //если текущие данные на текущем состоянии конструктора оказались не валидными - откатываем на дефолтные
        if (this._pricesConstructor && !this._pricesConstructor.validate().valid) {
            this._pricesConstructor.setDefault();
        }

        return this._openPopup();
    },

    /**
     * Проверяет пришли ли данные в формате, в котором хранятся на сервере
     * @param {Object} data
     * @override
     * @returns {Boolean}
     */
    _isServerFormat: function(data) {
        return data.hasOwnProperty('simple_price_CPA') || data.hasOwnProperty('simple_price_CPA');
    },

    /**
     * Фильтрует данные, уходящие на сохранение
     * @param {Object} data
     * @param {Object} [strategy]
     * @param {String} [activeTab]
     * @param {'client'|'server'} filterType
     * @override
     * @returns {Object}
     */
    filterData: function(data, strategy, activeTab, filterType) {
        return u._.pick(data, ({
            client: ['price_performance', 'performance_type'],
            server: ['simple_price_CPC', 'simple_price_CPA', 'tab_simple']
        })[filterType] || []);
    },

    /**
     * Преобразует данные в значения, которые понимает сервер при сохранении
     * @param {Object} [strategy]
     * @param {'simple'|'wizard'} [activeTab]
     * @param {Object} value
     * @override
     * @returns {Object}
     */
    convertToServerFormat: function(strategy, activeTab, value) {
        var result = {};

        result['simple_price_' + value.performance_type.toUpperCase()] = value.price_performance;
        result.tab_simple = 1;

        return this.filterData(result, strategy, activeTab, 'server');
    },

    /**
     * Преобразует данные в значения, которые понимает конструктор ставок
     * @param  {Object} strategy
     * @param  {Object} value
     * @override
     * @returns {Object}
     */
    convertFromServerFormat: function(strategy, value) {
        var result = this.filterData(value, strategy, null, 'client');

        if (value.hasOwnProperty('simple_price_CPA')) {
            result.price_performance = value.simple_price_CPA;
            result.performance_type = u.performance.TYPE.CPA;
        }

        if (value.hasOwnProperty('simple_price_CPC')) {
            result.price_performance = value.simple_price_CPC;
            result.performance_type = u.performance.TYPE.CPC;
        }

        return result;
    }

});
