block('b-offline-set-phrases-prices')(
    addJs()(function() {
        return this.ctx.js || {};
    }),

    elem('popup').content()(function() {
        return {
            block: 'popup',
            mods: {
                'has-close': 'yes',
                animate: 'no',
                'with-controls': 'yes'
            },
            js: {
                directions: this.ctx.directions
            },
            content: [
                {
                    elem: 'tail'
                },
                {
                    elem: 'content',
                    mix: [{
                        block: 'b-offline-set-phrases-prices',
                        elem: 'content'
                    }],
                    content: [
                        {
                            elem: 'title',
                            mix: [{
                                block: 'b-offline-set-phrases-prices',
                                elem: 'title'
                            }],
                            content: iget2('b-offline-set-phrases-prices', 'success-bids-save-message', 'Запрос на изменение ставок принят')
                        },
                        {
                            elem: 'body',
                            content: [
                                {
                                    block: 'b-offline-set-phrases-prices',
                                    mods: this.elemMods,
                                    elem: 'edit-block',
                                    name: ''
                                },
                                {
                                    block: 'b-offline-set-phrases-prices',
                                    elem: 'success-block'
                                }
                            ]
                        },
                        {
                            elem: 'controls',
                            content: [
                                {
                                    block: 'button',
                                    mods: { theme: 'action', disabled: this.ctx.readonly ? 'yes' : 'no' },
                                    mix: [{
                                        block: 'b-offline-set-phrases-prices',
                                        elem: 'save'
                                    }],
                                    content: iget2('b-offline-set-phrases-prices', 'ustanovit', 'Установить')
                                },
                                {
                                    block: 'button',
                                    mix: [{
                                        block: 'b-offline-set-phrases-prices',
                                        elem: 'close'
                                    }],
                                    content: iget2('b-offline-set-phrases-prices', 'otmena', 'Отмена')
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'action-foot'
                }
            ]
        };
    }),

    elem('success-block').content()(function() {
        return [
            {
                elem: 'success-body',
                content: {
                    block: 'icon-text',
                    mods: { size: 'ms', theme: 'alert' },
                    text: [
                        iget2('b-offline-set-phrases-prices', 'stavki-sohranyatsya-cherez-5', 'Ставки сохранятся через 5 &ndash; 10 минут.'),
                        '&nbsp;',
                        iget2(
                            'b-offline-set-phrases-prices',
                            'success-bids-save-wait-warning',
                            'Во избежание путаницы рекомендуем в это время воздержаться от изменения ставок в кампании.'
                        ),
                        '&nbsp;',
                        iget2('b-offline-set-phrases-prices', 'aktivizaciya-izmeneniy-zaymet-eshche', 'Активизация изменений займет еще до 30 минут.')
                    ]
                }
            }
        ];
    }),

    elem('edit-block').content()(function() {
        return [
            {
                elem: 'text',
                content: iget2(
                    'b-offline-set-phrases-prices',
                    'edit-bid-block-description',
                    'Вы можете назначить ставку сразу для всех фраз кампании, активных на поиске и/или в сетях.'
                )
            },
            {
                elem: 'warning'
            },
            {
                elem: 'bs-rarely-loaded-warning'
            },
            {
                block: 'tabs',
                mods: {
                    control: 'menu',
                    size: 's',
                    theme: 'normal-red',
                    layout: 'horiz'
                },
                panes: 'offline-set-phrases',
                content: [
                    {
                        elem: 'tab',
                        content: {
                            block: 'link',
                            content: iget2('b-offline-set-phrases-prices', 'unified-bid', 'Единая ставка')
                        }
                    },
                    {
                        elem: 'tab',
                        content: {
                            block: 'link',
                            content: iget2('b-offline-set-phrases-prices', 'bids-master', 'Мастер ставок')
                        }
                    }
                ]
            },
            {
                block: 'tabs-panes',
                id: 'offline-set-phrases',
                mix: [{
                    block: 'b-offline-set-phrases-prices',
                    elem: 'constructor-wrapper'
                }],
                content: [
                    {
                        elem: 'pane',
                        elemMods: {
                            value: 'simple'
                        }
                    },
                    {
                        elem: 'pane',
                        elemMods: {
                            value: 'wizard'
                        }
                    }
                ]
            }
        ];
    })
);
