(function() {
    var confirm = BEM.blocks['b-confirm'],
        campsData = {};

    /**
     *
     * @event b-offline-set-phrases-prices#cost-set-click клик по кнопке "Установить"
     *
     * @fires b-offline-set-phrases-prices#cost-set-click
     */
    BEM.DOM.decl('b-offline-set-phrases-prices', {

        onSetMod: {
            js: function() {
                //кэшируем
                this._content = this.elem('content');
                this._title = this.elem('title');

                this._bindControls();

                //Чтобы избежать пачки перерисовок после группового изменения модели
                this._popupRepaintDebounce = $.debounce(this._popupRepaint, 100);
            },

            success: function() {
                this.afterCurrentEvent(function() {
                    this._popupRepaintDebounce();
                });
            }
        },

        onElemSetMod: {
            content: {
                success: function(elem, modName, modVal) {
                    var text = modVal == 'yes' ? iget2('b-offline-set-phrases-prices', 'zakryt', 'Закрыть') : iget2('b-offline-set-phrases-prices', 'otmena', 'Отмена');

                    this._closeButton.elem('text').html(text);
                    (modVal == 'yes') && this._title.text(iget2('b-offline-set-phrases-prices', 'success-bids-save-message', 'Запрос на изменение ставок принят'));
                },
                disabled: function(elem, modName, modVal) {
                    var text = modVal == 'yes' ? iget2('b-offline-set-phrases-prices', 'zakryt', 'Закрыть') : iget2('b-offline-set-phrases-prices', 'otmena', 'Отмена');

                    this._closeButton.elem('text').html(text);
                    (modVal == 'yes') && this._title.text('');
                }
            }
        },

        /**
         * Привязываем события к контролам внутри блока
         * @returns {BEM}
         */
        _bindControls: function() {
            this.findBlockInside('tabs-panes');

            BEM.blocks['i-utils'].graspSelf.call(this, {
                _tabbedPane: '? tabs inside',
                _tabsPanes: '? tabs-panes inside',
                _saveButton: 'button on save',
                _closeButton: 'button on close'
            });

            this._tabbedPane && this._tabbedPane.on('change', this.onChangeTab, this);
            this._saveButton.on('click', this.savePrices, this);
            this._closeButton.on('click', this.closePopup, this);

            this._saveButton.on('click', function() {
                this.trigger('cost-set-click');
            }, this);

            return this;
        },

        /**
         * Валидация введенных в конструктор ставок данных
         * @returns {Boolean}
         */
        _validatePricesConstructor: function() {
            var validateRes = this._pricesConstructor.validate();

            if (validateRes.errors) {
                confirm.open({
                    message: validateRes.errors.map(function(error) { return error.text; }),
                    type: 'alert',
                    withBullets: true,
                    limited: 'yes',
                    fromPopup: this._getPopup()
                });

                return false;
            }

            return true;

        },

        /**
         * Генерируем запрос для отправки данных на сервер аяксом
         * @returns {BEM}
         */
        _getRequest: function() {
            return BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                dataType: 'json',
                cache: false,
                type: 'POST',
                callbackCtx: this
            });
        },

         /**
         * Отправляем на сервер информацию об изменившихся ставках
         * @param {Object} clientValue
         * @returns {BEM}
         */
        _sendSavePricesRequest: function(clientValue) {
            var campModel = this._getCampaignModel(),
                strategy = campModel.get('strategy'),
                value = this.convertToServerFormat(strategy, this._activeTab, clientValue);

            value = $.extend(value, { cmd: 'setAutoPriceAjax', cid: campModel.get('cid') });

            BEM.blocks['b-metrika2'].params({
                params: {
                    'prices-constructor-usage': value.tab_simple === 1 ?
                        'simple' :
                        'wizard'
                }
            });

            this._getRequest().get(value,
                function(result) {
                    if (result.success) {
                        this.setMod(this._content, 'success', 'yes');
                    } else {
                        confirm.alert(result.error, this._getPopup());
                        this._saveButton.delMod('disabled');
                    }
                }, function() {
                    confirm.alert(
                        iget2(
                            'b-offline-set-phrases-prices',
                            'ne-poluchaetsya-vypolnit-zapros',
                            'Не получается выполнить запрос. Проверьте подключение к интернету'
                        ),
                        this._getPopup());
                });

            return this;
        },

        /**
         * Сохраняем данные конструктора
         * @returns {BEM}
         */
        savePrices: function() {
            if (!this._validatePricesConstructor()) return this;

            var value = this.getDataFromPricesConstructor(),
                dfd = $.Deferred();

            //DIRECTSUP-13659 сервер не принимает значения true/false - только 1/0
            $.each(value, function(name, val) {
                if (val === true) value[name] = 1;
                if (val === false) value[name] = 0;
            });

            this._saveButton.setMod('disabled', 'yes');

            this._setPricesToCampOptions(value, dfd);

            dfd.done(function() {
                this._sendSavePricesRequest(value);
            });

            return this;
        },

        /**
         * Возвращает данные от конструктора ставок
         * @returns {Object}
         */
        getDataFromPricesConstructor: function() {
            return this._pricesConstructor.getData();
        },

        /**
         * Закрываем попап
         * @returns {BEM}
         */
        closePopup: function() {
            this._getPopup().hide();

            return this;
        },

        /**
         * Чистим обработчики событий, которые висят на внутренностях попапа
         * @returns {BEM}
         */
        _onPopupClose: function() {
            this._bindConstructorEvents({ isBind: false });

            return this;
        },

        /**
         * Переключили таб в конструкторе ставок
         * @param {Event} e
         * @param {Object} data
         * @returns {BEM}
         */
        onChangeTab: function(e, data) {
            var tabSelector = this._tabsPanes.buildSelector('pane'),
                tab = this._tabsPanes.domElem.find(tabSelector).eq(data.currentIndex),
                value = this._tabsPanes.getMod(tab, 'value'),
                rootNode = this._getPopup().domElem,
                warningElem = this.findElem(rootNode, 'warning');

            this._activeTab = value;
            this._pricesConstructor && this._pricesConstructor.setSimple(value === 'simple');

            this
                .setMod(this._content, 'tab', value)
                .afterCurrentEvent(function() {
                    this._popupRepaintDebounce();
                });

            warningElem.html(BEMHTML.apply(this.getWarningMessage(warningElem, value === 'wizard')));

            return this;
        },

        /**
         * Возвращает текст-предупреждение зависимый от типа применяемой стратегии
         * @param {domElem} warningElem - элемент с предупреждением
         * @param {Boolean} isWizard - флаг, что открыт мастер цен
         * @returns {String}
         * */
        getWarningMessage: function(warningElem, isWizard) {
            var messages = [
                    [
                        iget2('b-offline-set-phrases-prices', 'stavki-sohranyatsya-cherez-5', 'Ставки сохранятся через 5 &ndash; 10 минут.'),
                        iget2(
                            'b-offline-set-phrases-prices',
                            'success-bids-save-wait-warning',
                            'Во избежание путаницы рекомендуем в это время воздержаться от изменения ставок в кампании.'
                        )
                    ].join(' '),
                    iget2('b-offline-set-phrases-prices', 'aktivizaciya-izmeneniy-zaymet-eshche', 'Активизация изменений займет еще до 30 минут.')
                ],
                campaignModel = this._getCampaignModel(),
                strategy = campaignModel.get('strategy'),
                mediaType = campaignModel.get('mediaType');

            // если нет сетей на ТГО/РМП, то ставки на интересы/ретаргетинг/автотаргетинг поставить нельзя
            if (!u._.contains([
                'performance', 'dynamic', 'cpm_banner', 'cpm_deals', 'mcbanner', 'cpm_yndx_frontpage', 'content_promotion'
            ], mediaType)) {
                // на поисковые стратегии или через мастер цен ставки на ретаргетинг/интересы не ставятся
                if (strategy.is_net_stop || isWizard) {
                    messages.push(iget2(
                        'b-offline-set-phrases-prices',
                        'stavki-ne-budut-primeneny',
                        'Ставки не будут применены к условиям подбора аудитории и интересам.'
                    ));
                }
            }

            messages.push(iget2(
                'b-offline-set-phrases-prices',
                'bid-correction-warning',
                'Ставки не учитывают корректировки заданные на кампанию или группу.'
            ));

            return [
                {
                    block: 'b-offline-set-phrases-prices',
                    elem: 'warning-title',
                    content: iget2('b-offline-set-phrases-prices', 'obratite-vnimanie', 'Обратите внимание:')
                },
                messages.map(function(text) {
                    return {
                        block: 'b-offline-set-phrases-prices',
                        elem: 'warning-item',
                        content: text
                    };
                })
            ];
        },

        /**
         * Открывает/закрывает попап конструктора и выставляет данные в соответствии с кампанией
         * @param {Object} e
         * @returns {BEM}
         */
        reset: function(e) {
            var prevCampModel = this._getCampaignModel(),
                prevCid = prevCampModel && prevCampModel.get('cid'),
                elem = e.data.domElem,
                params = this.elemParams(this.findElem(elem, 'toggle')),
                rootNode = this._getPopup().domElem,
                warningElem = this.findElem(rootNode, 'warning'),
                isWizard = campsData[prevCid] ? !campsData[prevCid].is_simple : false,
                rarelyLoadedWarningHelpUrl;

            if (this._isPopupShown()) {
                this.closePopup();

                if (params.modelParams.id == prevCid) return this;
            }

            this.currentBtn = elem;

            this._campModel = BEM.MODEL.getOrCreate(params.modelParams);

            rarelyLoadedWarningHelpUrl = u.getHelpUrl(
                u.getRarelyServedHelpId({ groupType: this._campModel.get('mediaType') })
            );

            warningElem.html(BEMHTML.apply(this.getWarningMessage(warningElem, isWizard)));

            BEM.DOM.update(rootNode.find(this.buildSelector('bs-rarely-loaded-warning')), BEMHTML.apply([
                iget2('b-offline-set-phrases-prices', 'stavki-dlya-grupp-v', 'Ставки для групп, в которых мало показов, установлены не будут.'),
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    url: rarelyLoadedWarningHelpUrl,
                    text: iget2('b-offline-set-phrases-prices', 'podrobnee-190', 'Подробнее')
                }
            ]));

            return this._getConstructorData(this._onNewDataLoaded);
        },

        /**
         * Добавляем спиннер в DOM-дерево и показываем ее
         * @returns {BEM}
         */
        addSpin: function() {
            this.spin = $(BEMHTML.apply({
                mix: [{ block: 'b-offline-set-phrases-prices', elem: 'spin' }],
                block: 'spin',
                mods: { theme: 'gray-16' }
            })).bem('spin');

            BEM.DOM.after(this.currentBtn, this.spin.domElem);

            this.spin.setMod('progress', 'yes');

            return this;
        },

        /**
         * Удаляем спиннер из DOM-дерева
         * @returns {BEM}
         */
        removeSpin: function() {
            if (!this.spin) return this;

            this.spin.destruct();
            this.spin = null;

            return this;
        },

        /**
         * Показывается ли данный попап
         * @returns {Boolean}
         */
        _isPopupShown: function() {
            return this._getPopup().isShown();
        },

        /**
         * Привязываемся/отвязываемся от событий модели
         * @param {Object} data
         * @param {Boolean} data.isBind
         * @returns {BEM}
         */
        _bindConstructorEvents: function(data) {
            this._pricesConstructor &&
                this._pricesConstructor[data.isBind ? 'on' : 'un']('change-size', this._popupRepaintDebounce, this);

            return this;
        },

        /**
         * Загружена новая информация для страницы кампании
         * @param {Object} data
         * @returns {BEM}
         */
        _onNewDataLoaded: function(data) {
            var campModel = this._getCampaignModel();

            this._title.text(this._getTitleText());

            data.is_simple = data.is_simple === undefined ? 1 : data.is_simple;

            this._activeTab = data.is_simple ? 'simple' : 'wizard';

            this._updatePricesConstructorHtml(data);
            this._pricesConstructor = this.findBlockInside(this._content, 'b-prices-constructor');
            this._bindConstructorEvents({ isBind: true });

            this._activeTab = data.is_simple !== undefined ? (data.is_simple ? 'simple' : 'wizard') : 'simple';

            //если текущие данные на текущем состоянии конструктора оказались недопустимыми - откатываем на дефолтные
            if (this._pricesConstructor && !this._pricesConstructor.validate().valid) {
                this._pricesConstructor.setDefault();
            }

            return this._openPopup();
        },

        /**
         * Возвращает текст заголовка попапа
         */
        _getTitleText: function() {

            return iget2('b-offline-set-phrases-prices', 'bids-for-all-campaign', 'Ставки для всей кампании');
        },

        /**
         * Обновляет конструктор цен в соответсвии с новыми данными
         * @param {Object} data
         */
        _updatePricesConstructorHtml: function(data) {
            var strategy = this._getCampaignModel().get('strategy');

            // т.к. у нас b-prices-constructor имеет две DOM ноды, сначала вставляем его в html
            // а уже после руками инициализируем
            // при этом data модифицируется в b-prices-constructor.bemhtml.js
            this._tabsPanes && this._tabsPanes.findPane('value', 'simple')
                .html(BEMHTML.apply(this._getConstructorJSON(strategy, 'simple', data)));

            this._tabsPanes && this._tabsPanes.findPane('value', 'wizard')
                .html(BEMHTML.apply(this._getConstructorJSON(strategy, 'wizard', data)));

            BEM.DOM.init(this._content);
        },

        /**
         * Возвращает bemjson элемента конструктора c заданным type
         * @param {Object} strategy
         * @param {String} strategy.name
         * @param {Object} strategy.search
         * @param {String} strategy.search.name
         * @param {'simple'|'wizard'} type
         * @param {Object} data
         * @returns {Array}
         */
        _getConstructorJSON: function(strategy, type, data) {
            var res = [],
                isDiffPlace = strategy.name == 'different_places';

            if (isDiffPlace) {
                if (strategy.search.name !== 'stop') {
                    res.push(this._getConstructorJSONForm(type, 'search', data));
                }

                res.push(this._getConstructorJSONForm(type, 'context', data));
            } else {
                res.push(this._getConstructorJSONForm(type, 'common', data));
            }

            return res;
        },

        /**
         * Возвращает bemjson элемента конструктора
         * @param {'simple'|'wizard'} type
         * @param {'search'|'context'|'common'} formType
         * @param {Object} data
         * @returns {Object}
         */
        _getConstructorJSONForm: function(type, formType, data) {
            var campModel = this._getCampaignModel(),
                strategy = campModel.get('strategy'),
                currency = campModel.get('currency'),
                currencyName = u.currencies.getName(currency),
                minPay = u.currencies.getConst(currency, 'BIG_RATE'),
                cid = campModel.get('cid');

            return {
                block: 'b-prices-constructor',
                mods: {
                    type: u.beminize(campModel.get('mediaType'))
                },
                mix: {
                    block: 'b-offline-set-phrases-prices',
                    elem: 'constructor-item'
                },
                modelParams: {
                    id: cid,
                    parentName: campModel.name,
                    parentId: cid
                },
                viewMode: 'offline',
                formType: formType,
                strategy: strategy,
                showBothPlatforms: true,
                minPay: minPay,
                currency: currency,
                currencyName: currencyName,
                isSimple: type == 'simple',
                savedData: data
            };
        },

        /**
         * Открываем попап
         * @returns {BEM}
         */
        _openPopup: function() {
            var content = this._content;

            this.delMod(content, 'success');
            this.setMod(content, 'disabled', '');

            if (!this.params.readonly) {
                this._saveButton.delMod('disabled').delMod('focused');
            }
            this._tabbedPane && this._tabbedPane.activate(this._activeTab == 'simple' ? 0 : 1);

            this.setMod(content, 'tab', this._activeTab);

            this.afterCurrentEvent(function() {
                this._getPopup().show(this.currentBtn);
                this._popupRepaint();
            });

            return this;
        },

        /**
         * Записывает значения полей конструктора в CAMPAIGN_OPTIONS
         * @param {Object} clientValue
         * @param {Object} promise
         * @returns {BEM}
         */
        _setPricesToCampOptions: function(clientValue, promise) {
            var campModel = this._getCampaignModel(),
                cid = campModel.get('cid'),
                data = this.filterToCampOptionsFormat(clientValue, campModel.get('strategy'), this._activeTab);

            campsData[cid] = data;

            u.campOptions.request(
                { offline_price_editor: JSON.stringify(data), cid: cid },
                function() {
                    promise.resolveWith(this);
                },
                this
            );

            return this;
        },

        /**
         * Фильтруем значения перед сохранением в campOptions
         * @param {Object} clientValue
         * @param {Object} strategy
         * @param {'simple'|'wizard'} activeTab
         * @returns {Object}
         */
        filterToCampOptionsFormat: function(clientValue, strategy, activeTab) {
            return this.filterData(clientValue, strategy, activeTab, 'client');
        },

        /**
         * Данные пришли в формате, в котором хранятся на сервере
         * @param {Object} data
         * @returns {Boolean}
         */
        _isServerFormat: function(data) {
            return (data.hasOwnProperty('simple_platform') || data.hasOwnProperty('wizard_platform') ||
                    data.hasOwnProperty('single_price_ctx') || data.hasOwnProperty('single_price'));
        },

        /**
         * Приводим данные сохраненные на сервере к актуальному формату
         * @param {Object} data
         * @returns {Object}
         */
        _prepareData: function(data) {
            var res = {},
                strategy = this._getCampaignModel().get('strategy');

            if (this._isServerFormat(data)) {
                res = this.convertFromServerFormat(strategy, data);
            } else {
                res = $.extend({}, data);
            }

            res.is_disabled = false;

            return res;
        },

        /**
         * Извлекает ранее сохраненные данные для конструктора ставок на данной кампании
         * @param {Function} callback
         * @returns {BEM}
         */
        _getConstructorData: function(callback) {
            var cid = this._getCampaignModel().get('cid');

            if (campsData[cid]) {
                return callback.call(this, campsData[cid]);
            }
            var res = {};

            if (this.getMod('multi') != 'yes') {
                res = BEM.blocks['i-utils'].campOptions.get('offline_price_editor');

                try {
                    res = JSON.parse(res || '{}');
                } catch (e) {}

                campsData[cid] = this._prepareData(res);

                return callback.call(this, campsData[cid]);
            } else {
                this.addSpin();

                BEM.blocks['i-utils'].campOptions.request(
                    { get_camp_options: 1, cid: cid },
                    function(value) {
                        try {
                            res = this._prepareData(JSON.parse(value.offline_price_editor || '{}'));
                        } catch (e) {}

                        campsData[cid] = res;
                        this.removeSpin();
                        callback.call(this, res);
                    }, this);

                return this;
            }
        },

        /**
         * Возвращает актуальную модель кампании
         * @returns {BEM.MODEL}
         * @private
         */
        _getCampaignModel: function() {
            return this._campModel;
        },

        _popup: null,

        /**
         * Возвращает объект попапа
         * @returns {BEM}
         * @private
         */
        _getPopup: function() {
            if (this._popup) return this._popup;

            this._popup = this.findBlockInside('popup')
                .on('hide', this._onPopupClose, this);

            return this._popup;
        },

        /**
         * Перерисовывает попап
         * @returns {BEM}
         * @private
         */
        _popupRepaint: function() {
            var popup = this._getPopup();

            if (!popup.isShown()) return this;

            popup.repaint();

            return this;
        },

        CLIENT_WHITE_LIST: {
            'common-simple': ['price_context', 'price_search', 'platform', 'is_simple'],
            'common-wizard': [
                'price_context', 'price_search', 'platform', 'is_simple', 'position_ctr_correction', 'context_scope',
                'proc_search'
            ],
            'both-simple': ['price_context', 'price_search', 'is_simple', 'context_toggle', 'search_toggle'],
            'context-simple': ['price_context', 'is_simple', 'context_toggle'],
            'both-wizard': [
                'price_context', 'price_search', 'is_simple', 'context_toggle', 'search_toggle', 'position_ctr_correction',
                'context_scope', 'proc_search', 'proc_context'
            ],
            'context-wizard': ['price_context', 'is_simple', 'context_toggle', 'context_scope', 'proc_context']
        },

        SERVER_WHITE_LIST: {
            'common-simple': ['tab_simple', 'simple_platform', 'simple_price'],
            'common-wizard': [
                'tab_simple', 'wizard_search_phrases', 'wizard_network_scope', 'wizard_context_retargetings',
                'wizard_context_phrases', 'wizard_platform', 'wizard_search_proc',
                'wizard_search_max_price', 'wizard_network_max_price', 'wizard_search_position_ctr_correction'
            ],
            'both-simple': ['tab_simple', 'wizard_ctx', 'single_price_ctx', 'single_price', 'wizard_search'],
            'context-simple': ['tab_simple', 'wizard_ctx', 'single_price_ctx'],
            'both-wizard': [
                'tab_simple', 'wizard_ctx', 'ctx_max_price', 'search_proc_ctx', 'wizard_ctx_retargetings',
                'wizard_ctx_phrases', 'ctx_scope', 'ctx_proc', 'search_max_price', 'wizard_search',
                'wizard_search_phrases', 'search_position_ctr_correction', 'search_proc'
            ],
            'context-wizard': [
                'tab_simple', 'wizard_ctx', 'ctx_max_price', 'search_proc_ctx', 'wizard_ctx_retargetings',
                'wizard_ctx_phrases', 'ctx_scope', 'ctx_proc'
            ]
        },

        /**
         * Возвращает текущий тип конструктора ставок
         * @param {Object} strategy
         * @param {'simple'|'wizard'} activeTab
         * @returns {string}
         * @private
         */
        getConstructorType: function(strategy, activeTab) {
            var type = activeTab == 'simple' ? 'simple' : 'wizard';

            if (strategy.search.name === 'stop') {

                return 'context-' + type;
            } else if (strategy.name != 'different_places') {

                return 'common-' + type;
            }

            return 'both-' + type;
        },

        /**
         * Возвращает подходящий для активной вкладки/стратегии белый лист полей
         * @param {Object} strategy
         * @param {'simple'|'wizard'} activeTab
         * @param {'client'|'server'} filterType
         * @returns {Array}
         */
        getCurrentWhiteList: function(strategy, activeTab, filterType) {
            var witeListType = filterType == 'client' ? 'CLIENT_WHITE_LIST' : 'SERVER_WHITE_LIST';

            return this[witeListType][this.getConstructorType(strategy, activeTab)];
        },

        /**
         * Фильтрует данные, уходящие на сохранение
         * @param {Object} data
         * @param {Object} strategy
         * @param {'simple'|'wizard'} activeTab
         * @param {'client'|'server'} filterType
         * @returns {Object}
         */
        filterData: function(data, strategy, activeTab, filterType) {
            var res = {},
                whiteList = this.getCurrentWhiteList(strategy, activeTab, filterType);

            whiteList.forEach(function(field) {
                res[field] = data[field];
            });

            return res;
        },

        /**
         *
         * @param {Object} strategy
         * @param {'simple'|'wizard'} activeTab
         * @param {Object} value
         * @returns {Object}
         */
        convertToServerFormat: function(strategy, activeTab, value) {
            var result = {};

            if (activeTab == 'simple') {
                result.tab_simple = 1;

                if (strategy.name == 'different_places') {
                    if (value.context_toggle) {
                        result.wizard_ctx = value.context_toggle;
                        result.single_price_ctx = value.price_context;
                    }

                    if (strategy.search.name != 'stop' && value.search_toggle) {
                        result.wizard_search = value.search_toggle;
                        result.single_price = value.price_search;
                    }

                } else {
                    result.simple_platform = value.platform;
                    (result.simple_platform == 'context') && (result.simple_platform = 'network');
                    result.simple_price = value['price_' + value.platform];
                }
            } else {
                result.tab_simple = 0;
                if (strategy.name == 'different_places') {
                    if (value.context_toggle) {
                        result.wizard_ctx = value.context_toggle;
                        result.ctx_max_price = value.price_context;
                        result.search_proc_ctx = value.proc_context;
                        result.wizard_ctx_retargetings = 0;
                        result.wizard_ctx_phrases = 1;
                        result.ctx_scope = value.context_scope;
                        result.ctx_proc = value.proc_context;
                    }

                    if (strategy.search.name != 'stop' && value.search_toggle) {
                        result.search_max_price = value.price_search;
                        result.wizard_search = value.search_toggle;
                        result.wizard_search_phrases = 1;
                        result.search_position_ctr_correction = value.position_ctr_correction;
                        result.search_proc = value.proc_search;
                    }

                } else {
                    result.wizard_platform = value.platform;
                    (result.wizard_platform == 'context') && (result.wizard_platform = 'network');
                    result.wizard_search_max_price = value.price_search;
                    result.wizard_network_max_price = value.price_context;
                    result.wizard_search_position_ctr_correction = value.position_ctr_correction;
                    result.wizard_search_proc = value.proc_search;

                    result.wizard_search_phrases = 1;
                    result.wizard_context_phrases = 1;
                    result.wizard_context_retargetings = 0;
                    result.wizard_network_scope = value.context_scope;
                }
            }

            return this.filterData(result, strategy, activeTab, 'server');
        },

        /**
         * Преобразовываем данные, сохраненные сервером в значения, которые понимает конструктор ставок
         * @param  {Object} strategy
         * @param  {Object} value
         * @returns {Object}
         */
        convertFromServerFormat: function(strategy, value) {
            var result = {};

            if (value.tab_simple) {
                result.is_simple = true;

                if (strategy.name == 'different_places') {
                    result.price_context = value.single_price_ctx;
                    result.context_toggle = value.wizard_ctx;

                    if (strategy.search.name != 'stop') {
                        result.price_search = value.single_price;
                        result.search_toggle = value.wizard_search;
                    }
                } else {
                    result.platform = value.simple_platform;
                    (result.platform == 'network') && (result.platform = 'context');
                    result.price_context = value.simple_price;
                    result.price_search = value.simple_price;
                }

            } else {
                result.is_simple = false;
                if (strategy.name == 'different_places') {
                    result.context_toggle = value.wizard_ctx;

                    result.price_context = value.ctx_max_price;
                    result.proc_context = value.search_proc_ctx;
                    result.context_scope = value.ctx_scope;
                    result.proc_context = value.ctx_proc;

                    if (strategy.search.name != 'stop') {
                        result.search_toggle = value.wizard_search;
                        result.price_search = value.search_max_price;
                        result.position_ctr_correction = value.search_position_ctr_correction;
                        result.proc_search = value.search_proc;
                    }
                } else {
                    result.platform = value.wizard_platform;
                    (result.platform == 'network') && (result.platform = 'context');
                    result.price_search = value.wizard_search_max_price;
                    result.price_context = value.wizard_network_max_price;
                    result.position_ctr_correction = value.wizard_search_position_ctr_correction;
                    result.proc_search = value.wizard_search_proc;

                    result.context_scope = value.wizard_network_scope;
                }
            }

            return result;
        }

    }, {

        live: function() {
            this.liveBindTo('toggle', 'click', function(e) {
                this.reset(e);
            });
        }
    });

})();
