block('b-online-set-phrases-prices').mod('type', 'dynamic-groups')(
    def()(function() {
        return applyNext({
            savedData: u._.assign({}, this.savedData, {
                is_simple: true
            })
        });
    }),

    elem('title').content()(function() {
        return iget2(
            'b-online-set-phrases-prices',
            'set-bid-for-all-page-conditions',
            'Установить ставку для всех условий показа на странице'
        );
    }),

    elem('form-wrapper').content()(function() {
        return [
            {
                elem: 'prices-constructors',
                modelParams: this.ctx.modelParams,
                showBothPlatforms: this.ctx.showBothPlatforms
            },
            {
                block: 'button',
                mods: {
                    size: 's',
                    theme: 'action',
                    // от БК не приходят торги (о том как протестировать кейс можно почитать в md)
                    disabled: this.data.campaign.nobsdata ? 'yes' : ''
                },
                mix: {
                    block: 'b-online-set-phrases-prices',
                    elem: 'save'
                },
                content: iget2('b-online-set-phrases-prices', 'set', 'Назначить')
            },
            { elem: 'spin' }
        ];
    }),

    elem('prices-constructor').replace()(function() {
        var modelParams = this.ctx.modelParams,
            formType = this.ctx.formType;

        return {
            block: 'b-prices-constructor',
            mods: {
                type: 'dynamic'
            },
            mix: {
                block: 'b-online-set-phrases-prices',
                elem: 'prices-constructor',
                elemMods: {
                    type: 'wizard',
                    'form-type': formType
                }
            },
            modelParams: {
                id: this.data.campaign.cid,
                parentName: modelParams.name,
                parentId: modelParams.id
            },
            formType: formType,
            isSimple: true,
            savedData: this.savedData,
            strategy: this.data.campaign.strategy,
            currencyName: u.currencies.getName(this.currency),
            minPay: this.minPay,
            currency: this.currency,
            showBothPlatforms: this.ctx.showBothPlatforms,
            viewMode: 'offline'
        };
    })
);
