/**
 * @typedef {Object} BidablePrices
 * @property {Number} price_search цена на поиске
 * @property {Number} price_context цена на тематических площадках
 */

(function() {
    /**
     * Рассчитывает и устанавливает новые значения ставок для условий нацеливания на поиске
     * @param {BidablePrices} value цена в конструкторе ставок
     */
    var updateSearchPricesForDynamicConditions = function(value) {
            ['dm-dynamic-condition', 'dm-feed-filter'].forEach(function(name) {
                BEM.MODEL.forEachModel(function() {
                    if (this.get('is_suspended') || this.get('is_deleted')) return true;

                    this.set('price', value.price_search);
                }, { name: name });
            }, this);
        },
        /**
         * Рассчитывает и устанавливает новые значения ставок для условий нацеливания на поиске
         * @param {BidablePrices} value цена в конструкторе ставок
         * @param {String} strategy название стратегии
         */
        updateContextPricesForDynamicConditions = function(value, strategy) {
            ['dm-dynamic-condition', 'dm-feed-filter'].forEach(function(name) {
                BEM.MODEL.forEachModel(function() {
                    if (this.get('is_suspended') || this.get('is_deleted') ||
                        strategy != 'different_places') {

                        return true;
                    }

                    this.set('price_context', value.price_context);
                }, { name: name });
            }, this);
        };

    BEM.DOM.decl({ block: 'b-online-set-phrases-prices', modName: 'type', modVal: 'dynamic-groups' }, {
        /**
         * * Изменяет ставки на кампании в соответствии с установленными в конструкторе ставок параметрами
         * @param {Object} value - параметры конструктора ставок
         * @override {b-online-set-phrases-prices}
         * @private
         */
        _updatePrices: function(value) {
            u.campOptions.set('price_editor', JSON.stringify(value));

            var strategy = this._campModel.get('strategy_name');

            if (strategy === 'different_places') {
                if (this._isSearchPlace()) {
                    updateSearchPricesForDynamicConditions(value);
                }
                if (this._isContextPlace()) {
                    updateContextPricesForDynamicConditions(value, strategy);
                }
            } else {
                updateSearchPricesForDynamicConditions(value);
            }

            return this;
        }

    });

}());
